<?php
// Veritabanı bağlantısını ve yapılandırmayı dahil et
require_once __DIR__ . '/../config/db_connect.php';

// Sayfa başlığını ayarla
$page_title = "Yeni Müşteri Ekle";

// Header'ı dahil et (Oturum kontrolünü ve CSRF token'ı yapar)
require_once __DIR__ . '/includes/header.php'; // $csrf_token burada tanımlanır

$error_message = '';
$name = '';
$email = '';
$company = '';
$phone = '';
$is_active = 1; // Varsayılan aktif

// Form gönderildi mi kontrol et (POST)
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    // CSRF Token Doğrulama
    if (!isset($_POST['csrf_token']) || !hash_equals($_SESSION['csrf_token'], $_POST['csrf_token'])) {
        $error_message = "Geçersiz veya eksik güvenlik token'ı.";
        // Hata durumunda formu tekrar göstermek için değişkenleri ayarla
        $name = trim($_POST['name'] ?? '');
        $email = trim($_POST['email'] ?? '');
        $company = trim($_POST['company'] ?? '');
        $phone = trim($_POST['phone'] ?? '');
        $is_active = isset($_POST['is_active']) ? 1 : 0;
    } else {
        // Token geçerli, işlemlere devam et
        $name = trim($_POST['name'] ?? '');
        $email = trim($_POST['email'] ?? '');
        $company = trim($_POST['company'] ?? '');
        $phone = trim($_POST['phone'] ?? '');
        $is_active = isset($_POST['is_active']) ? 1 : 0;
        // Müşteri paneli şifresi (opsiyonel, şimdilik eklemiyoruz)
        // $password = $_POST['password'] ?? '';
        // $password_hash = null;

        // Doğrulama
        if (empty($name)) {
            $error_message = "Müşteri adı boş bırakılamaz.";
        } elseif (!empty($email) && !filter_var($email, FILTER_VALIDATE_EMAIL)) {
            $error_message = "Geçersiz e-posta adresi formatı.";
        }
        // Opsiyonel: Müşteri paneli şifresi için doğrulama
        // elseif (!empty($password) && strlen($password) < 6) {
        //     $error_message = "Şifre en az 6 karakter olmalıdır.";
        // }
        else {
            // Opsiyonel: Şifre hash'leme
            // if (!empty($password)) {
            //     $password_hash = password_hash($password, PASSWORD_DEFAULT);
            // }

            // Veritabanına ekleme işlemi
            // Şimdilik password_hash olmadan ekleyelim
            $sql = "INSERT INTO customers (name, email, company, phone, is_active) VALUES (?, ?, ?, ?, ?)";
            $stmt = $conn->prepare($sql);

            if ($stmt === false) {
                error_log("Add Customer - SQL prepare hatası: " . $conn->error);
                $error_message = "Müşteri eklenirken bir veritabanı hatası oluştu (prepare).";
            } else {
                $stmt->bind_param("ssssi", $name, $email, $company, $phone, $is_active);
                if ($stmt->execute()) {
                    $_SESSION['success_message'] = "Müşteri başarıyla eklendi.";
                    header("Location: customers.php");
                    exit;
                } else {
                    error_log("Add Customer - SQL execute hatası: " . $stmt->error);
                    if ($conn->errno == 1062) { // Duplicate entry for email
                         $error_message = "Bu e-posta adresi zaten kayıtlı.";
                    } else {
                         $error_message = "Müşteri eklenirken bir veritabanı hatası oluştu (execute).";
                    }
                }
                $stmt->close();
            }
        }
    } // CSRF else sonu
} // POST isteği sonu

?>

<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2"><i class="bi bi-person-plus-fill"></i> <?php echo htmlspecialchars($page_title); ?></h1>
</div>

<?php if ($error_message): ?>
    <div class="alert alert-danger" role="alert">
        <?php echo htmlspecialchars($error_message); ?>
    </div>
<?php endif; ?>

<div class="card shadow-sm">
    <div class="card-header">
        Yeni Müşteri Bilgileri
    </div>
    <div class="card-body">
        <form action="add_customer.php" method="post">
            <!-- CSRF Token -->
            <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars($csrf_token); ?>">

            <div class="row g-3">
                <div class="col-md-6">
                    <label for="name" class="form-label">Ad Soyad <span class="text-danger">*</span></label>
                    <input type="text" class="form-control" id="name" name="name" value="<?php echo htmlspecialchars($name); ?>" required>
                </div>
                <div class="col-md-6">
                    <label for="email" class="form-label">E-posta</label>
                    <input type="email" class="form-control" id="email" name="email" value="<?php echo htmlspecialchars($email); ?>">
                    <div class="form-text">Müşteri paneli girişi için kullanılabilir (eğer panel yapılırsa). Benzersiz olmalıdır.</div>
                </div>
                <div class="col-md-6">
                    <label for="company" class="form-label">Şirket</label>
                    <input type="text" class="form-control" id="company" name="company" value="<?php echo htmlspecialchars($company); ?>">
                </div>
                <div class="col-md-6">
                    <label for="phone" class="form-label">Telefon</label>
                    <input type="tel" class="form-control" id="phone" name="phone" value="<?php echo htmlspecialchars($phone); ?>">
                </div>
                <!-- Müşteri Paneli Şifresi (Opsiyonel) -->
                <!--
                <div class="col-md-6">
                    <label for="password" class="form-label">Şifre (Müşteri Paneli İçin)</label>
                    <input type="password" class="form-control" id="password" name="password">
                    <div class="form-text">Boş bırakılırsa müşteri panele giriş yapamaz.</div>
                </div>
                -->
                 <div class="col-12">
                    <div class="form-check form-switch">
                      <input class="form-check-input" type="checkbox" role="switch" id="is_active" name="is_active" value="1" <?php echo ($is_active == 1) ? 'checked' : ''; ?>>
                      <label class="form-check-label" for="is_active">Müşteri Aktif</label>
                    </div>
                </div>
            </div>

            <hr class="my-4">

            <button type="submit" class="btn btn-success"><i class="bi bi-check-circle-fill"></i> Müşteriyi Ekle</button>
            <a href="customers.php" class="btn btn-secondary"><i class="bi bi-x-circle-fill"></i> İptal</a>
        </form>
    </div>
</div>

<?php
// Footer'ı dahil et
require_once __DIR__ . '/includes/footer.php';
?>
