<?php
// Veritabanı bağlantısını ve yapılandırmayı dahil et
require_once __DIR__ . '/../config/db_connect.php';

// Sayfa başlığını ayarla
$page_title = "Yeni Ürün Ekle";

// Header'ı dahil et (Oturum kontrolünü ve CSRF token'ı yapar)
require_once __DIR__ . '/includes/header.php'; // $csrf_token burada tanımlanır

$error_message = ''; // Form hataları için
$product_name = '';
$product_description = '';
$critical_files = ''; // Tekrar eklendi
$injection_placeholder = '// LISANS_KODU_BURADA'; // Varsayılan

// Ürün ZIP dosyaları için yükleme klasörü
$product_zips_dir = __DIR__ . '/../uploads/products/';
if (!is_dir($product_zips_dir)) {
    mkdir($product_zips_dir, 0775, true);
}

// Form gönderildi mi kontrol et (POST)
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    // CSRF Token Doğrulama
    if (!isset($_POST['csrf_token']) || !hash_equals($_SESSION['csrf_token'], $_POST['csrf_token'])) {
        $error_message = "Geçersiz veya eksik güvenlik token'ı.";
        // Hata durumunda formu tekrar göstermek için değişkenleri ayarla
        $product_name = trim($_POST['product_name'] ?? '');
        $product_description = trim($_POST['product_description'] ?? '');
        $critical_files = trim($_POST['critical_files'] ?? ''); // Tekrar eklendi
        $injection_placeholder = trim($_POST['injection_placeholder'] ?? '// LISANS_KODU_BURADA');
    } else {
        // Token geçerli, işlemlere devam et
        $product_name = trim($_POST['product_name'] ?? '');
        $product_description = trim($_POST['product_description'] ?? '');
        $critical_files = trim($_POST['critical_files'] ?? ''); // Tekrar eklendi
        $injection_placeholder = trim($_POST['injection_placeholder'] ?? '// LISANS_KODU_BURADA');
        $original_zip_file = $_FILES['original_zip'] ?? null;
        $original_zip_path = null;
        $target_path = null;

        // Doğrulama
        if (empty($product_name)) {
            $error_message = "Ürün adı boş bırakılamaz.";
        // } elseif (empty($critical_files)) { // Artık zorunlu değil, kaldırıldı
        //      $error_message = "En az bir kritik dosya adı belirtmelisiniz.";
        } elseif (empty($injection_placeholder)) {
            $error_message = "Enjeksiyon yer tutucusu boş bırakılamaz.";
        } elseif (!$original_zip_file || $original_zip_file['error'] !== UPLOAD_ERR_OK) {
            $error_message = "Orijinal ZIP dosyası yüklenirken bir hata oluştu veya dosya seçilmedi. (Hata Kodu: " . ($original_zip_file['error'] ?? 'Yok') . ")";
        } else {
            // ZIP dosyası doğrulama
            $file_info = pathinfo($original_zip_file['name']);
            $file_extension = strtolower($file_info['extension'] ?? '');
            if ($file_extension !== 'zip') {
                $error_message = "Lütfen geçerli bir ZIP dosyası yükleyin.";
            } else {
                // Güvenli dosya adı oluştur ve taşı
                $safe_filename = uniqid('prod_', true) . '.zip';
                $target_path = $product_zips_dir . $safe_filename;

                if (move_uploaded_file($original_zip_file['tmp_name'], $target_path)) {
                    $original_zip_path = 'uploads/products/' . $safe_filename;
                } else {
                    $error_message = "ZIP dosyası sunucuya taşınamadı. Klasör izinlerini kontrol edin.";
                }
            }
        }

        // Hata yoksa veritabanına ekle
        if (empty($error_message) && $original_zip_path !== null) {
            // SQL sorgusu critical_files'ı içerecek şekilde güncellendi
            $sql = "INSERT INTO products (name, description, original_zip_path, critical_files, injection_placeholder)
                    VALUES (?, ?, ?, ?, ?)"; // 5 parametre
            $stmt = $conn->prepare($sql);

            if ($stmt === false) {
                error_log("Add Product - SQL prepare hatası: " . $conn->error);
                $error_message = "Ürün eklenirken bir veritabanı hatası oluştu (prepare).";
                if (isset($target_path) && file_exists($target_path)) @unlink($target_path);
            } else {
                // bind_param güncellendi (s, s, s, s, s)
                $stmt->bind_param("sssss", $product_name, $product_description, $original_zip_path, $critical_files, $injection_placeholder);
                if ($stmt->execute()) {
                    $_SESSION['success_message'] = "Ürün başarıyla eklendi.";
                    header("Location: products.php");
                    exit;
                } else {
                    error_log("Add Product - SQL execute hatası: " . $stmt->error);
                    $error_message = "Ürün eklenirken bir veritabanı hatası oluştu (execute).";
                    if (isset($target_path) && file_exists($target_path)) @unlink($target_path);
                }
                $stmt->close();
            }
        } elseif (isset($target_path) && file_exists($target_path) && $original_zip_path === null) {
             @unlink($target_path);
        }
    } // CSRF else sonu
} // POST isteği sonu

?>

<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2"><i class="bi bi-plus-square-fill"></i> <?php echo htmlspecialchars($page_title); ?></h1>
</div>

<?php if ($error_message): ?>
    <div class="alert alert-danger" role="alert">
        <?php echo htmlspecialchars($error_message); ?>
    </div>
<?php endif; ?>

<div class="card shadow-sm">
    <div class="card-header">
        Yeni Ürün Bilgileri
    </div>
    <div class="card-body">
        <form action="add_product.php" method="post" enctype="multipart/form-data">
            <!-- CSRF Token -->
            <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars($csrf_token); ?>">

            <div class="row g-3">
                <div class="col-md-6">
                    <label for="product_name" class="form-label">Ürün Adı <span class="text-danger">*</span></label>
                    <input type="text" class="form-control" id="product_name" name="product_name" value="<?php echo htmlspecialchars($product_name); ?>" required>
                </div>
                 <div class="col-md-6">
                    <label for="original_zip" class="form-label">Orijinal Yazılım ZIP <span class="text-danger">*</span></label>
                    <input class="form-control" type="file" id="original_zip" name="original_zip" accept=".zip" required>
                     <div class="form-text">Lisanslanacak yazılımın sıkıştırılmış hali.</div>
                </div>
                <div class="col-12">
                    <label for="product_description" class="form-label">Açıklama (İsteğe Bağlı)</label>
                    <textarea class="form-control" id="product_description" name="product_description" rows="3"><?php echo htmlspecialchars($product_description); ?></textarea>
                </div>
                 <div class="col-md-6">
                    <label for="critical_files" class="form-label">Kritik Dosyalar (İsteğe Bağlı)</label>
                    <input type="text" class="form-control" id="critical_files" name="critical_files" value="<?php echo htmlspecialchars($critical_files); ?>" placeholder="index.php, includes/config.php">
                     <div class="form-text">Belirli dosyaları hedeflemek isterseniz girin (virgülle ayırın). Boş bırakılırsa tüm .php dosyaları taranır.</div>
                </div>
                 <div class="col-md-6">
                    <label for="injection_placeholder" class="form-label">Enjeksiyon Yer Tutucusu <span class="text-danger">*</span></label>
                    <input type="text" class="form-control" id="injection_placeholder" name="injection_placeholder" value="<?php echo htmlspecialchars($injection_placeholder); ?>" required>
                     <div class="form-text">Kritik dosyalarda kodun ekleneceği yorum satırı (örn: // LISANS_KODU_BURADA).</div>
                </div>
            </div>

            <hr class="my-4">

            <button type="submit" class="btn btn-success"><i class="bi bi-check-circle-fill"></i> Ürünü Ekle</button>
            <a href="products.php" class="btn btn-secondary"><i class="bi bi-x-circle-fill"></i> İptal</a>
        </form>
    </div>
</div>

<?php
// Footer'ı dahil et
require_once __DIR__ . '/includes/footer.php';
?>
