<?php
// Veritabanı bağlantısını ve yapılandırmayı dahil et
require_once __DIR__ . '/../config/db_connect.php';

// Sayfa başlığını ayarla
$page_title = "Müşteri Yönetimi";

// Header'ı dahil et (Oturum kontrolünü yapar)
require_once __DIR__ . '/includes/header.php';

// Müşterileri veritabanından çek
$sql = "SELECT id, name, email, company, phone, is_active, created_at
        FROM customers
        ORDER BY created_at DESC";
$result = $conn->query($sql);

// Hata/Başarı mesajlarını oturumdan al (varsa)
$success_message = $_SESSION['success_message'] ?? null;
$error_message = $_SESSION['error_message'] ?? null;
unset($_SESSION['success_message'], $_SESSION['error_message']); // Gösterdikten sonra temizle

?>

<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2"><i class="bi bi-people-fill"></i> <?php echo htmlspecialchars($page_title); ?></h1>
    <div class="btn-toolbar mb-2 mb-md-0">
        <a href="add_customer.php" class="btn btn-success"><i class="bi bi-plus-circle-fill"></i> Yeni Müşteri Ekle</a>
    </div>
</div>

<?php if ($success_message): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <?php echo htmlspecialchars($success_message); ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
<?php endif; ?>
<?php if ($error_message): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <?php echo htmlspecialchars($error_message); ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
<?php endif; ?>

<div class="card shadow-sm">
    <div class="card-header">
        Müşteri Listesi
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <?php if ($result && $result->num_rows > 0): ?>
                <table class="table table-striped table-hover table-bordered table-sm">
                    <thead class="table-light">
                        <tr>
                            <th>ID</th>
                            <th>Ad Soyad</th>
                            <th>E-posta</th>
                            <th>Şirket</th>
                            <th>Telefon</th>
                            <th>Durum</th>
                            <th>Kayıt Tarihi</th>
                            <th style="width: 100px;">İşlemler</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php while($row = $result->fetch_assoc()): ?>
                            <tr>
                                <td><?php echo $row['id']; ?></td>
                                <td><?php echo htmlspecialchars($row['name']); ?></td>
                                <td><?php echo htmlspecialchars($row['email'] ?? '-'); ?></td>
                                <td><?php echo htmlspecialchars($row['company'] ?? '-'); ?></td>
                                <td><?php echo htmlspecialchars($row['phone'] ?? '-'); ?></td>
                                <td>
                                    <?php if ($row['is_active']): ?>
                                        <span class="badge bg-success">Aktif</span>
                                    <?php else: ?>
                                        <span class="badge bg-secondary">Pasif</span>
                                    <?php endif; ?>
                                </td>
                                <td style="white-space: nowrap;"><?php echo date('d/m/Y H:i', strtotime($row['created_at'])); ?></td>
                                <td class="text-center">
                                    <a href="edit_customer.php?id=<?php echo $row['id']; ?>" class="btn btn-sm btn-outline-primary" title="Düzenle"><i class="bi bi-pencil-fill"></i></a>
                                    <a href="delete_customer.php?id=<?php echo $row['id']; ?>&token=<?php echo urlencode($csrf_token); ?>" class="btn btn-sm btn-outline-danger delete" title="Sil" data-confirm="Bu müşteriyi silmek istediğinizden emin misiniz? Müşteriye ait lisansların müşteri bağlantısı kaldırılacaktır (lisanslar silinmez).">
                                        <i class="bi bi-trash-fill"></i>
                                    </a>
                                </td>
                            </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            <?php else: ?>
                <p class="text-center text-muted">Henüz müşteri eklenmemiş.</p>
            <?php endif; ?>
        </div>
        <!-- Sayfalama buraya eklenebilir -->
    </div>
</div>

<?php
// Veritabanı bağlantısını kapat
$conn->close();

// Footer'ı dahil et
require_once __DIR__ . '/includes/footer.php';
?>
