<?php
// Veritabanı bağlantısını ve yapılandırmayı dahil et
require_once __DIR__ . '/../config/db_connect.php';

// Oturum kontrolü
if (!isset($_SESSION['admin_user_id'])) {
    header("Location: login.php");
    exit;
}

// --- CSRF Token Doğrulama (GET isteği için) ---
if (!isset($_GET['token']) || !hash_equals($_SESSION['csrf_token'], $_GET['token'])) {
     $_SESSION['error_message'] = "Geçersiz güvenlik token'ı nedeniyle silme işlemi yapılamadı.";
     header("Location: customers.php");
     exit;
}

// --- Müşteri ID'sini Al ve Kontrol Et ---
if (!isset($_GET['id']) || !filter_var($_GET['id'], FILTER_VALIDATE_INT)) {
    $_SESSION['error_message'] = "Geçersiz müşteri ID'si.";
    header("Location: customers.php");
    exit;
}
$customer_id = (int)$_GET['id'];

// --- Silme İşlemi ---
// Önce ilişkili lisansların customer_id'sini NULL yapalım (gerçi FOREIGN KEY bunu yapacak ama garanti olsun)
// Bu adım aslında FOREIGN KEY constraint'i (ON DELETE SET NULL) nedeniyle gereksiz,
// ancak constraint olmazsa veya farklı ayarlanmışsa diye bir örnek olarak düşünülebilir.
/*
$update_licenses_sql = "UPDATE licenses SET customer_id = NULL WHERE customer_id = ?";
$stmt_update = $conn->prepare($update_licenses_sql);
if ($stmt_update) {
    $stmt_update->bind_param("i", $customer_id);
    $stmt_update->execute();
    $stmt_update->close();
} else {
     error_log("Delete Customer - License update prepare error: " . $conn->error);
     // Hata olsa bile devam etmeyi deneyebiliriz
}
*/

// Müşteriyi sil
$sql = "DELETE FROM customers WHERE id = ?";
$stmt = $conn->prepare($sql);

if ($stmt === false) {
    error_log("Delete Customer - SQL prepare hatası: " . $conn->error);
    $_SESSION['error_message'] = "Müşteri silinirken bir SQL hatası oluştu.";
} else {
    $stmt->bind_param("i", $customer_id);
    if ($stmt->execute()) {
        if ($stmt->affected_rows > 0) {
            $_SESSION['success_message'] = "Müşteri (ID: {$customer_id}) başarıyla silindi. İlişkili lisansların müşteri bağlantısı kaldırıldı.";
        } else {
            $_SESSION['error_message'] = "Silinecek müşteri (ID: {$customer_id}) bulunamadı veya zaten silinmiş.";
        }
    } else {
        error_log("Delete Customer - SQL execute hatası: " . $stmt->error);
        $_SESSION['error_message'] = "Müşteri silinirken bir veritabanı hatası oluştu.";
    }
    $stmt->close();
}

$conn->close();

// Kullanıcıyı müşteri listeleme sayfasına geri yönlendir
header("Location: customers.php");
exit;

?>
