<?php
// Veritabanı bağlantısını ve yapılandırmayı dahil et
require_once __DIR__ . '/../config/db_connect.php';

// Sayfa başlığını ayarla
$page_title = "Müşteriyi Düzenle";

// Header'ı dahil et (Oturum kontrolünü ve CSRF token'ı yapar)
require_once __DIR__ . '/includes/header.php'; // $csrf_token burada tanımlanır

$error_message = '';
$customer_id = null;

// Form/Veritabanı değerleri için değişkenler
$name = '';
$email = '';
$company = '';
$phone = '';
$is_active = 1; // Varsayılan aktif

// --- Müşteri ID'sini Al ve Kontrol Et ---
if (!isset($_GET['id']) || !filter_var($_GET['id'], FILTER_VALIDATE_INT)) {
    $_SESSION['error_message'] = "Geçersiz müşteri ID'si.";
    header("Location: customers.php");
    exit;
}
$customer_id = (int)$_GET['id'];

// --- POST İsteği İşleme (Form Gönderildiğinde) ---
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    // CSRF Token Doğrulama
    if (!isset($_POST['csrf_token']) || !hash_equals($_SESSION['csrf_token'], $_POST['csrf_token'])) {
         $_SESSION['error_message'] = "Geçersiz güvenlik token'ı nedeniyle işlem yapılamadı.";
         header("Location: customers.php");
         exit;
    }

    // Formdan gelen ID'yi de alalım
    $posted_id = (int)($_POST['customer_id'] ?? 0);
    if ($posted_id !== $customer_id) {
        $_SESSION['error_message'] = "ID uyuşmazlığı nedeniyle işlem yapılamadı.";
        header("Location: customers.php");
        exit;
    }

    // Token geçerli, işlemlere devam et
    $name = trim($_POST['name'] ?? '');
    $email = trim($_POST['email'] ?? '');
    $company = trim($_POST['company'] ?? '');
    $phone = trim($_POST['phone'] ?? '');
    $is_active = isset($_POST['is_active']) ? 1 : 0;
    // Müşteri paneli şifresi (opsiyonel)
    // $password = $_POST['password'] ?? '';
    // $update_password = false;
    // $password_hash = null;

    // Doğrulama
    if (empty($name)) {
        $error_message = "Müşteri adı boş bırakılamaz.";
    } elseif (!empty($email) && !filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $error_message = "Geçersiz e-posta adresi formatı.";
    }
    // Opsiyonel: Şifre değiştiriliyorsa doğrulama
    // elseif (!empty($password)) {
    //     if (strlen($password) < 6) {
    //         $error_message = "Yeni şifre en az 6 karakter olmalıdır.";
    //     } else {
    //         $update_password = true;
    //         $password_hash = password_hash($password, PASSWORD_DEFAULT);
    //     }
    // }
    else {
        // Veritabanını güncelleme işlemi
        // Şimdilik şifre güncelleme olmadan yapalım
        $sql = "UPDATE customers SET name = ?, email = ?, company = ?, phone = ?, is_active = ? WHERE id = ?";
        $stmt = $conn->prepare($sql);

        if ($stmt === false) {
            error_log("Edit Customer - SQL prepare hatası: " . $conn->error);
            $error_message = "Müşteri güncellenirken bir veritabanı hatası oluştu (prepare).";
        } else {
            $stmt->bind_param("ssssii", $name, $email, $company, $phone, $is_active, $customer_id);
            if ($stmt->execute()) {
                $_SESSION['success_message'] = "Müşteri başarıyla güncellendi.";
                header("Location: customers.php");
                exit;
            } else {
                error_log("Edit Customer - SQL execute hatası: " . $stmt->error);
                 if ($conn->errno == 1062) { // Duplicate entry for email
                     $error_message = "Bu e-posta adresi zaten başka bir müşteriye ait.";
                 } else {
                     $error_message = "Müşteri güncellenirken bir veritabanı hatası oluştu (execute).";
                 }
            }
            $stmt->close();
        }
    } // Validation else sonu
} else {
    // --- GET İsteği İşleme (Sayfa İlk Yüklendiğinde) ---
    $sql_get = "SELECT name, email, company, phone, is_active FROM customers WHERE id = ?";
    $stmt_get = $conn->prepare($sql_get);

    if ($stmt_get === false) {
        error_log("Edit Customer (GET) - SQL prepare hatası: " . $conn->error);
        $_SESSION['error_message'] = "Müşteri bilgileri alınırken bir hata oluştu.";
        header("Location: customers.php");
        exit;
    }

    $stmt_get->bind_param("i", $customer_id);
    $stmt_get->execute();
    $result_get = $stmt_get->get_result();

    if ($result_get->num_rows === 1) {
        $customer = $result_get->fetch_assoc();
        $name = $customer['name'];
        $email = $customer['email'] ?? '';
        $company = $customer['company'] ?? '';
        $phone = $customer['phone'] ?? '';
        $is_active = $customer['is_active'];
    } else {
        $_SESSION['error_message'] = "Düzenlenecek müşteri bulunamadı.";
        header("Location: customers.php");
        exit;
    }
    $stmt_get->close();
}

?>

<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2"><i class="bi bi-person-gear"></i> <?php echo htmlspecialchars($page_title); ?> (ID: <?php echo $customer_id; ?>)</h1>
</div>

<?php if ($error_message): ?>
    <div class="alert alert-danger" role="alert">
        <?php echo htmlspecialchars($error_message); ?>
    </div>
<?php endif; ?>

<div class="card shadow-sm">
    <div class="card-header">
        Müşteri Bilgilerini Düzenle
    </div>
    <div class="card-body">
        <form action="edit_customer.php?id=<?php echo $customer_id; ?>" method="post">
            <!-- CSRF Token -->
            <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars($csrf_token); ?>">
            <input type="hidden" name="customer_id" value="<?php echo $customer_id; ?>">

            <div class="row g-3">
                <div class="col-md-6">
                    <label for="name" class="form-label">Ad Soyad <span class="text-danger">*</span></label>
                    <input type="text" class="form-control" id="name" name="name" value="<?php echo htmlspecialchars($name); ?>" required>
                </div>
                <div class="col-md-6">
                    <label for="email" class="form-label">E-posta</label>
                    <input type="email" class="form-control" id="email" name="email" value="<?php echo htmlspecialchars($email); ?>">
                    <div class="form-text">Müşteri paneli girişi için kullanılabilir. Benzersiz olmalıdır.</div>
                </div>
                <div class="col-md-6">
                    <label for="company" class="form-label">Şirket</label>
                    <input type="text" class="form-control" id="company" name="company" value="<?php echo htmlspecialchars($company); ?>">
                </div>
                <div class="col-md-6">
                    <label for="phone" class="form-label">Telefon</label>
                    <input type="tel" class="form-control" id="phone" name="phone" value="<?php echo htmlspecialchars($phone); ?>">
                </div>
                <!-- Müşteri Paneli Şifresi Güncelleme (Opsiyonel) -->
                <!--
                <div class="col-md-6">
                    <label for="password" class="form-label">Yeni Şifre (Değiştirmek İsterseniz)</label>
                    <input type="password" class="form-control" id="password" name="password">
                    <div class="form-text">Boş bırakırsanız mevcut şifre değişmez.</div>
                </div>
                -->
                 <div class="col-12">
                    <div class="form-check form-switch">
                      <input class="form-check-input" type="checkbox" role="switch" id="is_active" name="is_active" value="1" <?php echo ($is_active == 1) ? 'checked' : ''; ?>>
                      <label class="form-check-label" for="is_active">Müşteri Aktif</label>
                    </div>
                </div>
            </div>

            <hr class="my-4">

            <button type="submit" class="btn btn-primary"><i class="bi bi-save-fill"></i> Değişiklikleri Kaydet</button>
            <a href="customers.php" class="btn btn-secondary"><i class="bi bi-x-circle-fill"></i> İptal</a>
        </form>
    </div>
</div>

<?php
// Footer'ı dahil et
require_once __DIR__ . '/includes/footer.php';
?>
