<?php
// Veritabanı bağlantısını ve yapılandırmayı dahil et
require_once __DIR__ . '/../config/db_connect.php';

// Sayfa başlığını ayarla
$page_title = "Ürünü Düzenle";

// Header'ı dahil et (Oturum kontrolünü ve CSRF token'ı yapar)
require_once __DIR__ . '/includes/header.php'; // $csrf_token burada tanımlanır

$error_message = '';
$product_id = null;

// Form/Veritabanı değerleri için değişkenler
$product_name = '';
$product_description = '';
$current_zip_path = '';
$critical_files = ''; // Tekrar eklendi
$injection_placeholder = '';

// Ürün ZIP dosyaları için yükleme klasörü
$product_zips_dir = __DIR__ . '/../uploads/products/';
if (!is_dir($product_zips_dir)) {
    mkdir($product_zips_dir, 0775, true);
}

// --- Ürün ID'sini Al ve Kontrol Et ---
if (!isset($_GET['id']) || !filter_var($_GET['id'], FILTER_VALIDATE_INT)) {
    $_SESSION['error_message'] = "Geçersiz ürün ID'si.";
    header("Location: products.php");
    exit;
}
$product_id = (int)$_GET['id'];

// --- POST İsteği İşleme (Form Gönderildiğinde) ---
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // CSRF Token Doğrulama
    if (!isset($_POST['csrf_token']) || !hash_equals($_SESSION['csrf_token'], $_POST['csrf_token'])) {
         $_SESSION['error_message'] = "Geçersiz güvenlik token'ı nedeniyle işlem yapılamadı.";
         header("Location: products.php");
         exit;
    }

    $posted_id = (int)($_POST['product_id'] ?? 0);
    if ($posted_id !== $product_id) {
        $_SESSION['error_message'] = "ID uyuşmazlığı nedeniyle işlem yapılamadı.";
        header("Location: products.php");
        exit;
    }

    // Form verilerini al
    $product_name = trim($_POST['product_name'] ?? '');
    $product_description = trim($_POST['product_description'] ?? '');
    $critical_files = trim($_POST['critical_files'] ?? ''); // Tekrar eklendi
    $injection_placeholder = trim($_POST['injection_placeholder'] ?? '');
    $new_zip_file = $_FILES['new_original_zip'] ?? null;
    $current_zip_path = trim($_POST['current_zip_path'] ?? '');
    $delete_old_zip = false;
    $new_zip_path_db = $current_zip_path;
    $target_path = null; // Hata durumunda silmek için

    // Doğrulama
    if (empty($product_name)) {
        $error_message = "Ürün adı boş bırakılamaz.";
    // } elseif (empty($critical_files)) { // Artık zorunlu değil, kaldırıldı
    //      $error_message = "En az bir kritik dosya adı belirtmelisiniz.";
    } elseif (empty($injection_placeholder)) {
        $error_message = "Enjeksiyon yer tutucusu boş bırakılamaz.";
    }

    // Yeni bir ZIP dosyası yüklendi mi?
    if (empty($error_message) && $new_zip_file && $new_zip_file['error'] === UPLOAD_ERR_OK) {
        $file_info = pathinfo($new_zip_file['name']);
        $file_extension = strtolower($file_info['extension'] ?? '');
        if ($file_extension !== 'zip') {
            $error_message = "Lütfen geçerli bir ZIP dosyası yükleyin.";
        } else {
            $safe_filename = uniqid('prod_', true) . '.zip';
            $target_path = $product_zips_dir . $safe_filename;
            if (move_uploaded_file($new_zip_file['tmp_name'], $target_path)) {
                $new_zip_path_db = 'uploads/products/' . $safe_filename;
                $delete_old_zip = true;
            } else {
                $error_message = "Yeni ZIP dosyası sunucuya taşınamadı. Klasör izinlerini kontrol edin.";
            }
        }
    } elseif ($new_zip_file && $new_zip_file['error'] !== UPLOAD_ERR_NO_FILE) {
        $error_message = "Yeni ZIP dosyası yüklenirken bir hata oluştu (Kod: {$new_zip_file['error']}).";
    }

    // Hata yoksa veritabanını güncelle
    if (empty($error_message)) {
        // SQL ve bind_param critical_files'ı içerecek şekilde güncellendi
        $sql = "UPDATE products SET
                    name = ?, description = ?, original_zip_path = ?,
                    critical_files = ?, injection_placeholder = ?
                WHERE id = ?";
        $stmt = $conn->prepare($sql);

        if ($stmt === false) {
            error_log("Edit Product - SQL prepare hatası: " . $conn->error);
            $error_message = "Ürün güncellenirken bir veritabanı hatası oluştu (prepare).";
            if ($delete_old_zip && isset($target_path) && file_exists($target_path)) @unlink($target_path);
        } else {
            $stmt->bind_param("sssssi",
                $product_name, $product_description, $new_zip_path_db,
                $critical_files, $injection_placeholder, $product_id
            );
            if ($stmt->execute()) {
                if ($delete_old_zip && !empty($current_zip_path)) {
                    $old_file_full_path = __DIR__ . '/../' . $current_zip_path;
                    if (file_exists($old_file_full_path)) { @unlink($old_file_full_path); }
                }
                $_SESSION['success_message'] = "Ürün başarıyla güncellendi.";
                header("Location: products.php");
                exit;
            } else {
                error_log("Edit Product - SQL execute hatası: " . $stmt->error);
                $error_message = "Ürün güncellenirken bir veritabanı hatası oluştu (execute).";
                 if ($delete_old_zip && isset($target_path) && file_exists($target_path)) @unlink($target_path);
            }
            $stmt->close();
        }
    }
} else {
    // --- GET İsteği İşleme (Sayfa İlk Yüklendiğinde) ---
    // critical_files'ı da çek
    $sql_get = "SELECT name, description, original_zip_path, critical_files, injection_placeholder
                FROM products WHERE id = ?";
    $stmt_get = $conn->prepare($sql_get);

    if ($stmt_get === false) {
        error_log("Edit Product (GET) - SQL prepare hatası: " . $conn->error);
        $_SESSION['error_message'] = "Ürün bilgileri alınırken bir hata oluştu.";
        header("Location: products.php");
        exit;
    }

    $stmt_get->bind_param("i", $product_id);
    $stmt_get->execute();
    $result_get = $stmt_get->get_result();

    if ($result_get->num_rows === 1) {
        $product = $result_get->fetch_assoc();
        $product_name = $product['name'];
        $product_description = $product['description'] ?? '';
        $current_zip_path = $product['original_zip_path'] ?? '';
        $critical_files = $product['critical_files'] ?? ''; // Tekrar eklendi
        $injection_placeholder = $product['injection_placeholder'] ?? '// LISANS_KODU_BURADA';
    } else {
        $_SESSION['error_message'] = "Düzenlenecek ürün bulunamadı.";
        header("Location: products.php");
        exit;
    }
    $stmt_get->close();
}

?>

<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2"><i class="bi bi-pencil-square"></i> <?php echo htmlspecialchars($page_title); ?> (ID: <?php echo $product_id; ?>)</h1>
</div>

<?php if ($error_message): ?>
    <div class="alert alert-danger" role="alert">
        <?php echo htmlspecialchars($error_message); ?>
    </div>
<?php endif; ?>

<div class="card shadow-sm">
    <div class="card-header">
        Ürün Bilgilerini Düzenle
    </div>
    <div class="card-body">
        <form action="edit_product.php?id=<?php echo $product_id; ?>" method="post" enctype="multipart/form-data">
            <input type="hidden" name="product_id" value="<?php echo $product_id; ?>">
            <input type="hidden" name="current_zip_path" value="<?php echo htmlspecialchars($current_zip_path); ?>">
            <!-- CSRF Token -->
            <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars($csrf_token); ?>">

            <div class="row g-3">
                <div class="col-md-6">
                    <label for="product_name" class="form-label">Ürün Adı <span class="text-danger">*</span></label>
                    <input type="text" class="form-control" id="product_name" name="product_name" value="<?php echo htmlspecialchars($product_name); ?>" required>
                </div>
                 <div class="col-md-6">
                    <label for="new_original_zip" class="form-label">Yeni Yazılım ZIP (Değiştirmek İsterseniz)</label>
                    <input class="form-control" type="file" id="new_original_zip" name="new_original_zip" accept=".zip">
                    <?php if (!empty($current_zip_path)): ?>
                        <div class="form-text">Mevcut dosya:
                            <a href="../<?php echo htmlspecialchars($current_zip_path); ?>" target="_blank">
                                <?php echo basename($current_zip_path); ?>
                            </a>
                            (Yeni dosya yüklenirse bu değiştirilir)
                        </div>
                    <?php else: ?>
                         <div class="form-text text-warning">Uyarı: Bu ürün için orijinal ZIP dosyası yüklenmemiş!</div>
                    <?php endif; ?>
                </div>
                <div class="col-12">
                    <label for="product_description" class="form-label">Açıklama (İsteğe Bağlı)</label>
                    <textarea class="form-control" id="product_description" name="product_description" rows="3"><?php echo htmlspecialchars($product_description); ?></textarea>
                </div>
                 <div class="col-md-6">
                    <label for="critical_files" class="form-label">Kritik Dosyalar (İsteğe Bağlı)</label>
                    <input type="text" class="form-control" id="critical_files" name="critical_files" value="<?php echo htmlspecialchars($critical_files); ?>" placeholder="index.php, includes/config.php">
                     <div class="form-text">Belirli dosyaları hedeflemek isterseniz girin (virgülle ayırın). Boş bırakılırsa tüm .php dosyaları taranır.</div>
                </div>
                 <div class="col-md-6">
                    <label for="injection_placeholder" class="form-label">Enjeksiyon Yer Tutucusu <span class="text-danger">*</span></label>
                    <input type="text" class="form-control" id="injection_placeholder" name="injection_placeholder" value="<?php echo htmlspecialchars($injection_placeholder); ?>" required>
                     <div class="form-text">Kritik dosyalarda kodun ekleneceği yorum satırı.</div>
                </div>
            </div>

            <hr class="my-4">

            <button type="submit" class="btn btn-primary"><i class="bi bi-save-fill"></i> Değişiklikleri Kaydet</button>
            <a href="products.php" class="btn btn-secondary"><i class="bi bi-x-circle-fill"></i> İptal</a>
        </form>
    </div>
</div>

<?php
// Footer'ı dahil et
require_once __DIR__ . '/includes/footer.php';
?>
