<?php
// Bu dosyanın doğrudan erişilmesini engellemek için bir kontrol eklenebilir (opsiyonel)
// defined('ADMIN_ACCESS') or die('Doğrudan erişim engellendi.');

// Oturum kontrolü (her sayfada tekrar yapmak yerine burada merkezi kontrol)
if (!isset($_SESSION['admin_user_id'])) {
    // Farklı bir sayfadan include edildiyse, login_error ayarlayıp yönlendirme yapalım
    if (basename($_SERVER['PHP_SELF']) !== 'login.php') { // login.php'de değilsek
         $_SESSION['login_error'] = "Lütfen önce giriş yapın.";
         header("Location: login.php"); // Göreceli yol, header.php'nin bulunduğu yerden değil, çağıran script'ten çalışır
         exit;
    }
}

// Giriş yapmış kullanıcı adını al
$admin_username = $_SESSION['admin_username'] ?? 'Yönetici';

// --- CSRF Token Oluşturma ---
// Eğer oturumda token yoksa veya boşsa yeni bir tane üret
if (empty($_SESSION['csrf_token'])) {
    try {
        $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
    } catch (Exception $e) {
        // random_bytes hata verirse (çok düşük ihtimal) basit bir fallback
        $_SESSION['csrf_token'] = bin2hex(openssl_random_pseudo_bytes(32));
    }
}
$csrf_token = $_SESSION['csrf_token']; // Formlarda kullanmak için değişkene ata

// Sayfa başlığını al (çağıran script tarafından tanımlanmalı)
global $page_title; // global $page_title değişkenini kullan
$current_page_title = $page_title ?? 'Admin Panel'; // Eğer tanımlanmamışsa varsayılan başlık

?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars(APP_NAME); ?> - <?php echo htmlspecialchars($current_page_title); ?></title>
    <!-- Bootstrap CSS (CDN) -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
    <!-- İkonlar için Bootstrap Icons (Opsiyonel) -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <style>
        /* Genel ek stiller */
        body { background-color: #f8f9fa; }
        .footer { background-color: #e9ecef; padding: 1.5rem 0; margin-top: 2rem; }
        .navbar { box-shadow: 0 2px 4px rgba(0,0,0,.1); }
        /* Tablolarda nowrap'ı kaldıralım, taşma olursa scroll ekleyelim */
        .table-responsive { overflow-x: auto; }
        /* Silme linki için */
        .btn-delete { color: #dc3545; }
        .btn-delete:hover { color: #a71d2a; }
    </style>
</head>
<body>

<nav class="navbar navbar-expand-lg navbar-dark bg-dark mb-4">
  <div class="container-fluid">
    <a class="navbar-brand" href="index.php"><?php echo htmlspecialchars(APP_NAME); ?></a>
    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
      <span class="navbar-toggler-icon"></span>
    </button>
    <div class="collapse navbar-collapse" id="navbarNav">
      <ul class="navbar-nav me-auto mb-2 mb-lg-0">
        <li class="nav-item">
          <a class="nav-link <?php echo (basename($_SERVER['PHP_SELF']) == 'index.php') ? 'active' : ''; ?>" aria-current="page" href="index.php"><i class="bi bi-house-door-fill"></i> Ana Panel</a>
        </li>
         <li class="nav-item">
          <a class="nav-link <?php echo (basename($_SERVER['PHP_SELF']) == 'products.php' || basename($_SERVER['PHP_SELF']) == 'add_product.php' || basename($_SERVER['PHP_SELF']) == 'edit_product.php') ? 'active' : ''; ?>" href="products.php"><i class="bi bi-box-seam-fill"></i> Ürünler</a>
        </li>
         <li class="nav-item">
          <a class="nav-link <?php echo (basename($_SERVER['PHP_SELF']) == 'customers.php' || basename($_SERVER['PHP_SELF']) == 'add_customer.php' || basename($_SERVER['PHP_SELF']) == 'edit_customer.php') ? 'active' : ''; ?>" href="customers.php"><i class="bi bi-people-fill"></i> Müşteriler</a>
        </li>
        <li class="nav-item">
          <a class="nav-link <?php echo (basename($_SERVER['PHP_SELF']) == 'licenses.php' || basename($_SERVER['PHP_SELF']) == 'add_license.php' || basename($_SERVER['PHP_SELF']) == 'edit_license.php') ? 'active' : ''; ?>" href="licenses.php"><i class="bi bi-key-fill"></i> Lisanslar</a>
        </li>
         <li class="nav-item">
          <a class="nav-link <?php echo (basename($_SERVER['PHP_SELF']) == 'license_check.php') ? 'active' : ''; ?>" href="license_check.php"><i class="bi bi-patch-check-fill"></i> Lisans Kontrol</a>
        </li>
         <li class="nav-item">
          <a class="nav-link <?php echo (basename($_SERVER['PHP_SELF']) == 'api_logs.php') ? 'active' : ''; ?>" href="api_logs.php"><i class="bi bi-terminal-fill"></i> API Logları</a>
        </li>
        <!-- Buraya başka menü öğeleri eklenebilir -->
      </ul>
      <span class="navbar-text me-3">
        Hoşgeldin, <strong><?php echo htmlspecialchars($admin_username); ?></strong>!
      </span>
      <a href="logout.php" class="btn btn-outline-danger btn-sm"><i class="bi bi-box-arrow-right"></i> Çıkış Yap</a>
    </div>
  </div>
</nav>

<main class="container mb-5">
    <!-- Sayfa içeriği buraya gelecek -->
