<?php
// Yapılandırmayı ve veritabanı bağlantısını dahil et (header.php zaten yapacak ama burada da olabilir)
require_once __DIR__ . '/../config/db_connect.php';

// Sayfa başlığını ayarla (header.php tarafından kullanılacak)
$page_title = "Ana Panel";

// Header'ı dahil et (Oturum kontrolünü ve HTML başlangıcını yapar)
require_once __DIR__ . '/includes/header.php';

// --- Sayfa İçeriği Başlangıcı ---
?>

<div class="container mt-4">
    <div class="row">
        <div class="col-12">
            <div class="card shadow-sm">
                <div class="card-header bg-primary text-white">
                    <h1 class="h4 mb-0"><i class="bi bi-speedometer2"></i> <?php echo htmlspecialchars($page_title); ?></h1>
                </div>
                <div class="card-body">
                    <p class="lead">Lisans Yönetim Sistemi admin paneline hoş geldiniz.</p>
                    <p>Sol menüden veya aşağıdaki hızlı bağlantılardan ürünlerinizi ve lisanslarınızı yönetebilirsiniz.</p>

                    <hr>

                    <h2 class="h5 mt-4 mb-3">Hızlı Bağlantılar</h2>
                    <div class="d-grid gap-2 d-md-flex justify-content-md-start">
                        <a href="products.php" class="btn btn-primary me-md-2 mb-2"><i class="bi bi-box-seam-fill"></i> Ürünleri Yönet</a>
                        <a href="licenses.php" class="btn btn-info me-md-2 mb-2"><i class="bi bi-key-fill"></i> Lisansları Yönet</a>
                        <a href="add_license.php" class="btn btn-success mb-2"><i class="bi bi-plus-circle-fill"></i> Yeni Lisans Ekle</a>
                        <!-- İleride eklenecek diğer linkler -->
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- İleride buraya istatistikler veya özet bilgiler eklenebilir -->
    <!--
    <div class="row mt-4">
        <div class="col-md-6">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">Toplam Ürün</h5>
                    <p class="card-text fs-3">...</p>
                </div>
            </div>
        </div>
        <div class="col-md-6">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">Toplam Aktif Lisans</h5>
                    <p class="card-text fs-3">...</p>
                </div>
            </div>
        </div>
    </div>
    -->

</div> <!-- .container sonu header.php'de açılmıştı, burada kapatmıyoruz -->

<?php
// --- Sayfa İçeriği Sonu ---

// Footer'ı dahil et (HTML sonunu ve JS dosyalarını ekler)
require_once __DIR__ . '/includes/footer.php';
?>
