<?php
// Veritabanı bağlantısını ve yapılandırmayı dahil et
require_once __DIR__ . '/../config/db_connect.php';

// Sayfa başlığını ayarla
$page_title = "Lisans Yönetimi";

// Header'ı dahil et (Oturum kontrolünü yapar)
require_once __DIR__ . '/includes/header.php';

// Lisansları veritabanından çek (products ve customers tabloları ile birleştirerek)
$sql = "SELECT
            l.id, l.license_key, l.domain, l.status, l.expires_at, l.created_at,
            p.name AS product_name,
            c.id AS customer_id, c.name AS customer_name, c.company AS customer_company -- customer_id eklendi
        FROM licenses l
        JOIN products p ON l.product_id = p.id
        LEFT JOIN customers c ON l.customer_id = c.id -- Müşteri ilişkisi için LEFT JOIN
        ORDER BY l.created_at DESC";

$result = $conn->query($sql);

// Hata/Başarı mesajlarını oturumdan al (varsa)
$success_message = $_SESSION['success_message'] ?? null;
$error_message = $_SESSION['error_message'] ?? null;
unset($_SESSION['success_message'], $_SESSION['error_message']); // Gösterdikten sonra temizle

?>

<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2"><i class="bi bi-key-fill"></i> <?php echo htmlspecialchars($page_title); ?></h1>
    <div class="btn-toolbar mb-2 mb-md-0">
        <a href="add_license.php" class="btn btn-success"><i class="bi bi-plus-circle-fill"></i> Yeni Lisans Ekle</a>
    </div>
</div>

<?php if ($success_message): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <?php echo htmlspecialchars($success_message); ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
<?php endif; ?>
<?php if ($error_message): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <?php echo htmlspecialchars($error_message); ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
<?php endif; ?>

<div class="card shadow-sm">
    <div class="card-header">
        Lisans Listesi
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <?php if ($result && $result->num_rows > 0): ?>
                <table class="table table-striped table-hover table-bordered table-sm"> <!-- table-sm daha kompakt -->
                    <thead class="table-light">
                        <tr>
                            <th scope="col">ID</th>
                            <th scope="col">Ürün</th>
                            <th scope="col">Lisans Anahtarı</th>
                            <th scope="col">Domain</th>
                            <th scope="col">Durum</th>
                            <th scope="col">Son Kullanma</th>
                            <th scope="col">Müşteri</th>
                            <th scope="col">Oluşturulma</th>
                            <th scope="col" style="width: 130px;">İşlemler</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php while($row = $result->fetch_assoc()): ?>
                            <tr>
                                <td><?php echo $row['id']; ?></td>
                                <td><?php echo htmlspecialchars($row['product_name']); ?></td>
                                <td class="font-monospace"><?php echo htmlspecialchars($row['license_key']); ?></td>
                                <td><?php echo htmlspecialchars($row['domain'] ?? '*'); ?></td>
                                <td>
                                    <?php
                                        $status_class = '';
                                        $status_text = ucfirst(htmlspecialchars($row['status']));
                                        switch ($row['status']) {
                                            case 'active': $status_class = 'badge bg-success'; break;
                                            case 'inactive': $status_class = 'badge bg-warning text-dark'; break;
                                            case 'expired': $status_class = 'badge bg-danger'; break;
                                            default: $status_class = 'badge bg-secondary'; break;
                                        }
                                    ?>
                                    <span class="<?php echo $status_class; ?>"><?php echo $status_text; ?></span>
                                </td>
                                <td><?php echo $row['expires_at'] ? date('d/m/Y H:i', strtotime($row['expires_at'])) : 'Süresiz'; ?></td>
                                <td>
                                    <?php if (!empty($row['customer_name'])): ?>
                                        <a href="edit_customer.php?id=<?php echo $row['customer_id']; /* Bu ID sorguya eklenmeli */ ?>" title="Müşteriyi Düzenle">
                                            <?php echo htmlspecialchars($row['customer_name']); ?>
                                            <?php echo !empty($row['customer_company']) ? ' (' . htmlspecialchars($row['customer_company']) . ')' : ''; ?>
                                        </a>
                                    <?php else: ?>
                                        -
                                    <?php endif; ?>
                                </td>
                                <td><?php echo date('d/m/Y H:i', strtotime($row['created_at'])); ?></td>
                                <td class="text-center">
                                    <a href="license_check.php?key=<?php echo urlencode($row['license_key']); ?>&domain=<?php echo urlencode($row['domain'] ?? ''); ?>" class="btn btn-sm btn-outline-info" title="Kontrol Et" target="_blank"><i class="bi bi-patch-check"></i></a>
                                    <a href="package_and_download.php?license_id=<?php echo $row['id']; ?>" class="btn btn-sm btn-outline-success" title="Paketle ve İndir" target="_blank"><i class="bi bi-box-arrow-down"></i></a>
                                    <a href="edit_license.php?id=<?php echo $row['id']; ?>" class="btn btn-sm btn-outline-primary" title="Düzenle"><i class="bi bi-pencil-fill"></i></a>
                                    <a href="delete_license.php?id=<?php echo $row['id']; ?>&token=<?php echo urlencode($csrf_token); ?>" class="btn btn-sm btn-outline-danger delete" title="Sil" data-confirm="Bu lisansı silmek istediğinizden emin misiniz?">
                                        <i class="bi bi-trash-fill"></i>
                                    </a>
                                </td>
                            </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            <?php else: ?>
                <p class="text-center text-muted">Henüz lisans eklenmemiş.</p>
            <?php endif; ?>
        </div>
    </div>
</div>

<?php
// Veritabanı bağlantısını kapat
$conn->close();

// Footer'ı dahil et
require_once __DIR__ . '/includes/footer.php';
?>
