<?php
// Veritabanı bağlantısını ve yapılandırmayı dahil et (config.php oturumu başlatır)
require_once __DIR__ . '/../config/db_connect.php';

// Eğer kullanıcı zaten giriş yapmışsa, admin ana sayfasına yönlendir
if (isset($_SESSION['admin_user_id'])) {
    header("Location: index.php");
    exit;
}

$error_message = '';
// Giriş denemesi sonucu hata mesajı varsa al
if (isset($_SESSION['login_error'])) {
    $error_message = $_SESSION['login_error'];
    unset($_SESSION['login_error']); // Mesajı gösterdikten sonra temizle
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars(APP_NAME); ?> - Yönetici Girişi</title>
    <!-- Bootstrap CSS (CDN) -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
    <style>
        html, body { height: 100%; }
        body {
            display: flex;
            align-items: center;
            padding-top: 40px;
            padding-bottom: 40px;
            background-color: #f5f5f5;
        }
        .form-signin {
            width: 100%;
            max-width: 350px; /* Genişliği biraz artırdık */
            padding: 25px; /* Padding artırıldı */
            margin: auto;
            background-color: #fff;
            border-radius: 8px;
            box-shadow: 0 4px 10px rgba(0,0,0,0.1);
        }
        .form-signin .form-floating:focus-within {
            z-index: 2;
        }
        .form-signin input[type="text"] {
            margin-bottom: -1px;
            border-bottom-right-radius: 0;
            border-bottom-left-radius: 0;
        }
        .form-signin input[type="password"] {
            margin-bottom: 10px;
            border-top-left-radius: 0;
            border-top-right-radius: 0;
        }
        .form-signin .btn {
             padding: 10px; /* Buton padding */
        }
        .app-logo {
            max-width: 80px; /* Logo boyutu */
            margin-bottom: 1rem;
        }
    </style>
</head>
<body class="text-center">

<main class="form-signin">
  <form action="auth.php" method="post">
    <!-- Buraya bir logo eklenebilir -->
    <!-- <img class="app-logo" src="../public/images/logo.png" alt="Logo"> -->
    <h1 class="h3 mb-3 fw-normal"><?php echo htmlspecialchars(APP_NAME); ?></h1>
    <h2 class="h5 mb-3 fw-light">Yönetici Girişi</h2>

    <?php if (!empty($error_message)): ?>
        <div class="alert alert-danger" role="alert">
            <?php echo htmlspecialchars($error_message); ?>
        </div>
    <?php endif; ?>

    <div class="form-floating mb-2">
      <input type="text" class="form-control" id="username" name="username" placeholder="Kullanıcı Adı" required autofocus>
      <label for="username">Kullanıcı Adı</label>
    </div>
    <div class="form-floating">
      <input type="password" class="form-control" id="password" name="password" placeholder="Şifre" required>
      <label for="password">Şifre</label>
    </div>

    <!-- İsteğe bağlı "Beni Hatırla" vb. eklenebilir -->
    <!--
    <div class="checkbox mb-3">
      <label>
        <input type="checkbox" value="remember-me"> Beni Hatırla
      </label>
    </div>
    -->
    <button class="w-100 btn btn-lg btn-primary mt-3" type="submit">Giriş Yap</button>
    <p class="mt-5 mb-3 text-muted">&copy; <?php echo date('Y'); ?></p>
  </form>
</main>

<!-- Bootstrap JS (Gerekirse, ama bu sayfa için şart değil) -->
<!-- <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz" crossorigin="anonymous"></script> -->

</body>
</html>
