<?php
// Yapılandırmayı dahil et (config.php oturumu başlatır)
require_once __DIR__ . '/../config/config.php'; // Sadece config yeterli, db bağlantısına gerek yok

// Oturum değişkenlerini temizle (sadece admin ile ilgili olanları veya tümünü)
// Sadece admin ile ilgili olanları temizlemek daha güvenli olabilir,
// eğer aynı domain altında başka oturumlar varsa etkilenmez.
unset($_SESSION['admin_user_id']);
unset($_SESSION['admin_username']);
// Varsa diğer admin oturum değişkenleri de buraya eklenebilir.

// Alternatif olarak tüm oturumu yok etmek için:
// $_SESSION = array(); // Tüm oturum değişkenlerini sil
// session_destroy(); // Oturumu tamamen yok et

// Oturum çerezini silmek (isteğe bağlı ama önerilir)
if (ini_get("session.use_cookies")) {
    $params = session_get_cookie_params();
    setcookie(session_name(), '', time() - 42000,
        $params["path"], $params["domain"],
        $params["secure"], $params["httponly"]
    );
}

// Oturumu tamamen yok etmeyi tercih ediyorsak:
// session_destroy();

// Kullanıcıyı login sayfasına yönlendir
header("Location: login.php");
exit;
?>
