<?php
// Veritabanı Bağlantı Bilgileri
define('DB_HOST', 'localhost');
define('DB_USER', 'root'); // XAMPP varsayılan
define('DB_PASS', '');     // XAMPP varsayılan (boş)
define('DB_NAME', 'licensing_db'); // SQL dosyasında oluşturulan veritabanı adı

// Uygulama Ayarları
define('APP_NAME', 'Lisans Yönetim Sistemi');
// Projenizin kök URL'sini doğru şekilde ayarlayın (sondaki / olmadan)
// Eğer htdocs içindeyse: 'http://localhost/license_system'
// Eğer bir alt klasördeyse: 'http://localhost/ana_klasor/license_system'
// define('BASE_URL', rtrim(dirname(dirname($_SERVER['SCRIPT_NAME'])), '/\\')); // Otomatik algılama devre dışı
// Subdomain'in ana dizinine yükleneceği varsayılarak boş bırakılır.
// Eğer subdomain içinde bir alt klasöre yüklenecekse, o klasör adını yazın (örn: '/api').
define('BASE_URL', '');

// Oturum Ayarları
define('SESSION_NAME', 'lic_sys_session');

// API'nin dışarıdan erişileceği tam URL (protokol dahil, sonunda / olmadan)
// Sistemi taşırsanız burayı güncelleyin!
define('API_PUBLIC_URL', 'https://lisans.firmasitesikur.com'); // << KENDİ ADRESİNİZLE GÜNCELLEYİN

// Diğer ayarlar buraya eklenebilir (örn: API anahtarları, e-posta ayarları vb.)

// Hata Raporlama (Geliştirme aşamasında E_ALL, production'da 0 veya E_ERROR)
error_reporting(E_ALL);
ini_set('display_errors', 1); // Production'da 0 yapın

// Zaman Dilimi
date_default_timezone_set('Europe/Istanbul'); // Kendi zaman diliminize göre ayarlayın

// Oturumu başlatma (güvenli ayarlarla)
if (session_status() == PHP_SESSION_NONE) {
    session_name(SESSION_NAME);
    // Cookie ayarlarını daha güvenli hale getirelim
    $cookieParams = session_get_cookie_params();
    session_set_cookie_params([
        'lifetime' => $cookieParams['lifetime'], // Oturum süresi (tarayıcı kapanana kadar veya belirli süre)
        'path' => $cookieParams['path'],         // Genellikle '/'
        'domain' => $cookieParams['domain'],     // Genellikle boş
        'secure' => isset($_SERVER['HTTPS']),    // Sadece HTTPS üzerinden gönder (production için true olmalı)
        'httponly' => true,                      // JavaScript erişimini engelle
        'samesite' => 'Lax'                      // CSRF koruması için ('Strict' veya 'Lax')
    ]);
    session_start();
}
?>
