<?php
/**
 * Dijital Menü - Geri Bildirim Yönetimi
 */

// İstanbul saatini ayarla
date_default_timezone_set('Europe/Istanbul');

// Gerekli dosyaları dahil et
require_once '../includes/auth.php';
require_once '../includes/language.php';
require_once '../includes/feedback_functions.php';

// Admin paneli dilini al
$adminLanguage = getAdminLanguage();

// Giriş yapılmamışsa yönlendir
redirectIfNotLoggedIn('login.php');

// Admin yetkisi kontrolü
requirePermission('admin', 'login.php');

// Sayfa başlığı
$pageTitle = 'Geri Bildirim Yönetimi';

// Ayarları al
$settings = getSetting();

// Durum filtresi
$status = isset($_GET['status']) ? intval($_GET['status']) : null;
$searchFilter = isset($_GET['search']) ? clean($_GET['search']) : null;
$startDateFilter = isset($_GET['start_date']) ? clean($_GET['start_date']) : null;
$endDateFilter = isset($_GET['end_date']) ? clean($_GET['end_date']) : null;

// Sayfalama
$page = isset($_GET['page']) ? intval($_GET['page']) : 1;
$limit = 20;
$offset = ($page - 1) * $limit;

// Geri bildirimleri al
$feedbacks = getFeedbacks($status, $limit, $offset, $searchFilter, $startDateFilter, $endDateFilter);
$totalCount = getFeedbackCount($status);
$totalPages = ceil($totalCount / $limit);

// Durum güncelleme işlemi
if (isset($_POST['update_status'])) {
    $feedbackId = intval($_POST['feedback_id']);
    $newStatus = intval($_POST['status']);
    
    if (updateFeedbackStatus($feedbackId, $newStatus)) {
        $_SESSION['success_message'] = 'Geri bildirim durumu başarıyla güncellendi.';
        
        // Sayfayı yenile
        header('Location: feedbacks.php' . (isset($_GET['status']) ? '?status=' . $_GET['status'] : ''));
        exit;
    } else {
        $_SESSION['error_message'] = 'Geri bildirim durumu güncellenirken bir hata oluştu.';
    }
}

// Toplu durum güncelleme işlemi
if (isset($_POST['bulk_action']) && $_POST['bulk_action'] === 'update_status' && !empty($_POST['selected_ids']) && isset($_POST['bulk_status'])) {
    $selectedIds = explode(',', $_POST['selected_ids']);
    $newStatus = intval($_POST['bulk_status']);
    $successCount = 0;
    $errorCount = 0;
    
    foreach ($selectedIds as $id) {
        $id = intval($id);
        if ($id > 0) {
            if (updateFeedbackStatus($id, $newStatus)) {
                $successCount++;
            } else {
                $errorCount++;
            }
        }
    }
    
    if ($successCount > 0) {
        $_SESSION['success_message'] = $successCount . ' geri bildirim durumu başarıyla güncellendi.';
    }
    
    if ($errorCount > 0) {
        $_SESSION['error_message'] = $errorCount . ' geri bildirim durumu güncellenirken hata oluştu.';
    }
    
    redirect('feedbacks.php' . (isset($_GET['status']) ? '?status=' . $_GET['status'] : ''));
}

// Silme işlemi
if (isset($_GET['delete'])) {
    $feedbackId = intval($_GET['delete']);
    
    if (deleteFeedback($feedbackId)) {
        $_SESSION['success_message'] = 'Geri bildirim başarıyla silindi.';
        
        // Sayfayı yenile
        header('Location: feedbacks.php' . (isset($_GET['status']) ? '?status=' . $_GET['status'] : ''));
        exit;
    } else {
        $_SESSION['error_message'] = 'Geri bildirim silinirken bir hata oluştu.';
    }
}

// Toplu silme işlemi
if (isset($_POST['bulk_action']) && $_POST['bulk_action'] === 'delete' && !empty($_POST['selected_ids'])) {
    $selectedIds = explode(',', $_POST['selected_ids']);
    $successCount = 0;
    $errorCount = 0;
    
    foreach ($selectedIds as $id) {
        $id = intval($id);
        if ($id > 0) {
            if (deleteFeedback($id)) {
                $successCount++;
            } else {
                $errorCount++;
            }
        }
    }
    
    if ($successCount > 0) {
        $_SESSION['success_message'] = $successCount . ' geri bildirim başarıyla silindi.';
    }
    
    if ($errorCount > 0) {
        $_SESSION['error_message'] = $errorCount . ' geri bildirim silinirken hata oluştu.';
    }
    
    redirect('feedbacks.php' . (isset($_GET['status']) ? '?status=' . $_GET['status'] : ''));
}

// Aktif kullanıcı bilgilerini al
$user = getUser($_SESSION['user_id']);
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $pageTitle; ?> | <?php echo $settings['site_title'] ?? 'Dijital Menü'; ?></title>
    
    <!-- Favicon -->
    <?php if (!empty($settings['favicon'])): ?>
    <link rel="shortcut icon" href="../assets/img/<?php echo $settings['favicon']; ?>" type="image/x-icon">
    <?php endif; ?>
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    
    <!-- Ana CSS -->
    <link href="../assets/css/style.css" rel="stylesheet">
    <link href="../assets/css/admin-mobile.css" rel="stylesheet">
    
    <!-- Özel Renkler -->
    <style>
        :root {
            --primary-color: <?php echo $settings['primary_color'] ?? '#3490dc'; ?>;
            --secondary-color: <?php echo $settings['secondary_color'] ?? '#38c172'; ?>;
            --text-color: <?php echo $settings['text_color'] ?? '#333333'; ?>;
            --background-color: <?php echo $settings['background_color'] ?? '#ffffff'; ?>;
        }
        
        .feedback-status-0 {
            background-color: #ffc107;
            color: #212529;
        }
        
        .feedback-status-1 {
            background-color: #17a2b8;
            color: #fff;
        }
        
        .feedback-status-2 {
            background-color: #28a745;
            color: #fff;
        }
        
        .feedback-status-3 {
            background-color: #6c757d;
            color: #fff;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <?php include 'includes/sidebar.php'; ?>
            
            <!-- Ana İçerik -->
            <div class="col-md-9 col-lg-10 admin-content">
                <!-- Üst Başlık -->
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h1 class="h3"><?php echo $pageTitle; ?></h1>
                </div>
                
                <!-- Oturum Mesajı -->
                <?php if (isset($_SESSION['error_message'])): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <?php echo $_SESSION['error_message']; ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
                <?php unset($_SESSION['error_message']); ?>
                <?php endif; ?>
                
                <?php if (isset($_SESSION['success_message'])): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <?php echo $_SESSION['success_message']; ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
                <?php unset($_SESSION['success_message']); ?>
                <?php endif; ?>
                
                <!-- İçerik -->
                <div class="admin-card">
                    <div class="mb-4">
                        <div class="d-flex justify-content-between align-items-center mb-3">
                            <div>
                                <h5>Geri Bildirimler</h5>
                                <p class="text-muted">Toplam: <?php echo $totalCount; ?> geri bildirim</p>
                            </div>
                            
                            <div class="btn-group">
                                <a href="feedbacks.php" class="btn <?php echo $status === null ? 'btn-primary' : 'btn-outline-primary'; ?>">Tümü</a>
                                <a href="feedbacks.php?status=0" class="btn <?php echo $status === 0 ? 'btn-primary' : 'btn-outline-primary'; ?>">Beklemede</a>
                                <a href="feedbacks.php?status=1" class="btn <?php echo $status === 1 ? 'btn-primary' : 'btn-outline-primary'; ?>">Okundu</a>
                                <a href="feedbacks.php?status=2" class="btn <?php echo $status === 2 ? 'btn-primary' : 'btn-outline-primary'; ?>">Yanıtlandı</a>
                                <a href="feedbacks.php?status=3" class="btn <?php echo $status === 3 ? 'btn-primary' : 'btn-outline-primary'; ?>">Arşivlendi</a>
                            </div>
                        </div>
                        
                        <!-- Arama ve Tarih Filtreleri -->
                        <div class="row mb-3">
                            <div class="col-md-12">
                                <form method="get" action="feedbacks.php" class="row g-3">
                                    <?php if (isset($_GET['status'])): ?>
                                    <input type="hidden" name="status" value="<?php echo intval($_GET['status']); ?>">
                                    <?php endif; ?>
                                    
                                    <div class="col-md-4">
                                        <div class="input-group">
                                            <input type="text" name="search" class="form-control" placeholder="İsim, e-posta veya mesaj ara..." value="<?php echo $searchFilter; ?>">
                                            <button type="submit" class="btn btn-primary">
                                                <i class="fas fa-search"></i>
                                            </button>
                                        </div>
                                    </div>
                                    
                                    <div class="col-md-6">
                                        <div class="input-group">
                                            <span class="input-group-text">Tarih Aralığı</span>
                                            <input type="date" class="form-control" id="startDateFilter" name="start_date" value="<?php echo $startDateFilter; ?>" placeholder="Başlangıç">
                                            <span class="input-group-text">-</span>
                                            <input type="date" class="form-control" id="endDateFilter" name="end_date" value="<?php echo $endDateFilter; ?>" placeholder="Bitiş">
                                        </div>
                                    </div>
                                    
                                    <div class="col-md-2">
                                        <?php if (isset($_GET['search']) || isset($_GET['start_date']) || isset($_GET['end_date'])): ?>
                                        <a href="feedbacks.php<?php echo isset($_GET['status']) ? '?status=' . $_GET['status'] : ''; ?>" class="btn btn-outline-secondary w-100">
                                            <i class="fas fa-times"></i> Filtreleri Temizle
                                        </a>
                                        <?php endif; ?>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Toplu İşlem Butonları -->
                    <div class="mb-3">
                        <form id="bulkActionForm" method="post" action="">
                            <div class="d-flex gap-2">
                                <select class="form-select" id="bulkStatusSelect" style="width: auto;">
                                    <option value="">Durum Seçin</option>
                                    <option value="0">Beklemede</option>
                                    <option value="1">Okundu</option>
                                    <option value="2">Yanıtlandı</option>
                                    <option value="3">Arşivlendi</option>
                                </select>
                                <button type="button" id="bulkUpdateBtn" class="btn btn-primary" disabled>
                                    <i class="fas fa-edit"></i> Durumu Güncelle
                                </button>
                                <button type="button" id="bulkDeleteBtn" class="btn btn-danger" disabled>
                                    <i class="fas fa-trash"></i> Seçilenleri Sil
                                </button>
                                <input type="hidden" name="bulk_action" id="bulkAction" value="">
                                <input type="hidden" name="bulk_status" id="bulkStatus" value="">
                                <input type="hidden" name="selected_ids" id="selectedIds" value="">
                            </div>
                        </form>
                    </div>
                    
                    <?php if (empty($feedbacks)): ?>
                    <div class="alert alert-info">
                        Henüz geri bildirim bulunmamaktadır.
                    </div>
                    <?php else: ?>
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="selectAll">
                                            <label class="form-check-label" for="selectAll"></label>
                                        </div>
                                    </th>
                                    <th>#</th>
                                    <th>Gönderen</th>
                                    <th>Mesaj</th>
                                    <th>Tarih</th>
                                    <th>Durum</th>
                                    <th>İşlemler</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($feedbacks as $feedback): ?>
                                <tr>
                                    <td>
                                        <div class="form-check">
                                            <input class="form-check-input feedback-checkbox" type="checkbox" value="<?php echo $feedback['id']; ?>" id="feedback-<?php echo $feedback['id']; ?>">
                                            <label class="form-check-label" for="feedback-<?php echo $feedback['id']; ?>"></label>
                                        </div>
                                    </td>
                                    <td><?php echo $feedback['id']; ?></td>
                                    <td><?php echo htmlspecialchars($feedback['name']); ?></td>
                                    <td>
                                        <?php 
                                        // Mesajı kısalt
                                        $message = htmlspecialchars($feedback['message']);
                                        echo strlen($message) > 100 ? substr($message, 0, 100) . '...' : $message;
                                        ?>
                                    </td>
                                    <td><?php echo date('d.m.Y H:i', strtotime($feedback['created_at'])); ?></td>
                                    <td>
                                        <span class="badge feedback-status-<?php echo $feedback['status']; ?>">
                                            <?php echo getFeedbackStatusText($feedback['status']); ?>
                                        </span>
                                    </td>
                                    <td>
                                        <div class="btn-group">
                                            <button type="button" class="btn btn-sm btn-primary" data-bs-toggle="modal" data-bs-target="#viewFeedbackModal<?php echo $feedback['id']; ?>">
                                                <i class="fas fa-eye"></i>
                                            </button>
                                            <button type="button" class="btn btn-sm btn-warning" data-bs-toggle="modal" data-bs-target="#updateStatusModal<?php echo $feedback['id']; ?>">
                                                <i class="fas fa-edit"></i>
                                            </button>
                                            <a href="feedbacks.php?delete=<?php echo $feedback['id']; ?>" class="btn btn-sm btn-danger" onclick="return confirm('Bu geri bildirimi silmek istediğinizden emin misiniz?')">
                                                <i class="fas fa-trash"></i>
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                    
                    <!-- Sayfalama -->
                    <?php if ($totalPages > 1): ?>
                    <nav aria-label="Sayfalama">
                        <ul class="pagination justify-content-center">
                            <li class="page-item <?php echo $page <= 1 ? 'disabled' : ''; ?>">
                                <a class="page-link" href="?page=<?php echo $page - 1; ?><?php echo isset($_GET['status']) ? '&status=' . $_GET['status'] : ''; ?>" aria-label="Önceki">
                                    <span aria-hidden="true">&laquo;</span>
                                </a>
                            </li>
                            
                            <?php for ($i = 1; $i <= $totalPages; $i++): ?>
                            <li class="page-item <?php echo $page == $i ? 'active' : ''; ?>">
                                <a class="page-link" href="?page=<?php echo $i; ?><?php echo isset($_GET['status']) ? '&status=' . $_GET['status'] : ''; ?>">
                                    <?php echo $i; ?>
                                </a>
                            </li>
                            <?php endfor; ?>
                            
                            <li class="page-item <?php echo $page >= $totalPages ? 'disabled' : ''; ?>">
                                <a class="page-link" href="?page=<?php echo $page + 1; ?><?php echo isset($_GET['status']) ? '&status=' . $_GET['status'] : ''; ?>" aria-label="Sonraki">
                                    <span aria-hidden="true">&raquo;</span>
                                </a>
                            </li>
                        </ul>
                    </nav>
                    <?php endif; ?>
                    
                    <!-- Geri Bildirim Görüntüleme Modalları -->
                    <?php foreach ($feedbacks as $feedback): ?>
                    <div class="modal fade" id="viewFeedbackModal<?php echo $feedback['id']; ?>" tabindex="-1" aria-labelledby="viewFeedbackModalLabel<?php echo $feedback['id']; ?>" aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="viewFeedbackModalLabel<?php echo $feedback['id']; ?>">Geri Bildirim Detayı</h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Kapat"></button>
                                </div>
                                <div class="modal-body">
                                    <div class="mb-3">
                                        <strong>Gönderen:</strong> <?php echo htmlspecialchars($feedback['name']); ?>
                                    </div>
                                    
                                    <div class="mb-3">
                                        <strong>Tarih:</strong> <?php echo date('d.m.Y H:i', strtotime($feedback['created_at'])); ?>
                                    </div>
                                    
                                    <div class="mb-3">
                                        <strong>IP Adresi:</strong> <?php echo htmlspecialchars($feedback['ip_address']); ?>
                                    </div>
                                    
                                    <div class="mb-3">
                                        <strong>Durum:</strong>
                                        <span class="badge feedback-status-<?php echo $feedback['status']; ?>">
                                            <?php echo getFeedbackStatusText($feedback['status']); ?>
                                        </span>
                                    </div>
                                    
                                    <div class="mb-3">
                                        <strong>Mesaj:</strong>
                                        <div class="card p-3 mt-2">
                                            <?php echo nl2br(htmlspecialchars($feedback['message'])); ?>
                                        </div>
                                    </div>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Kapat</button>
                                    <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#updateStatusModal<?php echo $feedback['id']; ?>" data-bs-dismiss="modal">
                                        Durumu Güncelle
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Durum Güncelleme Modalları -->
                    <div class="modal fade" id="updateStatusModal<?php echo $feedback['id']; ?>" tabindex="-1" aria-labelledby="updateStatusModalLabel<?php echo $feedback['id']; ?>" aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="updateStatusModalLabel<?php echo $feedback['id']; ?>">Durum Güncelle</h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Kapat"></button>
                                </div>
                                <form method="post" action="">
                                    <div class="modal-body">
                                        <input type="hidden" name="feedback_id" value="<?php echo $feedback['id']; ?>">
                                        
                                        <div class="mb-3">
                                            <label for="status<?php echo $feedback['id']; ?>" class="form-label">Durum</label>
                                            <select class="form-select" id="status<?php echo $feedback['id']; ?>" name="status">
                                                <option value="0" <?php echo $feedback['status'] == 0 ? 'selected' : ''; ?>>Beklemede</option>
                                                <option value="1" <?php echo $feedback['status'] == 1 ? 'selected' : ''; ?>>Okundu</option>
                                                <option value="2" <?php echo $feedback['status'] == 2 ? 'selected' : ''; ?>>Yanıtlandı</option>
                                                <option value="3" <?php echo $feedback['status'] == 3 ? 'selected' : ''; ?>>Arşivlendi</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                                        <button type="submit" name="update_status" class="btn btn-primary">Güncelle</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    
    <!-- Overlay Arka Planı -->
    <div class="overlay-background" id="overlayBackground"></div>
    
    <!-- Admin JS -->
    <script>
        // Mobil menü toggle
        document.addEventListener('DOMContentLoaded', function() {
            const mobileMenuToggle = document.querySelector('.mobile-menu-toggle');
            const adminSidebar = document.getElementById('adminSidebar');
            const overlayBackground = document.getElementById('overlayBackground');
            
            // Mobil menü toggle
            if (mobileMenuToggle && adminSidebar && overlayBackground) {
                // Menü açma
                mobileMenuToggle.addEventListener('click', function() {
                    adminSidebar.classList.toggle('show');
                    overlayBackground.classList.toggle('active');
                    document.body.style.overflow = adminSidebar.classList.contains('show') ? 'hidden' : '';
                });
                
                // Overlay'a tıklayınca menüyü kapat
                overlayBackground.addEventListener('click', function() {
                    adminSidebar.classList.remove('show');
                    overlayBackground.classList.remove('active');
                    document.body.style.overflow = '';
                });
            }
            
            // Bootstrap tooltips
            var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
            var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
                return new bootstrap.Tooltip(tooltipTriggerEl);
            });
            
            // Toplu İşlem Fonksiyonları
            const selectAllCheckbox = document.getElementById('selectAll');
            const feedbackCheckboxes = document.querySelectorAll('.feedback-checkbox');
            const bulkUpdateBtn = document.getElementById('bulkUpdateBtn');
            const bulkDeleteBtn = document.getElementById('bulkDeleteBtn');
            const bulkActionForm = document.getElementById('bulkActionForm');
            const bulkAction = document.getElementById('bulkAction');
            const bulkStatus = document.getElementById('bulkStatus');
            const selectedIds = document.getElementById('selectedIds');
            const bulkStatusSelect = document.getElementById('bulkStatusSelect');
            
            // Tümünü Seç checkbox'ı
            if (selectAllCheckbox) {
                selectAllCheckbox.addEventListener('change', function() {
                    const isChecked = this.checked;
                    
                    // Tüm checkbox'ları seç/kaldır
                    feedbackCheckboxes.forEach(checkbox => {
                        checkbox.checked = isChecked;
                    });
                    
                    // Buton durumunu güncelle
                    updateBulkButtonState();
                });
            }
            
            // Her bir checkbox için olay dinleyicisi
            feedbackCheckboxes.forEach(checkbox => {
                checkbox.addEventListener('change', function() {
                    // Tümünü Seç checkbox'ını güncelle
                    updateSelectAllCheckbox();
                    
                    // Buton durumunu güncelle
                    updateBulkButtonState();
                });
            });
            
            // Durum seçimi değiştiğinde buton durumunu güncelle
            if (bulkStatusSelect) {
                bulkStatusSelect.addEventListener('change', function() {
                    updateBulkButtonState();
                });
            }
            
            // Toplu Durum Güncelleme butonu
            if (bulkUpdateBtn) {
                bulkUpdateBtn.addEventListener('click', function() {
                    const selectedStatus = bulkStatusSelect.value;
                    
                    if (!selectedStatus) {
                        alert('Lütfen bir durum seçin.');
                        return;
                    }
                    
                    if (confirm('Seçilen geri bildirimlerin durumunu güncellemek istediğinize emin misiniz?')) {
                        // Seçilen ID'leri al
                        const ids = [];
                        feedbackCheckboxes.forEach(checkbox => {
                            if (checkbox.checked) {
                                ids.push(checkbox.value);
                            }
                        });
                        
                        // Form değerlerini ayarla
                        bulkAction.value = 'update_status';
                        bulkStatus.value = selectedStatus;
                        selectedIds.value = ids.join(',');
                        
                        // Formu gönder
                        bulkActionForm.submit();
                    }
                });
            }
            
            // Toplu Silme butonu
            if (bulkDeleteBtn) {
                bulkDeleteBtn.addEventListener('click', function() {
                    if (confirm('Seçilen geri bildirimleri silmek istediğinize emin misiniz?')) {
                        // Seçilen ID'leri al
                        const ids = [];
                        feedbackCheckboxes.forEach(checkbox => {
                            if (checkbox.checked) {
                                ids.push(checkbox.value);
                            }
                        });
                        
                        // Form değerlerini ayarla
                        bulkAction.value = 'delete';
                        selectedIds.value = ids.join(',');
                        
                        // Formu gönder
                        bulkActionForm.submit();
                    }
                });
            }
            
            // Tümünü Seç checkbox'ını güncelle
            function updateSelectAllCheckbox() {
                if (selectAllCheckbox) {
                    const checkedCount = document.querySelectorAll('.feedback-checkbox:checked').length;
                    const totalCount = feedbackCheckboxes.length;
                    
                    selectAllCheckbox.checked = checkedCount === totalCount && totalCount > 0;
                    selectAllCheckbox.indeterminate = checkedCount > 0 && checkedCount < totalCount;
                }
            }
            
            // Buton durumunu güncelle
            function updateBulkButtonState() {
                const checkedCount = document.querySelectorAll('.feedback-checkbox:checked').length;
                const selectedStatus = bulkStatusSelect.value;
                
                if (bulkDeleteBtn) {
                    bulkDeleteBtn.disabled = checkedCount === 0;
                }
                
                if (bulkUpdateBtn) {
                    bulkUpdateBtn.disabled = checkedCount === 0 || !selectedStatus;
                }
            }
        });
    </script>
</body>
</html>
