<?php
/**
 * Dijital Menü - Admin Panel Sidebar
 */

// Admin paneli dilini al
$adminLanguage = getAdminLanguage();

// Aktif kullanıcı bilgilerini al
$currentUser = [];
$currentUserId = $_SESSION['user_id'];
$currentUserSql = "SELECT * FROM users WHERE id = " . $currentUserId;
$currentUserResult = $conn->query($currentUserSql);

if ($currentUserResult && $currentUserResult->num_rows === 1) {
    $currentUser = $currentUserResult->fetch_assoc();
} else {
    $currentUser = [
        'name' => 'Admin',
        'role' => 'admin'
    ];
}

// Aktif sayfa
$currentPage = basename($_SERVER['PHP_SELF']);
?>
<!-- Mobil Header - Sadece mobil görünümde -->
<div class="mobile-admin-header d-md-none d-flex justify-content-between align-items-center p-3">
    <div class="d-flex align-items-center">
        <?php if (!empty($settings['logo'])): ?>
        <img src="../assets/img/<?php echo $settings['logo']; ?>" alt="<?php echo $settings['site_title'] ?? 'Dijital Menü'; ?>" class="img-fluid me-2" style="max-height: 30px;">
        <?php else: ?>
        <h4 class="mb-0"><?php echo $settings['site_title'] ?? 'Dijital Menü'; ?></h4>
        <?php endif; ?>
    </div>
    <button class="btn btn-primary mobile-menu-toggle">
        <i class="fas fa-bars"></i>
    </button>
</div>

<!-- Sidebar -->
<div class="col-md-3 col-lg-2 admin-sidebar p-0" id="adminSidebar">
    <div class="d-flex flex-column p-3">
        <!-- Logo -->
        <div class="text-center mb-4">
            <?php if (!empty($settings['logo'])): ?>
            <img src="../assets/img/<?php echo $settings['logo']; ?>" alt="<?php echo $settings['site_title'] ?? 'Dijital Menü'; ?>" class="img-fluid" style="max-height: 50px;">
            <?php else: ?>
            <h4 class="text-white"><?php echo $settings['site_title'] ?? 'Dijital Menü'; ?></h4>
            <?php endif; ?>
        </div>
        
        <!-- Kullanıcı Bilgisi -->
        <div class="text-center mb-4">
            <div class="mb-2">
                <i class="fas fa-user-circle fa-3x text-white"></i>
            </div>
            <div class="text-white">
                <div class="fw-bold"><?php echo $currentUser['name']; ?></div>
                <small><?php echo ucfirst($currentUser['role']); ?></small>
            </div>
        </div>
        
        <!-- Menü -->
        <ul class="nav flex-column">
            <li class="nav-item">
                <a href="index.php" class="nav-link <?php echo ($currentPage == 'index.php') ? 'active' : ''; ?>">
                    <i class="fas fa-tachometer-alt"></i> Gösterge Paneli
                </a>
            </li>
            <li class="nav-item">
                <a href="categories.php" class="nav-link <?php echo ($currentPage == 'categories.php') ? 'active' : ''; ?>">
                    <i class="fas fa-list"></i> Kategoriler
                </a>
            </li>
            <li class="nav-item">
                <a href="items.php" class="nav-link <?php echo ($currentPage == 'items.php') ? 'active' : ''; ?>">
                    <i class="fas fa-utensils"></i> Ürünler
                </a>
            </li>
            <li class="nav-item">
                <a href="allergens.php" class="nav-link <?php echo ($currentPage == 'allergens.php') ? 'active' : ''; ?>">
                    <i class="fas fa-exclamation-circle"></i> Alerjenler
                </a>
            </li>
            <li class="nav-item">
                <a href="features.php" class="nav-link <?php echo ($currentPage == 'features.php') ? 'active' : ''; ?>">
                    <i class="fas fa-tags"></i> Özellikler
                </a>
            </li>
            <li class="nav-item">
                <a href="tables.php" class="nav-link <?php echo ($currentPage == 'tables.php') ? 'active' : ''; ?>">
                    <i class="fas fa-chair"></i> Masalar
                </a>
            </li>
            <li class="nav-item">
                <a href="waiter-calls.php" class="nav-link <?php echo ($currentPage == 'waiter-calls.php') ? 'active' : ''; ?>">
                    <i class="fas fa-bell"></i> Garson Çağrıları
                </a>
            </li>
            <li class="nav-item">
                <a href="ratings.php" class="nav-link <?php echo ($currentPage == 'ratings.php') ? 'active' : ''; ?>">
                    <i class="fas fa-star"></i> Puanlama Yönetimi
                </a>
            </li>
            <li class="nav-item">
                <a href="feedbacks.php" class="nav-link <?php echo ($currentPage == 'feedbacks.php') ? 'active' : ''; ?>">
                    <i class="fas fa-comment-alt"></i> Geri Bildirimler
                </a>
            </li>
            <li class="nav-item">
                <a href="sliders.php" class="nav-link <?php echo ($currentPage == 'sliders.php') ? 'active' : ''; ?>">
                    <i class="fas fa-images"></i> Slider Yönetimi
                </a>
            </li>
            <li class="nav-item">
                <a href="languages.php" class="nav-link <?php echo ($currentPage == 'languages.php') ? 'active' : ''; ?>">
                    <i class="fas fa-language"></i> Diller
                </a>
            </li>
            <li class="nav-item">
                <a href="translations.php" class="nav-link <?php echo ($currentPage == 'translations.php') ? 'active' : ''; ?>">
                    <i class="fas fa-globe"></i> Çeviriler
                </a>
            </li>
            <li class="nav-item">
                <a href="users.php" class="nav-link <?php echo ($currentPage == 'users.php') ? 'active' : ''; ?>">
                    <i class="fas fa-users"></i> Kullanıcılar
                </a>
            </li>
            <li class="nav-item">
                <a href="settings.php" class="nav-link <?php echo ($currentPage == 'settings.php') ? 'active' : ''; ?>">
                    <i class="fas fa-cog"></i> Ayarlar
                </a>
            </li>
            <!-- ChatBot menü öğesi kaldırıldı -->
            <li class="nav-item mt-3">
                <a href="logout.php" class="nav-link text-danger">
                    <i class="fas fa-sign-out-alt"></i> Çıkış
                </a>
            </li>
        </ul>
    </div>
</div>
