<?php
/**
 * Dijital Menü - Menü Öğeleri Sayfası
 */

// İstanbul saatini ayarla
date_default_timezone_set('Europe/Istanbul');

// Gerekli dosyaları dahil et
require_once '../includes/auth.php';
require_once '../includes/language.php';

// Admin paneli dilini al
$adminLanguage = getAdminLanguage();

// Giriş yapılmamışsa yönlendir
redirectIfNotLoggedIn('login.php');

// Admin yetkisi kontrolü
requirePermission('admin', 'login.php');

// Sayfa başlığı
$pageTitle = __('admin.items', [], $adminLanguage);

// Ayarları al
$settings = getSetting();

// Menü öğesi işlemleri
$action = isset($_GET['action']) ? $_GET['action'] : 'list';
$itemId = isset($_GET['id']) ? intval($_GET['id']) : 0;
$error = '';
$success = '';

// Sıralama işlemleri
if (isset($_GET['move'])) {
    $moveDirection = $_GET['move'];
    $moveId = isset($_GET['id']) ? intval($_GET['id']) : 0;
    
    if ($moveId > 0) {
        // Menü öğesini al
        $stmt = $conn->prepare("SELECT * FROM items WHERE id = ?");
        $stmt->bind_param("i", $moveId);
        $stmt->execute();
        $result = $stmt->get_result();
        
        if ($result->num_rows === 1) {
            $item = $result->fetch_assoc();
            $currentOrder = $item['sort_order'];
            $categoryId = $item['category_id'];
            
            if ($moveDirection === 'up') {
                // Bir üst sıradaki menü öğesini bul (aynı kategoride)
                $stmt = $conn->prepare("SELECT * FROM items WHERE category_id = ? AND sort_order < ? ORDER BY sort_order DESC LIMIT 1");
                $stmt->bind_param("ii", $categoryId, $currentOrder);
                $stmt->execute();
                $result = $stmt->get_result();
                
                if ($result->num_rows === 1) {
                    $swapItem = $result->fetch_assoc();
                    
                    // Sıraları değiştir
                    $stmt = $conn->prepare("UPDATE items SET sort_order = ? WHERE id = ?");
                    $stmt->bind_param("ii", $swapItem['sort_order'], $moveId);
                    $stmt->execute();
                    
                    $stmt = $conn->prepare("UPDATE items SET sort_order = ? WHERE id = ?");
                    $stmt->bind_param("ii", $currentOrder, $swapItem['id']);
                    $stmt->execute();
                    
                    $_SESSION['success_message'] = 'Menü öğesi sırası güncellendi.';
                }
            } elseif ($moveDirection === 'down') {
                // Bir alt sıradaki menü öğesini bul (aynı kategoride)
                $stmt = $conn->prepare("SELECT * FROM items WHERE category_id = ? AND sort_order > ? ORDER BY sort_order ASC LIMIT 1");
                $stmt->bind_param("ii", $categoryId, $currentOrder);
                $stmt->execute();
                $result = $stmt->get_result();
                
                if ($result->num_rows === 1) {
                    $swapItem = $result->fetch_assoc();
                    
                    // Sıraları değiştir
                    $stmt = $conn->prepare("UPDATE items SET sort_order = ? WHERE id = ?");
                    $stmt->bind_param("ii", $swapItem['sort_order'], $moveId);
                    $stmt->execute();
                    
                    $stmt = $conn->prepare("UPDATE items SET sort_order = ? WHERE id = ?");
                    $stmt->bind_param("ii", $currentOrder, $swapItem['id']);
                    $stmt->execute();
                    
                    $_SESSION['success_message'] = 'Menü öğesi sırası güncellendi.';
                }
            }
        }
    }
    
    redirect('items.php');
}

// Menü öğesi silme işlemi
if (isset($_GET['delete']) && $itemId > 0) {
    // Menü öğesini sil
    $stmt = $conn->prepare("DELETE FROM items WHERE id = ?");
    $stmt->bind_param("i", $itemId);
    
    if ($stmt->execute()) {
        // Alerjen ilişkilerini de sil
        $conn->query("DELETE FROM item_allergens WHERE item_id = $itemId");
        
        // Özellik ilişkilerini de sil
        $conn->query("DELETE FROM item_features WHERE item_id = $itemId");
        
        // Menü öğesi başarıyla silindi
        
        $_SESSION['success_message'] = 'Menü öğesi başarıyla silindi.';
    } else {
        $_SESSION['error_message'] = 'Menü öğesi silinirken bir hata oluştu.';
    }
    
    redirect('items.php');
}

// Menü öğesi ekleme/düzenleme işlemi
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Form verilerini al
    $name = isset($_POST['name']) ? clean($_POST['name']) : '';
    $description = isset($_POST['description']) ? clean($_POST['description']) : '';
    $price = isset($_POST['price']) ? floatval(str_replace(',', '.', $_POST['price'])) : 0;
    $categoryId = isset($_POST['category_id']) ? intval($_POST['category_id']) : 0;
    $sortOrder = isset($_POST['sort_order']) ? intval($_POST['sort_order']) : 0;
    // Menü özellikleri etkinleştirilmişse, değerleri al, değilse 0 olarak ayarla
    if (isset($settings['enable_item_features']) && $settings['enable_item_features'] == 1) {
        $isVegetarian = isset($_POST['is_vegetarian']) ? 1 : 0;
        $isVegan = isset($_POST['is_vegan']) ? 1 : 0;
        $isGlutenFree = isset($_POST['is_gluten_free']) ? 1 : 0;
    } else {
        $isVegetarian = 0;
        $isVegan = 0;
        $isGlutenFree = 0;
    }
    $status = isset($_POST['status']) ? 1 : 0;
    $allergens = isset($_POST['allergens']) ? $_POST['allergens'] : [];
    $features = isset($_POST['features']) ? $_POST['features'] : [];
    
    // Resim yükleme
    $image = '';
    if (isset($_FILES['image']) && $_FILES['image']['error'] == 0) {
        $image = uploadFile($_FILES['image'], '../assets/uploads', ['png', 'jpg', 'jpeg', 'gif']);
        
        if (!$image) {
            $error = 'Resim yüklenirken bir hata oluştu.';
        }
    } elseif ($action === 'edit' && isset($_POST['current_image']) && !empty($_POST['current_image'])) {
        $image = $_POST['current_image'];
    }
    
    // Boş alan kontrolü
    if (empty($name) || $price <= 0 || $categoryId <= 0) {
        $error = 'Ad, fiyat ve kategori alanları boş bırakılamaz.';
    } else {
        if ($action === 'add') {
            // Menü öğesi ekle
            $stmt = $conn->prepare("INSERT INTO items (name, description, price, category_id, image, sort_order, status) VALUES (?, ?, ?, ?, ?, ?, ?)");
            $stmt->bind_param("sssissi", $name, $description, $price, $categoryId, $image, $sortOrder, $status);
            
            if ($stmt->execute()) {
                $newItemId = $conn->insert_id;
                
                // Alerjen ilişkilerini ekle
                if (!empty($allergens)) {
                    foreach ($allergens as $allergenId) {
                        $stmt = $conn->prepare("INSERT INTO item_allergens (item_id, allergen_id) VALUES (?, ?)");
                        $stmt->bind_param("ii", $newItemId, $allergenId);
                        $stmt->execute();
                    }
                }
                
                // Özellik ilişkilerini ekle
                if (!empty($features)) {
                    foreach ($features as $featureId) {
                        $stmt = $conn->prepare("INSERT INTO item_features (item_id, feature_id) VALUES (?, ?)");
                        $stmt->bind_param("ii", $newItemId, $featureId);
                        $stmt->execute();
                    }
                }
                
                // Menü öğesi başarıyla eklendi
                
                $_SESSION['success_message'] = 'Menü öğesi başarıyla eklendi.';
                redirect('items.php');
            } else {
                $error = 'Menü öğesi eklenirken bir hata oluştu.';
            }
        } elseif ($action === 'edit' && $itemId > 0) {
            // Menü öğesi güncelle
            $stmt = $conn->prepare("UPDATE items SET name = ?, description = ?, price = ?, category_id = ?, image = ?, sort_order = ?, status = ? WHERE id = ?");
            $stmt->bind_param("sssissii", $name, $description, $price, $categoryId, $image, $sortOrder, $status, $itemId);
            
            if ($stmt->execute()) {
                // Alerjen ilişkilerini güncelle
                $conn->query("DELETE FROM item_allergens WHERE item_id = $itemId");
                
                if (!empty($allergens)) {
                    foreach ($allergens as $allergenId) {
                        $stmt = $conn->prepare("INSERT INTO item_allergens (item_id, allergen_id) VALUES (?, ?)");
                        $stmt->bind_param("ii", $itemId, $allergenId);
                        $stmt->execute();
                    }
                }
                
                // Özellik ilişkilerini güncelle
                $conn->query("DELETE FROM item_features WHERE item_id = $itemId");
                
                if (!empty($features)) {
                    foreach ($features as $featureId) {
                        $stmt = $conn->prepare("INSERT INTO item_features (item_id, feature_id) VALUES (?, ?)");
                        $stmt->bind_param("ii", $itemId, $featureId);
                        $stmt->execute();
                    }
                }
                
                // Menü öğesi başarıyla güncellendi
                
                $_SESSION['success_message'] = 'Menü öğesi başarıyla güncellendi.';
                redirect('items.php');
            } else {
                $error = 'Menü öğesi güncellenirken bir hata oluştu.';
            }
        }
    }
}

// Menü öğesi bilgilerini al
$item = [];
if ($action === 'edit' && $itemId > 0) {
    $stmt = $conn->prepare("SELECT * FROM items WHERE id = ?");
    $stmt->bind_param("i", $itemId);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows === 1) {
        $item = $result->fetch_assoc();
        
        // Menü öğesinin alerjenlerini al
        $itemAllergens = [];
        $result = $conn->query("SELECT allergen_id FROM item_allergens WHERE item_id = $itemId");
        while ($row = $result->fetch_assoc()) {
            $itemAllergens[] = $row['allergen_id'];
        }
        $item['allergens'] = $itemAllergens;
    } else {
        $_SESSION['error_message'] = 'Menü öğesi bulunamadı.';
        redirect('items.php');
    }
}

// Arama ve filtreleme
$search = isset($_GET['search']) ? clean($_GET['search']) : '';
$categoryFilter = isset($_GET['category_id']) ? intval($_GET['category_id']) : 0;
$statusFilter = isset($_GET['status']) ? $_GET['status'] : '';

// Menü öğelerini al
$sql = "SELECT i.*, c.name as category_name FROM items i JOIN categories c ON i.category_id = c.id";
$conditions = [];

// Arama filtresi
if (!empty($search)) {
    $conditions[] = "(LOWER(i.name) LIKE LOWER('%$search%') OR LOWER(i.description) LIKE LOWER('%$search%'))";
}

// Kategori filtresi
if ($categoryFilter > 0) {
    $conditions[] = "i.category_id = $categoryFilter";
}

// Durum filtresi
if ($statusFilter !== '') {
    $conditions[] = "i.status = " . intval($statusFilter);
}

// Koşulları SQL sorgusuna ekle
if (!empty($conditions)) {
    $sql .= " WHERE " . implode(" AND ", $conditions);
}

// Sıralama
$sql .= " ORDER BY i.category_id ASC, i.sort_order ASC, i.name ASC";

// Sorguyu çalıştır
$result = $conn->query($sql);
$items = [];

while ($row = $result->fetch_assoc()) {
    $items[] = $row;
}

// Tüm kategorileri al
$categories = getCategories(true);

// Tüm alerjenleri al
$allergens = getAllergens();

// Tüm özellikleri al
$features = [];
$result = $conn->query("SELECT * FROM features WHERE status = 1 ORDER BY sort_order ASC, name ASC");
while ($row = $result->fetch_assoc()) {
    $features[] = $row;
}

// Menü öğesinin özelliklerini al
$itemFeatures = [];
if ($action === 'edit' && $itemId > 0) {
    $result = $conn->query("SELECT feature_id FROM item_features WHERE item_id = $itemId");
    while ($row = $result->fetch_assoc()) {
        $itemFeatures[] = $row['feature_id'];
    }
}

// Aktif kullanıcı bilgilerini al
$user = getUser($_SESSION['user_id']);
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $pageTitle; ?> | <?php echo $settings['site_title'] ?? 'Dijital Menü'; ?></title>
    
    <!-- Favicon -->
    <?php if (!empty($settings['favicon'])): ?>
    <link rel="shortcut icon" href="../assets/img/<?php echo $settings['favicon']; ?>" type="image/x-icon">
    <?php endif; ?>
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    
    <!-- Ana CSS -->
    <link href="../assets/css/style.css" rel="stylesheet">
    <link href="../assets/css/admin.css" rel="stylesheet">
    
    <!-- Özel Renkler -->
    <style>
        :root {
            --primary-color: <?php echo $settings['primary_color'] ?? '#3490dc'; ?>;
            --secondary-color: <?php echo $settings['secondary_color'] ?? '#38c172'; ?>;
            --text-color: <?php echo $settings['text_color'] ?? '#333333'; ?>;
            --background-color: <?php echo $settings['background_color'] ?? '#ffffff'; ?>;
        }
    </style>
</head>
<body>
    <!-- Mobil menü kaldırıldı -->
    
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <?php include 'includes/sidebar.php'; ?>
            
            <!-- Ana İçerik -->
            <div class="col-md-9 col-lg-10 admin-content">
                <!-- Üst Başlık -->
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h1 class="h3"><?php echo $pageTitle; ?></h1>
                    <?php if ($action === 'list'): ?>
                    <a href="items.php?action=add" class="btn btn-primary">
                        <i class="fas fa-plus-circle"></i> <?php echo __('admin.add_item', [], $adminLanguage); ?>
                    </a>
                    <?php else: ?>
                    <a href="items.php" class="btn btn-secondary">
                        <i class="fas fa-arrow-left"></i> <?php echo __('admin.go_back', [], $adminLanguage); ?>
                    </a>
                    <?php endif; ?>
                </div>
                
                <?php if ($action === 'list'): ?>
                <!-- Arama ve Filtre -->
                <div class="card mb-4">
                    <div class="card-body">
                        <form method="get" action="items.php" class="row g-3">
                            <div class="col-md-4">
                                <div class="input-group">
                                    <input type="text" class="form-control" name="search" placeholder="<?php echo __('admin.search', [], $adminLanguage); ?>..." value="<?php echo isset($_GET['search']) ? htmlspecialchars($_GET['search']) : ''; ?>">
                                    <button class="btn btn-outline-secondary" type="submit">
                                        <i class="fas fa-search"></i>
                                    </button>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <select class="form-select" name="category_id">
                                    <option value=""><?php echo __('admin.all_categories', [], $adminLanguage); ?></option>
                                    <?php foreach ($categories as $category): ?>
                                    <option value="<?php echo $category['id']; ?>" <?php echo (isset($_GET['category_id']) && $_GET['category_id'] == $category['id']) ? 'selected' : ''; ?>>
                                        <?php echo $category['name']; ?>
                                    </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="col-md-3">
                                <select class="form-select" name="status">
                                    <option value=""><?php echo __('admin.all_status', [], $adminLanguage); ?></option>
                                    <option value="1" <?php echo (isset($_GET['status']) && $_GET['status'] == '1') ? 'selected' : ''; ?>><?php echo __('admin.active', [], $adminLanguage); ?></option>
                                    <option value="0" <?php echo (isset($_GET['status']) && $_GET['status'] == '0') ? 'selected' : ''; ?>><?php echo __('admin.inactive', [], $adminLanguage); ?></option>
                                </select>
                            </div>
                            <div class="col-md-2">
                                <a href="items.php" class="btn btn-outline-secondary w-100">
                                    <i class="fas fa-redo"></i> <?php echo __('admin.reset', [], $adminLanguage); ?>
                                </a>
                            </div>
                        </form>
                    </div>
                </div>
                <?php endif; ?>
                
                <!-- Oturum Mesajı -->
                <?php if (isset($_SESSION['error_message'])): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <?php echo $_SESSION['error_message']; ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
                <?php unset($_SESSION['error_message']); ?>
                <?php endif; ?>
                
                <?php if (isset($_SESSION['success_message'])): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <?php echo $_SESSION['success_message']; ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
                <?php unset($_SESSION['success_message']); ?>
                <?php endif; ?>
                
                <?php if (!empty($error)): ?>
                <div class="alert alert-danger"><?php echo $error; ?></div>
                <?php endif; ?>
                
                <?php if (!empty($success)): ?>
                <div class="alert alert-success"><?php echo $success; ?></div>
                <?php endif; ?>
                
                <!-- İçerik -->
                <div class="admin-card">
                    <?php if ($action === 'list'): ?>
                    <!-- Menü Öğesi Listesi -->
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th class="d-none"><?php echo __('admin.id', [], $adminLanguage); ?></th>
                                    <th><?php echo __('admin.image', [], $adminLanguage); ?></th>
                                    <th><?php echo __('admin.name', [], $adminLanguage); ?></th>
                                    <th><?php echo __('admin.price', [], $adminLanguage); ?></th>
                                    <th><?php echo __('admin.category', [], $adminLanguage); ?></th>
                                    <th><?php echo __('admin.sort_order', [], $adminLanguage); ?></th>
                                    <th><?php echo __('admin.features', [], $adminLanguage); ?></th>
                                    <th><?php echo __('admin.status', [], $adminLanguage); ?></th>
                                    <th><?php echo __('admin.actions', [], $adminLanguage); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if (empty($items)): ?>
                                <tr>
                                    <td colspan="9" class="text-center"><?php echo __('admin.no_items', [], $adminLanguage); ?></td>
                                </tr>
                                <?php else: ?>
                                <?php 
                                $currentCategory = null;
                                foreach ($items as $item): 
                                    // Kategori başlığı ekle
                                    if ($currentCategory !== $item['category_id']):
                                        $currentCategory = $item['category_id'];
                                ?>
                                <tr class="table-secondary">
                                    <td colspan="9" class="fw-bold"><?php echo $item['category_name']; ?></td>
                                </tr>
                                <?php endif; ?>
                                <tr>
                                    <td class="d-none"><?php echo $item['id']; ?></td>
                                    <td>
                                        <?php if (!empty($item['image'])): ?>
                                        <img src="../assets/uploads/<?php echo $item['image']; ?>" alt="<?php echo $item['name']; ?>" width="50" height="50" style="object-fit: cover;">
                                        <?php else: ?>
                                        <img src="../assets/img/no-image.jpg" alt="No Image" width="50" height="50" style="object-fit: cover;">
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo $item['name']; ?></td>
                                    <td><?php echo formatMoney($item['price']); ?></td>
                                    <td><?php echo $item['category_name']; ?></td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <?php 
                                            // Her kategori için sıralama sayacını takip et
                                            static $categoryCounters = [];
                                            $categoryId = $item['category_id'];
                                            
                                            // Eğer bu kategori için sayaç yoksa, oluştur
                                            if (!isset($categoryCounters[$categoryId])) {
                                                $categoryCounters[$categoryId] = 0;
                                            }
                                            
                                            // Sayacı artır ve göster
                                            $categoryCounters[$categoryId]++;
                                            ?>
                                            <span class="me-2"><?php echo $categoryCounters[$categoryId]; ?></span>
                                            <div class="btn-group-vertical btn-group-sm">
                                                <a href="items.php?move=up&id=<?php echo $item['id']; ?>" class="btn btn-outline-secondary btn-sm">
                                                    <i class="fas fa-arrow-up"></i>
                                                </a>
                                                <a href="items.php?move=down&id=<?php echo $item['id']; ?>" class="btn btn-outline-secondary btn-sm">
                                                    <i class="fas fa-arrow-down"></i>
                                                </a>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        
                                        <?php if (isset($settings['enable_item_features']) && $settings['enable_item_features'] == 1): ?>
                                            
                                            <!-- Dinamik Özellikler -->
                                            <?php
                                            // Menü öğesinin özelliklerini al
                                            $itemFeaturesList = [];
                                            $resultFeatures = $conn->query("SELECT f.* FROM features f JOIN item_features itf ON f.id = itf.feature_id WHERE itf.item_id = " . $item['id'] . " AND f.status = 1");
                                            while ($featureRow = $resultFeatures->fetch_assoc()) {
                                                echo '<span class="badge" style="background-color: ' . $featureRow['color'] . ';" data-bs-toggle="tooltip" title="' . $featureRow['name'] . '">';
                                                if (!empty($featureRow['icon'])) {
                                                    // Eğer ikon zaten fa- ile başlıyorsa, tekrar ekleme
                                                    $iconClass = strpos($featureRow['icon'], 'fa-') === 0 ? $featureRow['icon'] : 'fa-' . $featureRow['icon'];
                                                    echo '<i class="fas ' . $iconClass . '"></i>';
                                                }
                                                echo '</span> ';
                                            }
                                            ?>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if ($item['status'] == 1): ?>
                                        <span class="badge bg-success"><?php echo __('admin.active', [], $adminLanguage); ?></span>
                                        <?php else: ?>
                                        <span class="badge bg-danger"><?php echo __('admin.inactive', [], $adminLanguage); ?></span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <a href="items.php?action=edit&id=<?php echo $item['id']; ?>" class="btn btn-sm btn-primary">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <a href="items.php?delete=1&id=<?php echo $item['id']; ?>" class="btn btn-sm btn-danger" onclick="return confirm('<?php echo __('admin.confirm_delete', [], $adminLanguage); ?>');">
                                            <i class="fas fa-trash"></i>
                                        </a>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                    <?php else: ?>
                    <!-- Menü Öğesi Formu -->
                    <form method="post" action="<?php echo htmlspecialchars($_SERVER['PHP_SELF'] . '?action=' . $action . ($itemId ? '&id=' . $itemId : '')); ?>" enctype="multipart/form-data">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="name" class="form-label"><?php echo __('admin.name', [], $adminLanguage); ?> <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" id="name" name="name" value="<?php echo $item['name'] ?? ''; ?>" required>
                                </div>
                                
                                <div class="mb-3">
                                    <label for="description" class="form-label"><?php echo __('admin.description', [], $adminLanguage); ?></label>
                                    <textarea class="form-control" id="description" name="description" rows="3"><?php echo $item['description'] ?? ''; ?></textarea>
                                </div>

                                <?php if (isset($item['id']) && $item['id'] > 0): ?>
                                <div class="mb-3">
                                    <label class="form-label"><?php echo __('admin.translations', [], $adminLanguage); ?></label>
                                    <div class="alert alert-info">
                                        <i class="fas fa-info-circle"></i> <?php echo __('admin.item_translations', [], $adminLanguage); ?> <a href="translations.php?type=items&language=<?php echo getDefaultLanguage(); ?>" target="_blank"><?php echo __('admin.translations', [], $adminLanguage); ?></a>
                                    </div>
                                </div>
                                <?php endif; ?>
                                
                                <div class="mb-3">
                                    <label for="price" class="form-label"><?php echo __('admin.price', [], $adminLanguage); ?> <span class="text-danger">*</span></label>
                                    <div class="input-group">
                                        <input type="text" class="form-control" id="price" name="price" value="<?php echo isset($item['price']) ? number_format($item['price'], 2, ',', '.') : ''; ?>" required>
                                        <span class="input-group-text"><?php echo $settings['currency_symbol'] ?? '₺'; ?></span>
                                    </div>
                                </div>
                                
                                <div class="mb-3">
                                    <label for="category_id" class="form-label"><?php echo __('admin.category', [], $adminLanguage); ?> <span class="text-danger">*</span></label>
                                    <select class="form-select" id="category_id" name="category_id" required>
                                        <?php foreach ($categories as $category): ?>
                                        <option value="<?php echo $category['id']; ?>" <?php echo (isset($item['category_id']) && intval($item['category_id']) === intval($category['id'])) ? 'selected' : ''; ?>>
                                            <?php echo $category['name']; ?>
                                        </option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                                
                                <div class="mb-3">
                                    <label for="sort_order" class="form-label"><?php echo __('admin.sort_order', [], $adminLanguage); ?></label>
                                    <input type="number" class="form-control" id="sort_order" name="sort_order" value="<?php echo $item['sort_order'] ?? 0; ?>" min="0">
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="image" class="form-label"><?php echo __('admin.image', [], $adminLanguage); ?></label>
                                    <?php if (isset($item['image']) && !empty($item['image'])): ?>
                                    <div class="mb-2 text-center">
                                        <img src="../assets/uploads/<?php echo $item['image']; ?>" alt="<?php echo $item['name']; ?>" class="img-thumbnail" style="max-height: 150px;">
                                        <input type="hidden" name="current_image" value="<?php echo $item['image']; ?>">
                                    </div>
                                    <?php endif; ?>
                                    <input type="file" class="form-control" id="image" name="image" accept="image/*">
                                </div>
                                
                                <div class="mb-3">
                                    <label class="form-label"><?php echo __('admin.features', [], $adminLanguage); ?></label>
                                    
                                    <?php if (isset($settings['enable_item_features']) && $settings['enable_item_features'] == 1): ?>
                                    <!-- Sadece Dinamik Özellikler -->
                                    <div class="mt-2">
                                        <h6 class="mb-2">Özellikler</h6>
                                        <?php foreach ($features as $feature): ?>
                                        <div class="form-check">
                                            <input type="checkbox" class="form-check-input" id="feature_<?php echo $feature['id']; ?>" name="features[]" value="<?php echo $feature['id']; ?>" <?php echo (isset($itemFeatures) && in_array($feature['id'], $itemFeatures)) ? 'checked' : ''; ?>>
                                            <label class="form-check-label" for="feature_<?php echo $feature['id']; ?>">
                                                <?php if (!empty($feature['icon'])): ?>
                                                <i class="fas <?php echo strpos($feature['icon'], 'fa-') === 0 ? $feature['icon'] : 'fa-' . $feature['icon']; ?>" style="color: <?php echo $feature['color']; ?>;"></i>
                                                <?php endif; ?>
                                                <?php echo $feature['name']; ?>
                                            </label>
                                        </div>
                                        <?php endforeach; ?>
                                    </div>
                                    
                                    <!-- Yerleşik özellikleri gizli alan olarak ekle (geriye dönük uyumluluk için) -->
                                    <input type="hidden" name="is_vegetarian" value="0">
                                    <input type="hidden" name="is_vegan" value="0">
                                    <input type="hidden" name="is_gluten_free" value="0">
                                    <?php endif; ?>
                                </div>
                                
                                <div class="mb-3 form-check">
                                    <input type="checkbox" class="form-check-input" id="status" name="status" <?php echo (isset($item['status']) && $item['status'] == 1) ? 'checked' : ''; ?>>
                                    <label class="form-check-label" for="status"><?php echo __('admin.active', [], $adminLanguage); ?></label>
                                </div>
                            </div>
                        </div>
                        
                        <div class="mb-4">
                            <label class="form-label"><?php echo __('admin.allergens', [], $adminLanguage); ?></label>
                            <div class="row">
                                <?php foreach ($allergens as $allergen): ?>
                                <div class="col-md-4 mb-2">
                                    <div class="form-check">
                                        <input type="checkbox" class="form-check-input" id="allergen_<?php echo $allergen['id']; ?>" name="allergens[]" value="<?php echo $allergen['id']; ?>" <?php echo (isset($item['allergens']) && in_array($allergen['id'], $item['allergens'])) ? 'checked' : ''; ?>>
                                        <label class="form-check-label" for="allergen_<?php echo $allergen['id']; ?>">
                                            <?php if (!empty($allergen['icon'])): ?>
                                            <img src="../assets/img/<?php echo $allergen['icon']; ?>" alt="<?php echo $allergen['name']; ?>" width="20" height="20" class="me-1">
                                            <?php endif; ?>
                                            <?php echo $allergen['name']; ?>
                                        </label>
                                    </div>
                                </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                        
                        <div class="mt-4">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> <?php echo __('admin.save', [], $adminLanguage); ?>
                            </button>
                            <a href="items.php" class="btn btn-secondary">
                                <i class="fas fa-times"></i> <?php echo __('admin.cancel', [], $adminLanguage); ?>
                            </a>
                        </div>
                    </form>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    
    <!-- Ana JS -->
    <script src="../assets/js/script.js"></script>
    <script src="../assets/js/admin.js"></script>
    
    <!-- Tooltip Aktivasyonu -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
            var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
                return new bootstrap.Tooltip(tooltipTriggerEl);
            });
        });
    </script>
</body>
</html>
