<?php
/**
 * Dijital Menü - Diller Sayfası
 */

// İstanbul saatini ayarla
date_default_timezone_set('Europe/Istanbul');

// Gerekli dosyaları dahil et
require_once '../includes/auth.php';
require_once '../includes/language.php';

// Admin paneli dilini al
$adminLanguage = getAdminLanguage();

// Giriş yapılmamışsa yönlendir
redirectIfNotLoggedIn('login.php');

// Admin yetkisi kontrolü
requirePermission('admin', 'login.php');

// Sayfa başlığı
$pageTitle = __('admin.languages', [], $adminLanguage);

// Ayarları al
$settings = getSetting();

// Dil işlemleri
$action = isset($_GET['action']) ? $_GET['action'] : 'list';
$languageId = isset($_GET['id']) ? intval($_GET['id']) : 0;
$error = '';
$success = '';

// Dil silme işlemi
if (isset($_GET['delete']) && $languageId > 0) {
    // Varsayılan dil kontrolü
    $stmt = $conn->prepare("SELECT is_default FROM languages WHERE id = ?");
    $stmt->bind_param("i", $languageId);
    $stmt->execute();
    $result = $stmt->get_result();
    $language = $result->fetch_assoc();
    
    if ($language['is_default'] == 1) {
        $_SESSION['error_message'] = 'Varsayılan dil silinemez.';
    } else {
        // Dili sil
        $stmt = $conn->prepare("DELETE FROM languages WHERE id = ?");
        $stmt->bind_param("i", $languageId);
        
        if ($stmt->execute()) {
            // Dil dosyasını sil
            $stmt = $conn->prepare("SELECT code FROM languages WHERE id = ?");
            $stmt->bind_param("i", $languageId);
            $stmt->execute();
            $result = $stmt->get_result();
            $language = $result->fetch_assoc();
            
            if (file_exists("../languages/{$language['code']}.php")) {
                unlink("../languages/{$language['code']}.php");
            }
            
            // Çevirileri sil
            $conn->query("DELETE FROM translations WHERE language_id = $languageId");
            
            $_SESSION['success_message'] = 'Dil başarıyla silindi.';
        } else {
            $_SESSION['error_message'] = 'Dil silinirken bir hata oluştu.';
        }
    }
    
    redirect('languages.php');
}

// Dil ekleme/düzenleme işlemi
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Form verilerini al
    $code = isset($_POST['code']) ? clean($_POST['code']) : '';
    $name = isset($_POST['name']) ? clean($_POST['name']) : '';
    $isDefault = isset($_POST['is_default']) ? 1 : 0;
    $status = isset($_POST['status']) ? 1 : 0;
    
    // Bayrak yükleme
    $flag = '';
    if (isset($_FILES['flag']) && $_FILES['flag']['error'] == 0) {
        $flag = uploadFile($_FILES['flag'], '../assets/img', ['png', 'jpg', 'jpeg', 'gif']);
        
        if (!$flag) {
            $error = 'Bayrak yüklenirken bir hata oluştu.';
        }
    } elseif ($action === 'edit' && isset($_POST['current_flag']) && !empty($_POST['current_flag'])) {
        $flag = $_POST['current_flag'];
    }
    
    // Boş alan kontrolü
    if (empty($code) || empty($name)) {
        $error = 'Dil kodu ve adı boş bırakılamaz.';
    } else {
        if ($action === 'add') {
            // Dil kodu kontrolü
            $stmt = $conn->prepare("SELECT COUNT(*) as count FROM languages WHERE code = ?");
            $stmt->bind_param("s", $code);
            $stmt->execute();
            $result = $stmt->get_result();
            $row = $result->fetch_assoc();
            
            if ($row['count'] > 0) {
                $error = 'Bu dil kodu zaten kullanılıyor.';
            } else {
                // Varsayılan dil kontrolü
                if ($isDefault) {
                    $conn->query("UPDATE languages SET is_default = 0");
                }
                
                // Dil ekle
                $stmt = $conn->prepare("INSERT INTO languages (code, name, flag, is_default, status) VALUES (?, ?, ?, ?, ?)");
                $stmt->bind_param("sssii", $code, $name, $flag, $isDefault, $status);
                
                if ($stmt->execute()) {
                    // Dil dosyası oluştur
                    if (!file_exists("../languages/{$code}.php")) {
                        $content = "<?php\n/**\n * Dijital Menü - " . ucfirst($name) . " Dil Dosyası\n */\n\nreturn [\n    'language_name' => '$name',\n];\n";
                        file_put_contents("../languages/{$code}.php", $content);
                    }
                    
                    $_SESSION['success_message'] = 'Dil başarıyla eklendi.';
                    redirect('languages.php');
                } else {
                    $error = 'Dil eklenirken bir hata oluştu.';
                }
            }
        } elseif ($action === 'edit' && $languageId > 0) {
            // Dil kodu kontrolü
            $stmt = $conn->prepare("SELECT COUNT(*) as count FROM languages WHERE code = ? AND id != ?");
            $stmt->bind_param("si", $code, $languageId);
            $stmt->execute();
            $result = $stmt->get_result();
            $row = $result->fetch_assoc();
            
            if ($row['count'] > 0) {
                $error = 'Bu dil kodu zaten kullanılıyor.';
            } else {
                // Eski dil kodunu al
                $stmt = $conn->prepare("SELECT code FROM languages WHERE id = ?");
                $stmt->bind_param("i", $languageId);
                $stmt->execute();
                $result = $stmt->get_result();
                $oldLanguage = $result->fetch_assoc();
                $oldCode = $oldLanguage['code'];
                
                // Varsayılan dil kontrolü
                if ($isDefault) {
                    $conn->query("UPDATE languages SET is_default = 0");
                }
                
                // Dil güncelle
                $stmt = $conn->prepare("UPDATE languages SET code = ?, name = ?, flag = ?, is_default = ?, status = ? WHERE id = ?");
                $stmt->bind_param("sssiii", $code, $name, $flag, $isDefault, $status, $languageId);
                
                if ($stmt->execute()) {
                    // Dil dosyasını güncelle
                    if ($oldCode !== $code && file_exists("../languages/{$oldCode}.php")) {
                        rename("../languages/{$oldCode}.php", "../languages/{$code}.php");
                    }
                    
                    $_SESSION['success_message'] = 'Dil başarıyla güncellendi.';
                    redirect('languages.php');
                } else {
                    $error = 'Dil güncellenirken bir hata oluştu.';
                }
            }
        }
    }
}

// Dil bilgilerini al
$language = [];
if ($action === 'edit' && $languageId > 0) {
    $stmt = $conn->prepare("SELECT * FROM languages WHERE id = ?");
    $stmt->bind_param("i", $languageId);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows === 1) {
        $language = $result->fetch_assoc();
    } else {
        $_SESSION['error_message'] = 'Dil bulunamadı.';
        redirect('languages.php');
    }
}

// Tüm dilleri al
$languages = getLanguages(false);

// Aktif kullanıcı bilgilerini al
$user = getUser($_SESSION['user_id']);
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $pageTitle; ?> | <?php echo $settings['site_title'] ?? 'Dijital Menü'; ?></title>
    
    <!-- Favicon -->
    <?php if (!empty($settings['favicon'])): ?>
    <link rel="shortcut icon" href="../assets/img/<?php echo $settings['favicon']; ?>" type="image/x-icon">
    <?php endif; ?>
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    
    <!-- Ana CSS -->
    <link href="../assets/css/style.css" rel="stylesheet">
    
    <!-- Özel Renkler -->
    <style>
        :root {
            --primary-color: <?php echo $settings['primary_color'] ?? '#3490dc'; ?>;
            --secondary-color: <?php echo $settings['secondary_color'] ?? '#38c172'; ?>;
            --text-color: <?php echo $settings['text_color'] ?? '#333333'; ?>;
            --background-color: <?php echo $settings['background_color'] ?? '#ffffff'; ?>;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <?php include 'includes/sidebar.php'; ?>
            
            <!-- Ana İçerik -->
            <div class="col-md-9 col-lg-10 admin-content">
                <!-- Üst Başlık -->
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h1 class="h3"><?php echo $pageTitle; ?></h1>
                    <?php if ($action === 'list'): ?>
                    <a href="languages.php?action=add" class="btn btn-primary">
                        <i class="fas fa-plus-circle"></i> <?php echo __('admin.add_language', [], $adminLanguage); ?>
                    </a>
                    <?php else: ?>
                    <a href="languages.php" class="btn btn-secondary">
                        <i class="fas fa-arrow-left"></i> <?php echo __('admin.go_back', [], $adminLanguage); ?>
                    </a>
                    <?php endif; ?>
                </div>
                
                <!-- Oturum Mesajı -->
                <?php if (isset($_SESSION['error_message'])): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <?php echo $_SESSION['error_message']; ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
                <?php unset($_SESSION['error_message']); ?>
                <?php endif; ?>
                
                <?php if (isset($_SESSION['success_message'])): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <?php echo $_SESSION['success_message']; ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
                <?php unset($_SESSION['success_message']); ?>
                <?php endif; ?>
                
                <?php if (!empty($error)): ?>
                <div class="alert alert-danger"><?php echo $error; ?></div>
                <?php endif; ?>
                
                <?php if (!empty($success)): ?>
                <div class="alert alert-success"><?php echo $success; ?></div>
                <?php endif; ?>
                
                <!-- İçerik -->
                <div class="admin-card">
                    <?php if ($action === 'list'): ?>
                    <!-- Dil Listesi -->
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th><?php echo __('admin.flag', [], $adminLanguage); ?></th>
                                    <th><?php echo __('admin.code', [], $adminLanguage); ?></th>
                                    <th><?php echo __('admin.name', [], $adminLanguage); ?></th>
                                    <th><?php echo __('admin.is_default', [], $adminLanguage); ?></th>
                                    <th><?php echo __('admin.status', [], $adminLanguage); ?></th>
                                    <th><?php echo __('admin.actions', [], $adminLanguage); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if (empty($languages)): ?>
                                <tr>
                                    <td colspan="7" class="text-center"><?php echo __('admin.no_languages', [], $adminLanguage); ?></td>
                                </tr>
                                <?php else: ?>
                                <?php foreach ($languages as $lang): ?>
                                <tr>
                                    <td><?php echo $lang['id']; ?></td>
                                    <td>
                                        <?php if (!empty($lang['flag'])): ?>
                                        <img src="../assets/img/<?php echo $lang['flag']; ?>" alt="<?php echo $lang['name']; ?>" width="30" height="20" class="border">
                                        <?php else: ?>
                                        <div class="bg-light rounded d-flex align-items-center justify-content-center border" style="width: 30px; height: 20px;">
                                            <i class="fas fa-flag text-muted"></i>
                                        </div>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo $lang['code']; ?></td>
                                    <td><?php echo $lang['name']; ?></td>
                                    <td>
                                        <?php if ($lang['is_default'] == 1): ?>
                                        <span class="badge bg-success"><?php echo __('admin.yes', [], $adminLanguage); ?></span>
                                        <?php else: ?>
                                        <span class="badge bg-secondary"><?php echo __('admin.no', [], $adminLanguage); ?></span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if ($lang['status'] == 1): ?>
                                        <span class="badge bg-success"><?php echo __('admin.active', [], $adminLanguage); ?></span>
                                        <?php else: ?>
                                        <span class="badge bg-danger"><?php echo __('admin.inactive', [], $adminLanguage); ?></span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <a href="languages.php?action=edit&id=<?php echo $lang['id']; ?>" class="btn btn-sm btn-primary">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <?php if ($lang['is_default'] != 1): ?>
                                        <a href="languages.php?delete=1&id=<?php echo $lang['id']; ?>" class="btn btn-sm btn-danger" onclick="return confirm('<?php echo __('admin.confirm_delete', [], $adminLanguage); ?>');">
                                            <i class="fas fa-trash"></i>
                                        </a>
                                        <?php endif; ?>
                                        <a href="translations.php?language=<?php echo $lang['code']; ?>" class="btn btn-sm btn-info">
                                            <i class="fas fa-globe"></i> <?php echo __('admin.translations', [], $adminLanguage); ?>
                                        </a>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                    <?php else: ?>
                    <!-- Dil Formu -->
                    <form method="post" action="<?php echo htmlspecialchars($_SERVER['PHP_SELF'] . '?action=' . $action . ($languageId ? '&id=' . $languageId : '')); ?>" enctype="multipart/form-data">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="code" class="form-label"><?php echo __('admin.code', [], $adminLanguage); ?> <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" id="code" name="code" value="<?php echo $language['code'] ?? ''; ?>" required <?php echo ($action === 'edit') ? 'readonly' : ''; ?>>
                                    <small class="text-muted"><?php echo __('admin.language_code_example', [], $adminLanguage); ?></small>
                                </div>
                                
                                <div class="mb-3">
                                    <label for="name" class="form-label"><?php echo __('admin.name', [], $adminLanguage); ?> <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" id="name" name="name" value="<?php echo $language['name'] ?? ''; ?>" required>
                                </div>
                                
                                <div class="mb-3">
                                    <label for="flag" class="form-label"><?php echo __('admin.flag', [], $adminLanguage); ?></label>
                                    <?php if (isset($language['flag']) && !empty($language['flag'])): ?>
                                    <div class="mb-2">
                                        <img src="../assets/img/<?php echo $language['flag']; ?>" alt="<?php echo $language['name']; ?>" width="60" height="40">
                                        <input type="hidden" name="current_flag" value="<?php echo $language['flag']; ?>">
                                    </div>
                                    <?php endif; ?>
                                    <input type="file" class="form-control" id="flag" name="flag" accept="image/*">
                                    <small class="text-muted"><?php echo __('admin.flag_size', [], $adminLanguage); ?></small>
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="mb-3 form-check">
                                    <input type="checkbox" class="form-check-input" id="is_default" name="is_default" <?php echo (isset($language['is_default']) && $language['is_default'] == 1) ? 'checked' : ''; ?>>
                                    <label class="form-check-label" for="is_default"><?php echo __('admin.is_default', [], $adminLanguage); ?></label>
                                    <div class="form-text"><?php echo __('admin.default_language_help', [], $adminLanguage); ?></div>
                                </div>
                                
                                <div class="mb-3 form-check">
                                    <input type="checkbox" class="form-check-input" id="status" name="status" <?php echo (isset($language['status']) && $language['status'] == 1) ? 'checked' : ''; ?>>
                                    <label class="form-check-label" for="status"><?php echo __('admin.active', [], $adminLanguage); ?></label>
                                    <div class="form-text"><?php echo __('admin.language_status_help', [], $adminLanguage); ?></div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="mt-4">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> <?php echo __('admin.save', [], $adminLanguage); ?>
                            </button>
                            <a href="languages.php" class="btn btn-secondary">
                                <i class="fas fa-times"></i> <?php echo __('admin.cancel', [], $adminLanguage); ?>
                            </a>
                        </div>
                    </form>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    
    <!-- Ana JS -->
    <script src="../assets/js/script.js"></script>
</body>
</html>
