<!-- Görünüm Ayarları -->
<div class="tab-pane fade" id="appearance" role="tabpanel" aria-labelledby="appearance-tab">
    <div class="row">
        <div class="col-md-12 mb-4">
            <div class="alert alert-info">
                <i class="fas fa-info-circle"></i> Görünüm ayarlarını basitleştirdik. Temel renkleri ayarlayın, diğer renkler otomatik olarak uyumlu şekilde oluşturulacaktır.
            </div>
            
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="mb-0">Temel Renkler</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label for="primary_color" class="form-label">Ana Renk</label>
                                    <input type="color" class="form-control form-control-color w-100" id="primary_color" name="primary_color" value="<?php echo $settings['primary_color'] ?? '#3490dc'; ?>">
                                    <small class="text-muted">Butonlar, bağlantılar ve vurgular için kullanılır</small>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="secondary_color" class="form-label">İkincil Renk</label>
                                    <input type="color" class="form-control form-control-color w-100" id="secondary_color" name="secondary_color" value="<?php echo $settings['secondary_color'] ?? '#38c172'; ?>">
                                    <small class="text-muted">Başarı butonları ve ikincil vurgular için kullanılır</small>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="text_color" class="form-label">Metin Rengi</label>
                                    <input type="color" class="form-control form-control-color w-100" id="text_color" name="text_color" value="<?php echo $settings['text_color'] ?? '#333333'; ?>">
                                    <small class="text-muted">Genel metin rengi</small>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="background_color" class="form-label">Arka Plan Rengi</label>
                                    <input type="color" class="form-control form-control-color w-100" id="background_color" name="background_color" value="<?php echo $settings['background_color'] ?? '#ffffff'; ?>">
                                    <small class="text-muted">Sayfa arka plan rengi</small>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="theme-preview p-3 border rounded" style="background-color: <?php echo $settings['background_color'] ?? '#ffffff'; ?>; color: <?php echo $settings['text_color'] ?? '#333333'; ?>;">
                                <h4 style="color: <?php echo $settings['text_color'] ?? '#333333'; ?>;">Tema Önizleme</h4>
                                <p>Bu bir örnek metindir. Metin rengi burada görünür.</p>
                                <button class="btn mb-2" style="background-color: <?php echo $settings['primary_color'] ?? '#3490dc'; ?>; color: #ffffff; border-color: <?php echo $settings['primary_color'] ?? '#3490dc'; ?>;">Ana Renk Butonu</button>
                                <button class="btn mb-2" style="background-color: <?php echo $settings['secondary_color'] ?? '#38c172'; ?>; color: #ffffff; border-color: <?php echo $settings['secondary_color'] ?? '#38c172'; ?>;">İkincil Renk Butonu</button>
                                <div class="mt-2">
                                    <a href="#" style="color: <?php echo $settings['primary_color'] ?? '#3490dc'; ?>;">Örnek Bağlantı</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="mb-0">Başlık Çubuğu</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label for="header_bg_color" class="form-label">Başlık Arka Plan Rengi</label>
                                    <input type="color" class="form-control form-control-color w-100" id="header_bg_color" name="header_bg_color" value="<?php echo $settings['header_bg_color'] ?? '#333333'; ?>">
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="header_text_color" class="form-label">Başlık Metin Rengi</label>
                                    <input type="color" class="form-control form-control-color w-100" id="header_text_color" name="header_text_color" value="<?php echo $settings['header_text_color'] ?? '#ffffff'; ?>">
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="header-preview p-3 rounded" style="background-color: <?php echo $settings['header_bg_color'] ?? '#333333'; ?>; color: <?php echo $settings['header_text_color'] ?? '#ffffff'; ?>;">
                                <div class="d-flex justify-content-between align-items-center">
                                    <div>
                                        <h5 style="color: <?php echo $settings['header_text_color'] ?? '#ffffff'; ?>; margin: 0;">Dijital Menü</h5>
                                    </div>
                                    <div>
                                        <button class="btn btn-sm" style="background-color: transparent; border: 1px solid rgba(255,255,255,0.3); color: <?php echo $settings['header_text_color'] ?? '#ffffff'; ?>;">Türkçe</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="mb-0">Menü Öğeleri</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label for="menu_item_bg_color" class="form-label">Menü Öğesi Arka Plan</label>
                                    <input type="color" class="form-control form-control-color w-100" id="menu_item_bg_color" name="menu_item_bg_color" value="<?php echo $settings['menu_item_bg_color'] ?? '#ffffff'; ?>">
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="menu_item_title_color" class="form-label">Menü Öğesi Başlık</label>
                                    <input type="color" class="form-control form-control-color w-100" id="menu_item_title_color" name="menu_item_title_color" value="<?php echo $settings['menu_item_title_color'] ?? '#333333'; ?>">
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="menu_item_price_color" class="form-label">Fiyat Rengi</label>
                                    <input type="color" class="form-control form-control-color w-100" id="menu_item_price_color" name="menu_item_price_color" value="<?php echo $settings['menu_item_price_color'] ?? '#3490dc'; ?>">
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="menu_item_desc_color" class="form-label">Açıklama Rengi</label>
                                    <input type="color" class="form-control form-control-color w-100" id="menu_item_desc_color" name="menu_item_desc_color" value="<?php echo $settings['menu_item_desc_color'] ?? '#666666'; ?>">
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="menu-item-preview" style="
                                display: flex;
                                flex-direction: column;
                                border-radius: 12px;
                                overflow: hidden;
                                box-shadow: 0 3px 10px rgba(0, 0, 0, 0.08);
                                background-color: <?php echo $settings['menu_item_bg_color'] ?? '#ffffff'; ?>;
                                margin-bottom: 16px;
                                position: relative;
                                max-width: 400px;
                                margin: 0 auto;
                            ">
                                <div style="
                                    width: 100%;
                                    height: 120px;
                                    overflow: hidden;
                                    position: relative;
                                    background-color: #ccc;
                                    background-image: url('../assets/uploads/67eda23feb941.jpg');
                                    background-size: cover;
                                    background-position: center;
                                "></div>
                                
                                <div style="
                                    flex: 1;
                                    padding: 12px 16px;
                                    display: flex;
                                    flex-direction: column;
                                    overflow: hidden;
                                    position: relative;
                                ">
                                    <div style="margin-bottom: 8px; overflow: hidden;">
                                        <h3 style="
                                            margin: 0 0 4px 0;
                                            font-size: 1.1rem;
                                            font-weight: 700;
                                            overflow: hidden;
                                            text-overflow: ellipsis;
                                            color: <?php echo $settings['menu_item_title_color'] ?? '#333333'; ?>;
                                            line-height: 1.3;
                                        ">Örnek Menü Öğesi</h3>
                                        
                                        <p style="
                                            margin: 0;
                                            font-size: 0.85rem;
                                            color: <?php echo $settings['menu_item_desc_color'] ?? '#666666'; ?>;
                                            overflow: hidden;
                                            text-overflow: ellipsis;
                                            display: -webkit-box;
                                            -webkit-line-clamp: 2;
                                            -webkit-box-orient: vertical;
                                            line-height: 1.4;
                                        ">Bu bir örnek menü öğesi açıklamasıdır.</p>
                                    </div>
                                    
                                    <div style="
                                        display: flex;
                                        justify-content: space-between;
                                        align-items: center;
                                        margin-top: 8px;
                                        padding-top: 8px;
                                        border-top: 1px solid #eee;
                                    ">
                                        <div>
                                            <div style="
                                                display: inline-block;
                                                font-size: 1.1rem;
                                                font-weight: 700;
                                                color: <?php echo $settings['menu_item_price_color'] ?? '#3490dc'; ?>;
                                                margin: 0;
                                            ">100,00 ₺</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="mb-0">Alt Menü</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label for="bottom_menu_color" class="form-label">Alt Menü Arka Plan</label>
                                    <input type="color" class="form-control form-control-color w-100" id="bottom_menu_color" name="bottom_menu_color" value="<?php echo $settings['bottom_menu_color'] ?? '#ffffff'; ?>">
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="bottom_menu_item_color" class="form-label">Alt Menü Öğe Rengi</label>
                                    <input type="color" class="form-control form-control-color w-100" id="bottom_menu_item_color" name="bottom_menu_item_color" value="<?php echo $settings['bottom_menu_item_color'] ?? '#777777'; ?>">
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="bottom-menu-preview" style="
                                background-color: <?php echo $settings['bottom_menu_color'] ?? '#ffffff'; ?>;
                                display: flex;
                                justify-content: space-around;
                                align-items: center;
                                padding: 12px 0;
                                box-shadow: 0 -2px 10px rgba(0, 0, 0, 0.1);
                                border-radius: 10px;
                            ">
                                <div style="
                                    display: flex;
                                    flex-direction: column;
                                    align-items: center;
                                    justify-content: center;
                                    padding: 5px 0;
                                    color: <?php echo $settings['primary_color'] ?? '#3490dc'; ?>;
                                    position: relative;
                                    width: 25%;
                                ">
                                    <i class="fas fa-home" style="font-size: 1.3rem; margin-bottom: 4px;"></i>
                                    <span style="font-size: 0.7rem; font-weight: 500;">Ana Sayfa</span>
                                </div>
                                
                                <div style="
                                    display: flex;
                                    flex-direction: column;
                                    align-items: center;
                                    justify-content: center;
                                    padding: 5px 0;
                                    color: <?php echo $settings['bottom_menu_item_color'] ?? '#777777'; ?>;
                                    position: relative;
                                    width: 25%;
                                ">
                                    <i class="fas fa-bell" style="font-size: 1.3rem; margin-bottom: 4px;"></i>
                                    <span style="font-size: 0.7rem; font-weight: 500;">Garson Çağır</span>
                                </div>
                                
                                <div style="
                                    display: flex;
                                    flex-direction: column;
                                    align-items: center;
                                    justify-content: center;
                                    padding: 5px 0;
                                    color: <?php echo $settings['bottom_menu_item_color'] ?? '#777777'; ?>;
                                    position: relative;
                                    width: 25%;
                                ">
                                    <i class="fas fa-info-circle" style="font-size: 1.3rem; margin-bottom: 4px;"></i>
                                    <span style="font-size: 0.7rem; font-weight: 500;">Bilgi</span>
                                </div>
                                
                                <div style="
                                    display: flex;
                                    flex-direction: column;
                                    align-items: center;
                                    justify-content: center;
                                    padding: 5px 0;
                                    color: <?php echo $settings['bottom_menu_item_color'] ?? '#777777'; ?>;
                                    position: relative;
                                    width: 25%;
                                ">
                                    <i class="fas fa-search" style="font-size: 1.3rem; margin-bottom: 4px;"></i>
                                    <span style="font-size: 0.7rem; font-weight: 500;">Ara</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="mb-0">İletişim Bilgileri</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label for="contact_header_bg_color" class="form-label">Başlık Arka Plan Rengi</label>
                                    <input type="color" class="form-control form-control-color w-100" id="contact_header_bg_color" name="contact_header_bg_color" value="<?php echo $settings['contact_header_bg_color'] ?? '#3490dc'; ?>">
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="contact_header_text_color" class="form-label">Başlık Metin Rengi</label>
                                    <input type="color" class="form-control form-control-color w-100" id="contact_header_text_color" name="contact_header_text_color" value="<?php echo $settings['contact_header_text_color'] ?? '#ffffff'; ?>">
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="contact_bg_color" class="form-label">Arka Plan Rengi</label>
                                    <input type="color" class="form-control form-control-color w-100" id="contact_bg_color" name="contact_bg_color" value="<?php echo $settings['contact_bg_color'] ?? '#ffffff'; ?>">
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="contact_text_color" class="form-label">Metin Rengi</label>
                                    <input type="color" class="form-control form-control-color w-100" id="contact_text_color" name="contact_text_color" value="<?php echo $settings['contact_text_color'] ?? '#333333'; ?>">
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="contact-preview" style="
                                max-width: 300px;
                                margin: 0 auto;
                                border-radius: 10px;
                                overflow: hidden;
                                box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
                            ">
                                <div style="
                                    background-color: <?php echo $settings['contact_header_bg_color'] ?? '#3490dc'; ?>;
                                    color: <?php echo $settings['contact_header_text_color'] ?? '#ffffff'; ?>;
                                    padding: 15px;
                                    display: flex;
                                    justify-content: space-between;
                                    align-items: center;
                                ">
                                    <h5 style="margin: 0; font-size: 1.2rem; color: <?php echo $settings['contact_header_text_color'] ?? '#ffffff'; ?>;">İletişim</h5>
                                    <button type="button" style="
                                        background-color: transparent;
                                        color: <?php echo $settings['contact_header_text_color'] ?? '#ffffff'; ?>;
                                        border: none;
                                        font-size: 1.5rem;
                                        width: 30px;
                                        height: 30px;
                                        display: flex;
                                        align-items: center;
                                        justify-content: center;
                                        opacity: 1;
                                    ">×</button>
                                </div>
                                <div style="
                                    padding: 15px;
                                    background-color: <?php echo $settings['contact_bg_color'] ?? '#ffffff'; ?>;
                                    color: <?php echo $settings['contact_text_color'] ?? '#333333'; ?>;
                                ">
                                    <div style="margin-bottom: 15px;">
                                        <h6 style="font-size: 1rem; margin-bottom: 10px; color: <?php echo $settings['contact_text_color'] ?? '#333333'; ?>;">
                                            <i class="fas fa-address-book" style="margin-right: 8px; color: <?php echo $settings['primary_color'] ?? '#3490dc'; ?>;"></i> İletişim
                                        </h6>
                                        <div style="font-size: 0.9rem; line-height: 1.5;">
                                            Adres: Örnek Mahallesi, Örnek Caddesi No:1231<br>
                                            Telefon: +90 555 123 45 671<br>
                                            E-posta: info@example.com
                                        </div>
                                    </div>
                                    <div style="margin-bottom: 15px;">
                                        <h6 style="font-size: 1rem; margin-bottom: 10px; color: <?php echo $settings['contact_text_color'] ?? '#333333'; ?>;">
                                            <i class="fas fa-wifi" style="margin-right: 8px; color: <?php echo $settings['primary_color'] ?? '#3490dc'; ?>;"></i> WiFi
                                        </h6>
                                        <div style="font-size: 0.9rem; line-height: 1.5;">
                                            WiFi Adı: Restaurant WiFi<br>
                                            WiFi Şifresi: Cafe12345
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Gizli alanlar - Diğer renk değerleri için -->
            <input type="hidden" name="light_gray" value="<?php echo $settings['light_gray'] ?? '#f8f9fa'; ?>">
            <input type="hidden" name="dark_gray" value="<?php echo $settings['dark_gray'] ?? '#343a40'; ?>">
            <input type="hidden" name="danger_color" value="<?php echo $settings['danger_color'] ?? '#e3342f'; ?>">
            <input type="hidden" name="warning_color" value="<?php echo $settings['warning_color'] ?? '#ffed4a'; ?>">
            <input type="hidden" name="info_color" value="<?php echo $settings['info_color'] ?? '#6cb2eb'; ?>">
            <input type="hidden" name="success_color" value="<?php echo $settings['success_color'] ?? '#51d88a'; ?>">
            <input type="hidden" name="category_card_bg" value="<?php echo $settings['category_card_bg'] ?? '#f8f8f8'; ?>">
            <input type="hidden" name="category_card_text" value="<?php echo $settings['category_card_text'] ?? '#ffffff'; ?>">
            <input type="hidden" name="category_card_gradient_start" value="<?php echo $settings['category_card_gradient_start'] ?? 'rgba(0, 0, 0, 0.7)'; ?>">
            <input type="hidden" name="category_color_1" value="<?php echo $settings['category_color_1'] ?? '#F8D7A8'; ?>">
            <input type="hidden" name="category_color_2" value="<?php echo $settings['category_color_2'] ?? '#F8C8A8'; ?>">
            <input type="hidden" name="category_color_3" value="<?php echo $settings['category_color_3'] ?? '#A8F8D7'; ?>">
            <input type="hidden" name="category_color_4" value="<?php echo $settings['category_color_4'] ?? '#A8C8F8'; ?>">
            <input type="hidden" name="category_color_5" value="<?php echo $settings['category_color_5'] ?? '#D7A8F8'; ?>">
            <input type="hidden" name="menu_item_border_color" value="<?php echo $settings['menu_item_border_color'] ?? '#f0f0f0'; ?>">
            <input type="hidden" name="menu_item_price_bg" value="<?php echo $settings['menu_item_price_bg'] ?? 'rgba(52, 144, 220, 0.1)'; ?>">
            <input type="hidden" name="button_primary_hover_bg" value="<?php echo $settings['button_primary_hover_bg'] ?? '#2779bd'; ?>">
            <input type="hidden" name="button_primary_hover_border" value="<?php echo $settings['button_primary_hover_border'] ?? '#2779bd'; ?>">
            <input type="hidden" name="button_success_hover_bg" value="<?php echo $settings['button_success_hover_bg'] ?? '#2d995b'; ?>">
            <input type="hidden" name="button_success_hover_border" value="<?php echo $settings['button_success_hover_border'] ?? '#2d995b'; ?>">
            <input type="hidden" name="overlay_bg_color" value="<?php echo $settings['overlay_bg_color'] ?? 'rgba(0, 0, 0, 0.7)'; ?>">
            <input type="hidden" name="overlay_content_bg" value="<?php echo $settings['overlay_content_bg'] ?? 'white'; ?>">
            <input type="hidden" name="overlay_content_shadow" value="<?php echo $settings['overlay_content_shadow'] ?? 'rgba(0, 0, 0, 0.2)'; ?>">
            <input type="hidden" name="social_link_bg" value="<?php echo $settings['social_link_bg'] ?? '#f5f5f5'; ?>">
            <input type="hidden" name="social_link_hover_bg" value="<?php echo $settings['social_link_hover_bg'] ?? '#3490dc'; ?>">
            <input type="hidden" name="social_link_hover_text" value="<?php echo $settings['social_link_hover_text'] ?? 'white'; ?>">
            
            <div class="alert alert-info">
                <i class="fas fa-info-circle"></i> Renk değişiklikleri, sayfayı yeniledikten sonra görünür olacaktır.
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Renk değişikliklerini önizleme için dinleyiciler
    const colorInputs = document.querySelectorAll('#appearance input[type="color"]');
    colorInputs.forEach(input => {
        input.addEventListener('input', updatePreviews);
    });
    
    function updatePreviews() {
        // Ana tema önizlemesi
        const primaryColor = document.getElementById('primary_color').value;
        const secondaryColor = document.getElementById('secondary_color').value;
        const textColor = document.getElementById('text_color').value;
        const backgroundColor = document.getElementById('background_color').value;
        
        const themePreview = document.querySelector('.theme-preview');
        themePreview.style.backgroundColor = backgroundColor;
        themePreview.style.color = textColor;
        
        themePreview.querySelector('h4').style.color = textColor;
        
        const buttons = themePreview.querySelectorAll('.btn');
        buttons[0].style.backgroundColor = primaryColor;
        buttons[0].style.borderColor = primaryColor;
        buttons[1].style.backgroundColor = secondaryColor;
        buttons[1].style.borderColor = secondaryColor;
        
        themePreview.querySelector('a').style.color = primaryColor;
        
        // Başlık önizlemesi
        const headerBgColor = document.getElementById('header_bg_color').value;
        const headerTextColor = document.getElementById('header_text_color').value;
        
        const headerPreview = document.querySelector('.header-preview');
        headerPreview.style.backgroundColor = headerBgColor;
        headerPreview.style.color = headerTextColor;
        headerPreview.querySelector('h5').style.color = headerTextColor;
        headerPreview.querySelector('button').style.color = headerTextColor;
        
        // Menü öğesi önizlemesi
        const menuItemBgColor = document.getElementById('menu_item_bg_color').value;
        const menuItemTitleColor = document.getElementById('menu_item_title_color').value;
        const menuItemDescColor = document.getElementById('menu_item_desc_color').value;
        const menuItemPriceColor = document.getElementById('menu_item_price_color').value;
        
        const menuItemPreview = document.querySelector('.menu-item-preview');
        menuItemPreview.style.backgroundColor = menuItemBgColor;
        menuItemPreview.querySelector('h3').style.color = menuItemTitleColor;
        menuItemPreview.querySelector('p').style.color = menuItemDescColor;
        menuItemPreview.querySelector('div > div > div').style.color = menuItemPriceColor;
        
        // Alt menü önizlemesi
        const bottomMenuColor = document.getElementById('bottom_menu_color').value;
        const bottomMenuItemColor = document.getElementById('bottom_menu_item_color').value;
        
        const bottomMenuPreview = document.querySelector('.bottom-menu-preview');
        bottomMenuPreview.style.backgroundColor = bottomMenuColor;
        
        const bottomMenuItems = bottomMenuPreview.querySelectorAll('div');
        bottomMenuItems[0].style.color = primaryColor;
        bottomMenuItems[1].style.color = bottomMenuItemColor;
        bottomMenuItems[2].style.color = bottomMenuItemColor;
        bottomMenuItems[3].style.color = bottomMenuItemColor;
        
        // İletişim bilgileri önizlemesi
        const contactHeaderBgColor = document.getElementById('contact_header_bg_color').value;
        const contactHeaderTextColor = document.getElementById('contact_header_text_color').value;
        const contactBgColor = document.getElementById('contact_bg_color').value;
        const contactTextColor = document.getElementById('contact_text_color').value;
        
        const contactPreview = document.querySelector('.contact-preview');
        const contactHeader = contactPreview.querySelector('div:first-child');
        const contactBody = contactPreview.querySelector('div:nth-child(2)');
        
        contactHeader.style.backgroundColor = contactHeaderBgColor;
        contactHeader.style.color = contactHeaderTextColor;
        contactHeader.querySelector('h5').style.color = contactHeaderTextColor;
        contactHeader.querySelector('button').style.color = contactHeaderTextColor;
        
        contactBody.style.backgroundColor = contactBgColor;
        contactBody.style.color = contactTextColor;
        contactBody.querySelectorAll('h6').forEach(h6 => {
            h6.style.color = contactTextColor;
        });
        
        // İkon renklerini ana renge ayarla
        contactBody.querySelectorAll('i.fas').forEach(icon => {
            icon.style.color = primaryColor;
        });
        
        // Ayarları form verisi olarak sakla
        document.querySelector('input[name="contact_header_bg_color"]').value = contactHeaderBgColor;
        document.querySelector('input[name="contact_header_text_color"]').value = contactHeaderTextColor;
        document.querySelector('input[name="contact_bg_color"]').value = contactBgColor;
        document.querySelector('input[name="contact_text_color"]').value = contactTextColor;
    }
});
</script>
