<!-- Para Birimi Ayarları -->
<div class="tab-pane fade" id="currency" role="tabpanel" aria-labelledby="currency-tab">
    <div class="row">
        <div class="col-md-6">
            <div class="mb-3">
                <label for="currency_symbol" class="form-label"><?php echo __('admin.currency_symbol', [], $adminLanguage); ?></label>
                <input type="text" class="form-control" id="currency_symbol" name="currency_symbol" value="<?php echo $settings['currency_symbol'] ?? '₺'; ?>">
                <small class="text-muted">Örnek: ₺, $, €, £</small>
            </div>
        </div>
        
        <div class="col-md-6">
            <div class="mb-3">
                <label for="currency_position" class="form-label"><?php echo __('admin.currency_position', [], $adminLanguage); ?></label>
                <select class="form-select" id="currency_position" name="currency_position">
                    <option value="before" <?php echo (isset($settings['currency_position']) && $settings['currency_position'] === 'before') ? 'selected' : ''; ?>>Önce (₺100)</option>
                    <option value="after" <?php echo (isset($settings['currency_position']) && $settings['currency_position'] === 'after') ? 'selected' : ''; ?>>Sonra (100 ₺)</option>
                </select>
            </div>
        </div>
    </div>
    
    <div class="mt-3">
        <div class="card">
            <div class="card-header"><?php echo __('admin.preview', [], $adminLanguage); ?></div>
            <div class="card-body">
                <div class="preview-price">
                    <h5>Fiyat Örneği:</h5>
                    <p class="h4" id="price-preview">
                        <?php
                        $symbol = $settings['currency_symbol'] ?? '₺';
                        $position = $settings['currency_position'] ?? 'after';
                        
                        if ($position === 'before') {
                            echo $symbol . '100,00';
                        } else {
                            echo '100,00 ' . $symbol;
                        }
                        ?>
                    </p>
                </div>
            </div>
        </div>
    </div>
</div>
