<!-- Genel Ayarlar -->
<div class="tab-pane fade show active" id="general" role="tabpanel" aria-labelledby="general-tab">
    <div class="row">
        <div class="col-md-6">
            <div class="mb-3">
                <label for="site_title" class="form-label"><?php echo __('admin.site_title', [], $adminLanguage); ?></label>
                <input type="text" class="form-control" id="site_title" name="site_title" value="<?php echo $settings['site_title'] ?? 'Dijital Menü'; ?>">
            </div>
            
            <div class="mb-3">
                <label for="site_url" class="form-label">Site URL</label>
                <input type="text" class="form-control" id="site_url" name="site_url" value="<?php echo $settings['site_url'] ?? 'http://localhost/digital-menu'; ?>">
                <small class="text-muted">QR kodlar ve bağlantılar için kullanılacak tam site adresi. Örnek: https://menu.restoraniniz.com</small>
            </div>
            
            <div class="mb-3">
                <label for="site_description" class="form-label"><?php echo __('admin.site_description', [], $adminLanguage); ?></label>
                <textarea class="form-control" id="site_description" name="site_description" rows="3"><?php echo $settings['site_description'] ?? 'Restoran Dijital Menü Sistemi'; ?></textarea>
                <small class="text-muted">Site açıklaması, SEO için önemlidir.</small>
            </div>
            
            <div class="mb-3">
                <label for="logo" class="form-label"><?php echo __('admin.logo', [], $adminLanguage); ?></label>
                <?php if (isset($settings['logo']) && !empty($settings['logo'])): ?>
                <div class="mb-2">
                    <img src="../assets/img/<?php echo $settings['logo']; ?>" alt="Logo" class="img-fluid" style="max-height: 50px;">
                </div>
                <?php endif; ?>
                <input type="file" class="form-control" id="logo" name="logo" accept="image/*">
                <small class="text-muted">Önerilen boyut: 200x50 piksel</small>
            </div>
            
            <div class="mb-3">
                <label for="favicon" class="form-label"><?php echo __('admin.favicon', [], $adminLanguage); ?></label>
                <?php if (isset($settings['favicon']) && !empty($settings['favicon'])): ?>
                <div class="mb-2">
                    <img src="../assets/img/<?php echo $settings['favicon']; ?>" alt="Favicon" width="32" height="32">
                </div>
                <?php endif; ?>
                <input type="file" class="form-control" id="favicon" name="favicon" accept="image/*">
                <small class="text-muted">Önerilen boyut: 32x32 piksel</small>
            </div>
        </div>
        
        <div class="col-md-6">
            <div class="mb-3">
                <label for="footer_text" class="form-label"><?php echo __('admin.footer_text', [], $adminLanguage); ?></label>
                <textarea class="form-control" id="footer_text" name="footer_text" rows="3"><?php echo $settings['footer_text'] ?? '© 2025 Dijital Menü. Tüm hakları saklıdır.'; ?></textarea>
            </div>
            
            <div class="mb-3">
                <label for="default_language" class="form-label"><?php echo __('admin.default_language', [], $adminLanguage); ?></label>
                <select class="form-select" id="default_language" name="default_language">
                    <?php foreach ($languages as $code => $language): ?>
                    <option value="<?php echo $code; ?>" <?php echo (isset($settings['default_language']) && $settings['default_language'] === $code) ? 'selected' : ''; ?>>
                        <?php echo $language['name']; ?>
                    </option>
                    <?php endforeach; ?>
                </select>
                <small class="text-muted">Menü ve site ön yüzünde kullanılacak varsayılan dil</small>
            </div>
            
            <div class="mb-3">
                <label for="admin_language" class="form-label"><?php echo __('admin.admin_language', [], $adminLanguage); ?></label>
                <select class="form-select" id="admin_language" name="admin_language">
                    <?php foreach ($languages as $code => $language): ?>
                    <option value="<?php echo $code; ?>" <?php echo ($adminLanguage === $code) ? 'selected' : ''; ?>>
                        <?php echo $language['name']; ?>
                    </option>
                    <?php endforeach; ?>
                </select>
                <small class="text-muted">Admin panelinde kullanılacak dil</small>
            </div>
        </div>
    </div>
</div>
