<!-- Happy Hour Sekmesi -->
<div class="tab-pane fade" id="happy-hour" role="tabpanel" aria-labelledby="happy-hour-tab">
    <div class="row">
        <div class="col-md-6">
            <div class="card mb-3">
                <div class="card-header">Happy Hour Ayarları</div>
                <div class="card-body">
                    <div class="mb-3 form-check">
                        <input type="checkbox" class="form-check-input" id="happy_hour_enabled" name="happy_hour_enabled" <?php echo (isset($settings['happy_hour_enabled']) && $settings['happy_hour_enabled'] == 1) ? 'checked' : ''; ?>>
                        <label class="form-check-label" for="happy_hour_enabled">Happy Hour Etkinleştir</label>
                    </div>
                    
                    <div class="mb-3">
                        <label for="happy_hour_start_time" class="form-label">Başlangıç Saati</label>
                        <input type="time" class="form-control" id="happy_hour_start_time" name="happy_hour_start_time" value="<?php echo $settings['happy_hour_start_time'] ?? '17:00'; ?>">
                    </div>
                    
                    <div class="mb-3">
                        <label for="happy_hour_end_time" class="form-label">Bitiş Saati</label>
                        <input type="time" class="form-control" id="happy_hour_end_time" name="happy_hour_end_time" value="<?php echo $settings['happy_hour_end_time'] ?? '19:00'; ?>">
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Aktif Günler</label>
                        <div class="d-flex flex-wrap">
                            <?php
                            $days = [
                                1 => 'Pazartesi',
                                2 => 'Salı',
                                3 => 'Çarşamba',
                                4 => 'Perşembe',
                                5 => 'Cuma',
                                6 => 'Cumartesi',
                                0 => 'Pazar'
                            ];
                            
                            $activeDays = isset($settings['happy_hour_days']) ? json_decode($settings['happy_hour_days'], true) : [1, 2, 3, 4, 5];
                            
                            foreach ($days as $dayNum => $dayName):
                            ?>
                            <div class="form-check me-3 mb-2">
                                <input class="form-check-input happy-hour-day" type="checkbox" id="day_<?php echo $dayNum; ?>" value="<?php echo $dayNum; ?>" <?php echo in_array($dayNum, $activeDays) ? 'checked' : ''; ?>>
                                <label class="form-check-label" for="day_<?php echo $dayNum; ?>">
                                    <?php echo $dayName; ?>
                                </label>
                            </div>
                            <?php endforeach; ?>
                            <input type="hidden" name="happy_hour_days" id="happy_hour_days_input" value="<?php echo $settings['happy_hour_days'] ?? '[1,2,3,4,5]'; ?>">
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-md-6">
            <div class="card mb-3">
                <div class="card-header">Mesaj Ayarları</div>
                <div class="card-body">
                    <div class="mb-3">
                        <label for="happy_hour_title" class="form-label">Başlık</label>
                        <input type="text" class="form-control" id="happy_hour_title" name="happy_hour_title" value="<?php echo $settings['happy_hour_title'] ?? 'Happy Hour!'; ?>">
                    </div>
                    
                    <div class="mb-3">
                        <label for="happy_hour_message" class="form-label">Mesaj</label>
                        <textarea class="form-control" id="happy_hour_message" name="happy_hour_message" rows="3"><?php echo $settings['happy_hour_message'] ?? 'Tüm içeceklerde %20 indirim!'; ?></textarea>
                    </div>
                    
                    <div class="mb-3">
                        <label for="happy_hour_bg_color" class="form-label">Arka Plan Rengi</label>
                        <div class="input-group">
                            <input type="color" class="form-control form-control-color" id="happy_hour_bg_color" name="happy_hour_bg_color" value="<?php echo $settings['happy_hour_bg_color'] ?? '#FF9800'; ?>">
                            <input type="text" class="form-control" value="<?php echo $settings['happy_hour_bg_color'] ?? '#FF9800'; ?>" id="happy_hour_bg_color_text" readonly>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label for="happy_hour_text_color" class="form-label">Metin Rengi</label>
                        <div class="input-group">
                            <input type="color" class="form-control form-control-color" id="happy_hour_text_color" name="happy_hour_text_color" value="<?php echo $settings['happy_hour_text_color'] ?? '#FFFFFF'; ?>">
                            <input type="text" class="form-control" value="<?php echo $settings['happy_hour_text_color'] ?? '#FFFFFF'; ?>" id="happy_hour_text_color_text" readonly>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Önizleme</label>
                        <div class="happy-hour-preview p-3 rounded" id="happy-hour-preview">
                            <h4 id="preview-title"><?php echo $settings['happy_hour_title'] ?? 'Happy Hour!'; ?></h4>
                            <p id="preview-message"><?php echo $settings['happy_hour_message'] ?? 'Tüm içeceklerde %20 indirim!'; ?></p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Renk değişikliklerini izle
    document.getElementById('happy_hour_bg_color').addEventListener('input', updatePreview);
    document.getElementById('happy_hour_text_color').addEventListener('input', updatePreview);
    document.getElementById('happy_hour_title').addEventListener('input', updatePreview);
    document.getElementById('happy_hour_message').addEventListener('input', updatePreview);
    
    // Renk inputlarını senkronize et
    document.getElementById('happy_hour_bg_color').addEventListener('input', function() {
        document.getElementById('happy_hour_bg_color_text').value = this.value;
    });
    
    document.getElementById('happy_hour_text_color').addEventListener('input', function() {
        document.getElementById('happy_hour_text_color_text').value = this.value;
    });
    
    // Aktif günleri güncelle
    const dayCheckboxes = document.querySelectorAll('.happy-hour-day');
    dayCheckboxes.forEach(checkbox => {
        checkbox.addEventListener('change', updateActiveDays);
    });
    
    // İlk yükleme için önizlemeyi güncelle
    updatePreview();
    
    function updatePreview() {
        const preview = document.getElementById('happy-hour-preview');
        const title = document.getElementById('preview-title');
        const message = document.getElementById('preview-message');
        
        const bgColor = document.getElementById('happy_hour_bg_color').value;
        const textColor = document.getElementById('happy_hour_text_color').value;
        const titleText = document.getElementById('happy_hour_title').value;
        const messageText = document.getElementById('happy_hour_message').value;
        
        preview.style.backgroundColor = bgColor;
        preview.style.color = textColor;
        title.textContent = titleText;
        message.textContent = messageText;
    }
    
    function updateActiveDays() {
        const dayCheckboxes = document.querySelectorAll('.happy-hour-day');
        const activeDays = [];
        
        dayCheckboxes.forEach(checkbox => {
            if (checkbox.checked) {
                activeDays.push(parseInt(checkbox.value));
            }
        });
        
        document.getElementById('happy_hour_days_input').value = JSON.stringify(activeDays);
    }
});
</script>

<style>
.happy-hour-preview {
    background-color: <?php echo $settings['happy_hour_bg_color'] ?? '#FF9800'; ?>;
    color: <?php echo $settings['happy_hour_text_color'] ?? '#FFFFFF'; ?>;
    min-height: 100px;
    text-align: center;
    display: flex;
    flex-direction: column;
    justify-content: center;
    box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
}

.happy-hour-preview h4 {
    margin-bottom: 10px;
    font-weight: bold;
}

.happy-hour-preview p {
    margin-bottom: 0;
}
</style>
