<!-- Sidebar Ayarları -->
<div class="tab-pane fade" id="sidebar" role="tabpanel" aria-labelledby="sidebar-tab">
    <div class="row">
        <div class="col-md-6">
            <div class="mb-3">
                <label for="contact_info" class="form-label"><?php echo __('admin.contact_info', [], $adminLanguage); ?></label>
                <textarea class="form-control" id="contact_info" name="contact_info" rows="5"><?php echo $settings['contact_info'] ?? ''; ?></textarea>
                <small class="text-muted"><?php echo __('admin.contact_info_help', [], $adminLanguage); ?></small>
            </div>
            
            <div class="mb-3">
                <label for="wifi_name" class="form-label"><?php echo __('site.wifi_name', [], $adminLanguage); ?></label>
                <input type="text" class="form-control" id="wifi_name" name="wifi_name" value="<?php echo $settings['wifi_name'] ?? 'Restaurant WiFi'; ?>">
            </div>
            
            <div class="mb-3">
                <label for="wifi_password" class="form-label"><?php echo __('site.wifi_password', [], $adminLanguage); ?></label>
                <input type="text" class="form-control" id="wifi_password" name="wifi_password" value="<?php echo $settings['wifi_password'] ?? ''; ?>">
                <small class="text-muted"><?php echo __('admin.wifi_password_help', [], $adminLanguage); ?></small>
            </div>
            
            <div class="mb-3">
                <label for="google_maps_review_link" class="form-label"><?php echo __('admin.google_maps_review_link', [], $adminLanguage); ?></label>
                <input type="text" class="form-control" id="google_maps_review_link" name="google_maps_review_link" value="<?php echo $settings['google_maps_review_link'] ?? ''; ?>">
                <small class="text-muted"><?php echo __('admin.google_maps_review_help', [], $adminLanguage); ?></small>
                <div class="mt-1">
                    <a href="https://embedsocial.com/tools/google-review-link-generator/" target="_blank" class="text-primary">
                        <i class="fas fa-external-link-alt"></i> Bu linkten firma adınızı girerek link oluşturabilirsiniz
                    </a>
                </div>
            </div>
        </div>
        
        <div class="col-md-6">
            <div class="mb-3">
                <label class="form-label"><?php echo __('site.social_media', [], $adminLanguage); ?></label>
                
                <div class="mb-2">
                    <label for="social_facebook" class="form-label">Facebook</label>
                    <div class="input-group">
                        <span class="input-group-text"><i class="fab fa-facebook"></i></span>
                        <input type="text" class="form-control" id="social_facebook" name="social_facebook" value="<?php 
                            $socialMedia = isset($settings['social_media']) ? json_decode($settings['social_media'], true) : [];
                            echo isset($socialMedia['facebook']) ? $socialMedia['facebook'] : '';
                        ?>">
                    </div>
                </div>
                
                <div class="mb-2">
                    <label for="social_instagram" class="form-label">Instagram</label>
                    <div class="input-group">
                        <span class="input-group-text"><i class="fab fa-instagram"></i></span>
                        <input type="text" class="form-control" id="social_instagram" name="social_instagram" value="<?php 
                            echo isset($socialMedia['instagram']) ? $socialMedia['instagram'] : '';
                        ?>">
                    </div>
                </div>
                
                <div class="mb-2">
                    <label for="social_twitter" class="form-label">Twitter</label>
                    <div class="input-group">
                        <span class="input-group-text"><i class="fab fa-twitter"></i></span>
                        <input type="text" class="form-control" id="social_twitter" name="social_twitter" value="<?php 
                            echo isset($socialMedia['twitter']) ? $socialMedia['twitter'] : '';
                        ?>">
                    </div>
                </div>
                
                <div class="mb-2">
                    <label for="social_youtube" class="form-label">YouTube</label>
                    <div class="input-group">
                        <span class="input-group-text"><i class="fab fa-youtube"></i></span>
                        <input type="text" class="form-control" id="social_youtube" name="social_youtube" value="<?php 
                            echo isset($socialMedia['youtube']) ? $socialMedia['youtube'] : '';
                        ?>">
                    </div>
                </div>
                
                <small class="text-muted"><?php echo __('admin.social_media_help', [], $adminLanguage); ?></small>
            </div>
        </div>
    </div>
</div>
