<?php
/**
 * Dijital Menü - Slider Yönetimi
 */

// İstanbul saatini ayarla
date_default_timezone_set('Europe/Istanbul');

// Gerekli dosyaları dahil et
require_once '../includes/auth.php';
require_once '../includes/language.php';
require_once '../includes/slider_functions.php';

// Admin paneli dilini al
$adminLanguage = getAdminLanguage();

// Giriş yapılmamışsa yönlendir
redirectIfNotLoggedIn('login.php');

// Admin yetkisi kontrolü
requirePermission('admin', 'login.php');

// Sayfa başlığı
$pageTitle = 'Slider Yönetimi';

// Ayarları al
$settings = getSetting();

// Sayfalama
$page = isset($_GET['page']) ? intval($_GET['page']) : 1;
$limit = 10;
$offset = ($page - 1) * $limit;

// Sliderları al
$sliders = getSliders(false);
$totalCount = getSliderCount();
$totalPages = ceil($totalCount / $limit);

// Slider ekleme işlemi
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['add_slider'])) {
    $title = isset($_POST['title']) ? clean($_POST['title']) : '';
    $description = isset($_POST['description']) ? clean($_POST['description']) : '';
    $link = isset($_POST['link']) ? clean($_POST['link']) : '';
    $sortOrder = isset($_POST['sort_order']) ? intval($_POST['sort_order']) : 0;
    $status = isset($_POST['status']) ? intval($_POST['status']) : 1;
    
    // Resim yükleme
    $image = '';
    if (isset($_FILES['image']) && $_FILES['image']['error'] == 0) {
        $image = uploadFile($_FILES['image'], '../assets/uploads', ['jpg', 'jpeg', 'png', 'gif']);
        
        if (!$image) {
            $_SESSION['error_message'] = 'Resim yüklenirken bir hata oluştu.';
        }
    }
    
    if (empty($image)) {
        $_SESSION['error_message'] = 'Lütfen bir resim seçin.';
    } else {
        $data = [
            'title' => $title,
            'description' => $description,
            'image' => $image,
            'link' => $link,
            'sort_order' => $sortOrder,
            'status' => $status
        ];
        
        if (addSlider($data)) {
            $_SESSION['success_message'] = 'Slider başarıyla eklendi.';
            header('Location: sliders.php');
            exit;
        } else {
            $_SESSION['error_message'] = 'Slider eklenirken bir hata oluştu.';
        }
    }
}

// Slider güncelleme işlemi
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['update_slider'])) {
    $sliderId = intval($_POST['slider_id']);
    $title = isset($_POST['title']) ? clean($_POST['title']) : '';
    $description = isset($_POST['description']) ? clean($_POST['description']) : '';
    $link = isset($_POST['link']) ? clean($_POST['link']) : '';
    $sortOrder = isset($_POST['sort_order']) ? intval($_POST['sort_order']) : 0;
    $status = isset($_POST['status']) ? intval($_POST['status']) : 1;
    
    // Mevcut slider'ı al
    $slider = getSlider($sliderId);
    
    if (!$slider) {
        $_SESSION['error_message'] = 'Slider bulunamadı.';
    } else {
        // Resim yükleme
        $image = '';
        if (isset($_FILES['image']) && $_FILES['image']['error'] == 0) {
            $image = uploadFile($_FILES['image'], '../assets/uploads', ['jpg', 'jpeg', 'png', 'gif']);
            
            if (!$image) {
                $_SESSION['error_message'] = 'Resim yüklenirken bir hata oluştu.';
            }
            
            // Eski resmi sil
            if (!empty($slider['image'])) {
                $oldImagePath = '../assets/uploads/' . $slider['image'];
                if (file_exists($oldImagePath)) {
                    unlink($oldImagePath);
                }
            }
        }
        
        $data = [
            'title' => $title,
            'description' => $description,
            'link' => $link,
            'sort_order' => $sortOrder,
            'status' => $status
        ];
        
        // Yeni resim varsa ekle
        if (!empty($image)) {
            $data['image'] = $image;
        }
        
        if (updateSlider($sliderId, $data)) {
            $_SESSION['success_message'] = 'Slider başarıyla güncellendi.';
            header('Location: sliders.php');
            exit;
        } else {
            $_SESSION['error_message'] = 'Slider güncellenirken bir hata oluştu.';
        }
    }
}

// Slider silme işlemi
if (isset($_GET['delete'])) {
    $sliderId = intval($_GET['delete']);
    
    if (deleteSlider($sliderId)) {
        $_SESSION['success_message'] = 'Slider başarıyla silindi.';
    } else {
        $_SESSION['error_message'] = 'Slider silinirken bir hata oluştu.';
    }
    
    header('Location: sliders.php');
    exit;
}

// Slider durumunu güncelleme
if (isset($_GET['status']) && isset($_GET['id'])) {
    $sliderId = intval($_GET['id']);
    $status = intval($_GET['status']);
    
    if (updateSliderStatus($sliderId, $status)) {
        $_SESSION['success_message'] = 'Slider durumu başarıyla güncellendi.';
    } else {
        $_SESSION['error_message'] = 'Slider durumu güncellenirken bir hata oluştu.';
    }
    
    header('Location: sliders.php');
    exit;
}

// Aktif kullanıcı bilgilerini al
$user = getUser($_SESSION['user_id']);
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $pageTitle; ?> | <?php echo $settings['site_title'] ?? 'Dijital Menü'; ?></title>
    
    <!-- Favicon -->
    <?php if (!empty($settings['favicon'])): ?>
    <link rel="shortcut icon" href="../assets/img/<?php echo $settings['favicon']; ?>" type="image/x-icon">
    <?php endif; ?>
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    
    <!-- Ana CSS -->
    <link href="../assets/css/style.css" rel="stylesheet">
    
    <!-- Özel Renkler -->
    <style>
        :root {
            --primary-color: <?php echo $settings['primary_color'] ?? '#3490dc'; ?>;
            --secondary-color: <?php echo $settings['secondary_color'] ?? '#38c172'; ?>;
            --text-color: <?php echo $settings['text_color'] ?? '#333333'; ?>;
            --background-color: <?php echo $settings['background_color'] ?? '#ffffff'; ?>;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <?php include 'includes/sidebar.php'; ?>
            
            <!-- Ana İçerik -->
            <div class="col-md-9 col-lg-10 admin-content">
                <!-- Üst Başlık -->
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h1 class="h3"><?php echo $pageTitle; ?></h1>
                    <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addSliderModal">
                        <i class="fas fa-plus"></i> Slider Ekle
                    </button>
                </div>
                
                <!-- Oturum Mesajı -->
                <?php if (isset($_SESSION['error_message'])): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <?php echo $_SESSION['error_message']; ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
                <?php unset($_SESSION['error_message']); ?>
                <?php endif; ?>
                
                <?php if (isset($_SESSION['success_message'])): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <?php echo $_SESSION['success_message']; ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
                <?php unset($_SESSION['success_message']); ?>
                <?php endif; ?>
                
                <!-- İçerik -->
                <div class="admin-card">
                    <div class="d-flex justify-content-between align-items-center mb-4">
                        <h5>Sliderlar</h5>
                        <p class="text-muted">Toplam: <?php echo $totalCount; ?> slider</p>
                    </div>
                    
                    <?php if (empty($sliders)): ?>
                    <div class="alert alert-info">
                        Henüz slider bulunmamaktadır.
                    </div>
                    <?php else: ?>
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Resim</th>
                                    <th>Başlık</th>
                                    <th>Açıklama</th>
                                    <th>Sıralama</th>
                                    <th>Durum</th>
                                    <th>İşlemler</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($sliders as $slider): ?>
                                <tr>
                                    <td><?php echo $slider['id']; ?></td>
                                    <td>
                                        <?php if (!empty($slider['image'])): ?>
                                        <img src="../assets/uploads/<?php echo $slider['image']; ?>" alt="<?php echo $slider['title']; ?>" class="img-thumbnail" style="max-width: 100px;">
                                        <?php else: ?>
                                        <span class="badge bg-secondary">Resim Yok</span>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo htmlspecialchars($slider['title']); ?></td>
                                    <td>
                                        <?php 
                                        // Açıklamayı kısalt
                                        $description = htmlspecialchars($slider['description']);
                                        echo strlen($description) > 50 ? substr($description, 0, 50) . '...' : $description;
                                        ?>
                                    </td>
                                    <td><?php echo $slider['sort_order']; ?></td>
                                    <td>
                                        <?php if ($slider['status'] == 1): ?>
                                        <span class="badge bg-success">Aktif</span>
                                        <?php else: ?>
                                        <span class="badge bg-danger">Pasif</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <div class="btn-group">
                                            <a href="?status=<?php echo $slider['status'] == 1 ? '0' : '1'; ?>&id=<?php echo $slider['id']; ?>" class="btn btn-sm <?php echo $slider['status'] == 1 ? 'btn-danger' : 'btn-success'; ?>" title="<?php echo $slider['status'] == 1 ? 'Pasif Yap' : 'Aktif Yap'; ?>">
                                                <i class="fas <?php echo $slider['status'] == 1 ? 'fa-times' : 'fa-check'; ?>"></i>
                                            </a>
                                            <button type="button" class="btn btn-sm btn-primary" data-bs-toggle="modal" data-bs-target="#editSliderModal<?php echo $slider['id']; ?>" title="Düzenle">
                                                <i class="fas fa-edit"></i>
                                            </button>
                                            <a href="?delete=<?php echo $slider['id']; ?>" class="btn btn-sm btn-danger" onclick="return confirm('Bu slider\'ı silmek istediğinizden emin misiniz?')" title="Sil">
                                                <i class="fas fa-trash"></i>
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                    
                    <!-- Sayfalama -->
                    <?php if ($totalPages > 1): ?>
                    <nav aria-label="Sayfalama">
                        <ul class="pagination justify-content-center">
                            <li class="page-item <?php echo $page <= 1 ? 'disabled' : ''; ?>">
                                <a class="page-link" href="?page=<?php echo $page - 1; ?>" aria-label="Önceki">
                                    <span aria-hidden="true">&laquo;</span>
                                </a>
                            </li>
                            
                            <?php for ($i = 1; $i <= $totalPages; $i++): ?>
                            <li class="page-item <?php echo $page == $i ? 'active' : ''; ?>">
                                <a class="page-link" href="?page=<?php echo $i; ?>">
                                    <?php echo $i; ?>
                                </a>
                            </li>
                            <?php endfor; ?>
                            
                            <li class="page-item <?php echo $page >= $totalPages ? 'disabled' : ''; ?>">
                                <a class="page-link" href="?page=<?php echo $page + 1; ?>" aria-label="Sonraki">
                                    <span aria-hidden="true">&raquo;</span>
                                </a>
                            </li>
                        </ul>
                    </nav>
                    <?php endif; ?>
                    
                    <!-- Slider Düzenleme Modalları -->
                    <?php foreach ($sliders as $slider): ?>
                    <div class="modal fade" id="editSliderModal<?php echo $slider['id']; ?>" tabindex="-1" aria-labelledby="editSliderModalLabel<?php echo $slider['id']; ?>" aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="editSliderModalLabel<?php echo $slider['id']; ?>">Slider Düzenle</h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Kapat"></button>
                                </div>
                                <form method="post" action="" enctype="multipart/form-data">
                                    <div class="modal-body">
                                        <input type="hidden" name="slider_id" value="<?php echo $slider['id']; ?>">
                                        
                                        <div class="mb-3">
                                            <label for="title<?php echo $slider['id']; ?>" class="form-label">Başlık</label>
                                            <input type="text" class="form-control" id="title<?php echo $slider['id']; ?>" name="title" value="<?php echo htmlspecialchars($slider['title']); ?>">
                                        </div>
                                        
                                        <div class="mb-3">
                                            <label for="description<?php echo $slider['id']; ?>" class="form-label">Açıklama</label>
                                            <textarea class="form-control" id="description<?php echo $slider['id']; ?>" name="description" rows="3"><?php echo htmlspecialchars($slider['description']); ?></textarea>
                                        </div>
                                        
                                        <div class="mb-3">
                                            <label for="image<?php echo $slider['id']; ?>" class="form-label">Resim</label>
                                            <?php if (!empty($slider['image'])): ?>
                                            <div class="mb-2">
                                                <img src="../assets/uploads/<?php echo $slider['image']; ?>" alt="<?php echo $slider['title']; ?>" class="img-thumbnail" style="max-width: 200px;">
                                            </div>
                                            <?php endif; ?>
                                            <input type="file" class="form-control" id="image<?php echo $slider['id']; ?>" name="image">
                                            <small class="text-muted">Yeni bir resim seçmezseniz mevcut resim kullanılacaktır.</small>
                                        </div>
                                        
                                        <div class="mb-3">
                                            <label for="link<?php echo $slider['id']; ?>" class="form-label">Link (İsteğe bağlı)</label>
                                            <input type="text" class="form-control" id="link<?php echo $slider['id']; ?>" name="link" value="<?php echo htmlspecialchars($slider['link']); ?>">
                                        </div>
                                        
                                        <div class="mb-3">
                                            <label for="sort_order<?php echo $slider['id']; ?>" class="form-label">Sıralama</label>
                                            <input type="number" class="form-control" id="sort_order<?php echo $slider['id']; ?>" name="sort_order" value="<?php echo $slider['sort_order']; ?>" min="0">
                                        </div>
                                        
                                        <div class="mb-3">
                                            <label for="status<?php echo $slider['id']; ?>" class="form-label">Durum</label>
                                            <select class="form-select" id="status<?php echo $slider['id']; ?>" name="status">
                                                <option value="1" <?php echo $slider['status'] == 1 ? 'selected' : ''; ?>>Aktif</option>
                                                <option value="0" <?php echo $slider['status'] == 0 ? 'selected' : ''; ?>>Pasif</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                                        <button type="submit" name="update_slider" class="btn btn-primary">Güncelle</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Slider Ekleme Modalı -->
    <div class="modal fade" id="addSliderModal" tabindex="-1" aria-labelledby="addSliderModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="addSliderModalLabel">Yeni Slider Ekle</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Kapat"></button>
                </div>
                <form method="post" action="" enctype="multipart/form-data">
                    <div class="modal-body">
                        <div class="mb-3">
                            <label for="title" class="form-label">Başlık</label>
                            <input type="text" class="form-control" id="title" name="title" required>
                        </div>
                        
                        <div class="mb-3">
                            <label for="description" class="form-label">Açıklama</label>
                            <textarea class="form-control" id="description" name="description" rows="3"></textarea>
                        </div>
                        
                        <div class="mb-3">
                            <label for="image" class="form-label">Resim</label>
                            <input type="file" class="form-control" id="image" name="image" required>
                            <small class="text-muted">Önerilen boyut: 1200x400 piksel</small>
                        </div>
                        
                        <div class="mb-3">
                            <label for="link" class="form-label">Link (İsteğe bağlı)</label>
                            <input type="text" class="form-control" id="link" name="link">
                        </div>
                        
                        <div class="mb-3">
                            <label for="sort_order" class="form-label">Sıralama</label>
                            <input type="number" class="form-control" id="sort_order" name="sort_order" value="0" min="0">
                        </div>
                        
                        <div class="mb-3">
                            <label for="status" class="form-label">Durum</label>
                            <select class="form-select" id="status" name="status">
                                <option value="1">Aktif</option>
                                <option value="0">Pasif</option>
                            </select>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                        <button type="submit" name="add_slider" class="btn btn-primary">Ekle</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    
    <!-- Admin JS -->
    <script>
        // Mobil menü toggle
        document.addEventListener('DOMContentLoaded', function() {
            const mobileMenuToggle = document.querySelector('.mobile-menu-toggle');
            const adminSidebar = document.getElementById('adminSidebar');
            
            if (mobileMenuToggle && adminSidebar) {
                mobileMenuToggle.addEventListener('click', function() {
                    adminSidebar.classList.toggle('show');
                });
            }
            
            // Bootstrap tooltips
            var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
            var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
                return new bootstrap.Tooltip(tooltipTriggerEl);
            });
        });
    </script>
</body>
</html>
