<?php
/**
 * Dijital Menü - Kategori Çevirileri Sayfası
 */

// Gerekli dosyaları dahil et
require_once '../includes/auth.php';
require_once '../includes/language.php';
require_once '../config/database.php';

// Giriş yapılmamışsa yönlendir
redirectIfNotLoggedIn('login.php');

// Admin yetkisi kontrolü
requirePermission('admin', 'login.php');

// Sayfa başlığı
$pageTitle = 'Kategori Çevirileri';

// Ayarları al
$settings = getSetting();

// Dil işlemleri
$languageCode = isset($_GET['language']) ? $_GET['language'] : '';
$error = '';
$success = '';

// Dilleri al
$languages = getAvailableLanguages();

// Seçili dil yoksa varsayılan dili seç
if (empty($languageCode) && !empty($languages)) {
    $languageCode = getDefaultLanguage();
}

// Kategorileri al
$categories = getCategories(null, false);

// Çeviri kaydetme işlemi
if ($_SERVER['REQUEST_METHOD'] === 'POST' && !empty($languageCode)) {
    // Tüm çevirileri al
    $translations = [];
    foreach ($_POST as $key => $value) {
        if (strpos($key, 'translation_') === 0) {
            $parts = explode('_', $key);
            $categoryId = $parts[1];
            $field = $parts[2];
            
            if (!isset($translations[$categoryId])) {
                $translations[$categoryId] = [];
            }
            
            $translations[$categoryId][$field] = clean($value);
        }
    }
    
    // Mevcut çevirileri al
    $langData = loadLanguage($languageCode);
    
    // Kategori çevirileri bölümü yoksa oluştur
    if (!isset($langData['categories'])) {
        $langData['categories'] = [];
    }
    
    // Çevirileri güncelle
    foreach ($translations as $categoryId => $fields) {
        if (!isset($langData['categories'][$categoryId])) {
            $langData['categories'][$categoryId] = [];
        }
        
        foreach ($fields as $field => $value) {
            $langData['categories'][$categoryId][$field] = $value;
        }
    }
    
    // Dil dosyasını güncelle
    if (file_put_contents('../languages/' . $languageCode . '.json', json_encode($langData, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE))) {
        $success = 'Çeviriler başarıyla kaydedildi.';
    } else {
        $error = 'Çeviriler kaydedilirken bir hata oluştu.';
    }
}

// Çevirileri al
$translations = [];
$defaultTranslations = [];

if (!empty($languageCode)) {
    // Seçili dil için çevirileri yükle
    $langData = loadLanguage($languageCode);
    $translations = isset($langData['categories']) ? $langData['categories'] : [];
    
    // Varsayılan dil için çevirileri yükle
    $defaultLangCode = getDefaultLanguage();
    $defaultLangData = loadLanguage($defaultLangCode);
    $defaultTranslations = isset($defaultLangData['categories']) ? $defaultLangData['categories'] : [];
}

// Aktif kullanıcı bilgilerini al
$user = getUser($_SESSION['user_id']);
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $pageTitle; ?> | <?php echo $settings['site_title'] ?? 'Dijital Menü'; ?></title>
    
    <!-- Favicon -->
    <?php if (!empty($settings['favicon'])): ?>
    <link rel="shortcut icon" href="../assets/img/<?php echo $settings['favicon']; ?>" type="image/x-icon">
    <?php endif; ?>
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    
    <!-- Ana CSS -->
    <link href="../assets/css/style.css" rel="stylesheet">
    
    <!-- Özel Renkler -->
    <style>
        :root {
            --primary-color: <?php echo $settings['primary_color'] ?? '#3490dc'; ?>;
            --secondary-color: <?php echo $settings['secondary_color'] ?? '#38c172'; ?>;
            --text-color: <?php echo $settings['text_color'] ?? '#333333'; ?>;
            --background-color: <?php echo $settings['background_color'] ?? '#ffffff'; ?>;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <?php include 'includes/sidebar.php'; ?>
            
            <!-- Ana İçerik -->
            <div class="col-md-9 col-lg-10 admin-content">
                <!-- Üst Başlık -->
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h1 class="h3"><?php echo $pageTitle; ?></h1>
                    <div>
                        <a href="translations.php" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> Çevirilere Dön
                        </a>
                        <a href="../index.php" target="_blank" class="btn btn-outline-primary">
                            <i class="fas fa-external-link-alt"></i> Menüyü Görüntüle
                        </a>
                    </div>
                </div>
                
                <!-- Oturum Mesajı -->
                <?php if (isset($_SESSION['error_message'])): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <?php echo $_SESSION['error_message']; ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
                <?php unset($_SESSION['error_message']); ?>
                <?php endif; ?>
                
                <?php if (isset($_SESSION['success_message'])): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <?php echo $_SESSION['success_message']; ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
                <?php unset($_SESSION['success_message']); ?>
                <?php endif; ?>
                
                <?php if (!empty($error)): ?>
                <div class="alert alert-danger"><?php echo $error; ?></div>
                <?php endif; ?>
                
                <?php if (!empty($success)): ?>
                <div class="alert alert-success"><?php echo $success; ?></div>
                <?php endif; ?>
                
                <!-- İçerik -->
                <div class="admin-card">
                    <?php if (empty($languages)): ?>
                    <div class="alert alert-warning">
                        <i class="fas fa-exclamation-triangle"></i> Çeviri yapabilmek için önce <a href="languages.php">dil ekleyin</a>.
                    </div>
                    <?php elseif (empty($categories)): ?>
                    <div class="alert alert-warning">
                        <i class="fas fa-exclamation-triangle"></i> Çeviri yapabilmek için önce <a href="categories.php">kategori ekleyin</a>.
                    </div>
                    <?php else: ?>
                    <div class="mb-4">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="card mb-3">
                                    <div class="card-header">
                                        <h5 class="mb-0">Dil Seçin</h5>
                                    </div>
                                    <div class="card-body">
                                        <div class="d-flex flex-wrap gap-2">
                                            <?php foreach ($languages as $code => $language): ?>
                                            <a href="translations-categories.php?language=<?php echo $code; ?>" 
                                               class="btn <?php echo ($languageCode === $code) ? 'btn-primary' : 'btn-outline-primary'; ?>">
                                                <?php echo $language['name']; ?> (<?php echo $code; ?>)
                                                <?php if ($language['is_default']): ?> - Varsayılan<?php endif; ?>
                                            </a>
                                            <?php endforeach; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <?php if (!empty($languageCode)): ?>
                        <form method="post" action="<?php echo htmlspecialchars($_SERVER['PHP_SELF'] . '?language=' . $languageCode); ?>">
                            <div class="card">
                                <div class="card-header d-flex justify-content-between align-items-center">
                                    <h5 class="mb-0"><?php echo $languages[$languageCode]['name']; ?> Kategori Çevirileri</h5>
                                    <div>
                                        <button type="submit" class="btn btn-primary">
                                            <i class="fas fa-save"></i> Çevirileri Kaydet
                                        </button>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-hover">
                                            <thead>
                                                <tr>
                                                    <th>ID</th>
                                                    <th>Kategori</th>
                                                    <th>Varsayılan Ad</th>
                                                    <th><?php echo $languages[$languageCode]['name']; ?> Çevirisi</th>
                                                    <th>Varsayılan Açıklama</th>
                                                    <th><?php echo $languages[$languageCode]['name']; ?> Çevirisi</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php foreach ($categories as $category): ?>
                                                <tr>
                                                    <td><?php echo $category['id']; ?></td>
                                                    <td>
                                                        <?php if (!empty($category['icon'])): ?>
                                                        <img src="../assets/img/<?php echo $category['icon']; ?>" alt="<?php echo $category['name']; ?>" width="30" height="30" class="me-2">
                                                        <?php endif; ?>
                                                    </td>
                                                    <td><?php echo $category['name']; ?></td>
                                                    <td>
                                                        <input type="text" class="form-control" name="translation_<?php echo $category['id']; ?>_name" value="<?php echo isset($translations[$category['id']]['name']) ? $translations[$category['id']]['name'] : ''; ?>" placeholder="<?php echo $category['name']; ?>">
                                                    </td>
                                                    <td><?php echo $category['description']; ?></td>
                                                    <td>
                                                        <textarea class="form-control" name="translation_<?php echo $category['id']; ?>_description" rows="2" placeholder="<?php echo $category['description']; ?>"><?php echo isset($translations[$category['id']]['description']) ? $translations[$category['id']]['description'] : ''; ?></textarea>
                                                    </td>
                                                </tr>
                                                <?php endforeach; ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                                <div class="card-footer">
                                    <button type="submit" class="btn btn-primary">
                                        <i class="fas fa-save"></i> Çevirileri Kaydet
                                    </button>
                                </div>
                            </div>
                        </form>
                        <?php endif; ?>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    
    <!-- Ana JS -->
    <script src="../assets/js/script.js"></script>
</body>
</html>
