<?php
/**
 * Dijital Menü - İletişim Çevirileri Sayfası
 */

// İstanbul saatini ayarla
date_default_timezone_set('Europe/Istanbul');

// Gerekli dosyaları dahil et
require_once '../includes/auth.php';
require_once '../includes/language.php';

// Admin paneli dilini al
$adminLanguage = getAdminLanguage();

// Giriş yapılmamışsa yönlendir
redirectIfNotLoggedIn('login.php');

// Admin yetkisi kontrolü
requirePermission('admin', 'login.php');

// Sayfa başlığı
$pageTitle = __('translations.sidebar', [], $adminLanguage);

// Ayarları al
$settings = getSetting();

// Dil ve çeviri türü işlemleri
$languageCode = isset($_GET['language']) ? clean($_GET['language']) : '';
$error = '';
$success = '';

// Dilleri al
$languages = getLanguages(false);

// Seçili dil yoksa varsayılan dili seç
if (empty($languageCode) && !empty($languages)) {
    $languageCode = getDefaultLanguage();
}

// Seçili dil bilgilerini al
$selectedLanguage = [];
if (!empty($languageCode)) {
    foreach ($languages as $language) {
        if ($language['code'] === $languageCode) {
            $selectedLanguage = $language;
            break;
        }
    }
}

// Çevirileri kaydet
if ($_SERVER['REQUEST_METHOD'] === 'POST' && !empty($languageCode)) {
    $translations = isset($_POST['translations']) ? $_POST['translations'] : [];
    
    if (!empty($translations)) {
        $success = true;
        
        foreach ($translations as $key => $value) {
            $stmt = $conn->prepare("SELECT COUNT(*) as count FROM translations WHERE language_code = ? AND translation_key = ?");
            $stmt->bind_param("ss", $languageCode, $key);
            $stmt->execute();
            $result = $stmt->get_result();
            $row = $result->fetch_assoc();
            
            if ($row['count'] > 0) {
                $stmt = $conn->prepare("UPDATE translations SET translation_value = ? WHERE language_code = ? AND translation_key = ?");
                $stmt->bind_param("sss", $value, $languageCode, $key);
            } else {
                $stmt = $conn->prepare("INSERT INTO translations (language_code, translation_key, translation_value) VALUES (?, ?, ?)");
                $stmt->bind_param("sss", $languageCode, $key, $value);
            }
            
            if (!$stmt->execute()) {
                $success = false;
                break;
            }
        }
        
        if ($success) {
            $success = __('admin.translations_saved', [], $adminLanguage);
            
            // Çeviri önbelleğini temizle (gerekirse burada önbellek temizleme işlemi yapılabilir)
            // Şu an için önbellek temizleme işlemi yapılmıyor
        } else {
            $error = __('admin.translations_error', [], $adminLanguage);
        }
    }
}

// İletişim ve Sosyal Medya çevirilerini al
$contactTranslations = [
    'admin.contact' => __('admin.contact', [], 'en'),
    'admin.contact_info' => __('admin.contact_info', [], 'en'),
    'admin.contact_info_help' => __('admin.contact_info_help', [], 'en'),
    'site.wifi_name' => __('site.wifi_name', [], 'en'),
    'site.wifi_password' => __('site.wifi_password', [], 'en'),
    'admin.wifi_password_help' => __('admin.wifi_password_help', [], 'en'),
    'site.social_media' => __('site.social_media', [], 'en'),
    'admin.social_media_help' => __('admin.social_media_help', [], 'en'),
    'admin.sidebar_translations' => __('admin.sidebar_translations', [], 'en'),
    'admin.enable_waiter_call_help' => __('admin.enable_waiter_call_help', [], 'en')
];

// Aktif kullanıcı bilgilerini al
$user = getUser($_SESSION['user_id']);
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $pageTitle; ?> | <?php echo $settings['site_title'] ?? 'Dijital Menü'; ?></title>
    
    <!-- Favicon -->
    <?php if (!empty($settings['favicon'])): ?>
    <link rel="shortcut icon" href="../assets/img/<?php echo $settings['favicon']; ?>" type="image/x-icon">
    <?php endif; ?>
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    
    <!-- Ana CSS -->
    <link href="../assets/css/style.css" rel="stylesheet">
    
    <!-- Özel Renkler -->
    <style>
        :root {
            --primary-color: <?php echo $settings['primary_color'] ?? '#3490dc'; ?>;
            --secondary-color: <?php echo $settings['secondary_color'] ?? '#38c172'; ?>;
            --text-color: <?php echo $settings['text_color'] ?? '#333333'; ?>;
            --background-color: <?php echo $settings['background_color'] ?? '#ffffff'; ?>;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <?php include 'includes/sidebar.php'; ?>
            
            <!-- Ana İçerik -->
            <div class="col-md-9 col-lg-10 admin-content">
                <!-- Üst Başlık -->
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h1 class="h3"><?php echo $pageTitle; ?></h1>
                    <div>
                        <a href="translations.php" class="btn btn-outline-secondary me-2">
                            <i class="fas fa-arrow-left"></i> <?php echo __('admin.go_back', [], $adminLanguage); ?>
                        </a>
                        <a href="../index.php" target="_blank" class="btn btn-outline-primary">
                            <i class="fas fa-external-link-alt"></i> <?php echo __('admin.view_menu', [], $adminLanguage); ?>
                        </a>
                    </div>
                </div>
                
                <!-- Oturum Mesajı -->
                <?php if (isset($_SESSION['error_message'])): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <?php echo $_SESSION['error_message']; ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
                <?php unset($_SESSION['error_message']); ?>
                <?php endif; ?>
                
                <?php if (isset($_SESSION['success_message'])): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <?php echo $_SESSION['success_message']; ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
                <?php unset($_SESSION['success_message']); ?>
                <?php endif; ?>
                
                <?php if (!empty($error)): ?>
                <div class="alert alert-danger"><?php echo $error; ?></div>
                <?php endif; ?>
                
                <?php if (!empty($success)): ?>
                <div class="alert alert-success"><?php echo $success; ?></div>
                <?php endif; ?>
                
                <!-- İçerik -->
                <div class="admin-card">
                    <?php if (empty($languages)): ?>
                    <div class="alert alert-warning">
                        <i class="fas fa-exclamation-triangle"></i> <?php echo __('admin.add_language_first', [], $adminLanguage); ?> <a href="languages.php"><?php echo __('admin.add_language', [], $adminLanguage); ?></a>.
                    </div>
                    <?php elseif (empty($selectedLanguage)): ?>
                    <div class="alert alert-warning">
                        <i class="fas fa-exclamation-triangle"></i> <?php echo __('admin.select_language', [], $adminLanguage); ?>
                    </div>
                    <div class="d-flex flex-wrap gap-2">
                        <?php foreach ($languages as $language): ?>
                        <a href="translations-sidebar.php?language=<?php echo $language['code']; ?>" 
                           class="btn <?php echo ($languageCode === $language['code']) ? 'btn-primary' : 'btn-outline-primary'; ?>">
                            <?php echo $language['name']; ?> (<?php echo $language['code']; ?>)
                            <?php if ($language['is_default'] == 1): ?> - <?php echo __('admin.is_default', [], $adminLanguage); ?><?php endif; ?>
                        </a>
                        <?php endforeach; ?>
                    </div>
                    <?php else: ?>
                    <div class="mb-4">
                        <div class="card mb-3">
                            <div class="card-header">
                                <h5 class="mb-0"><?php echo __('admin.select_language', [], $adminLanguage); ?></h5>
                            </div>
                            <div class="card-body">
                                <div class="d-flex flex-wrap gap-2">
                                    <?php foreach ($languages as $language): ?>
                                    <a href="translations-sidebar.php?language=<?php echo $language['code']; ?>" 
                                       class="btn <?php echo ($languageCode === $language['code']) ? 'btn-primary' : 'btn-outline-primary'; ?>">
                                        <?php echo $language['name']; ?> (<?php echo $language['code']; ?>)
                                        <?php if ($language['is_default'] == 1): ?> - <?php echo __('admin.is_default', [], $adminLanguage); ?><?php endif; ?>
                                    </a>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                        </div>
                        
                        <div class="card">
                            <div class="card-header">
                                <h5 class="mb-0"><?php echo __('admin.sidebar_translations', [], $adminLanguage); ?> - <?php echo $selectedLanguage['name']; ?></h5>
                            </div>
                            <div class="card-body">
                                <form method="post" action="<?php echo htmlspecialchars($_SERVER['PHP_SELF'] . '?language=' . $languageCode); ?>">
                                    <div class="table-responsive">
                                        <table class="table table-bordered table-hover">
                                            <thead class="table-light">
                                                <tr>
                                                    <th><?php echo __('admin.key', [], $adminLanguage); ?></th>
                                                    <th><?php echo __('admin.default_value', [], $adminLanguage); ?> (<?php echo __('admin.english', [], $adminLanguage); ?>)</th>
                                                    <th><?php echo __('admin.translation_value', [], $adminLanguage); ?> (<?php echo $selectedLanguage['name']; ?>)</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php foreach ($contactTranslations as $key => $defaultValue): ?>
                                                <tr>
                                                    <td><code><?php echo $key; ?></code></td>
                                                    <td><?php echo htmlspecialchars($defaultValue); ?></td>
                                                    <td>
                                                        <input type="text" class="form-control" name="translations[<?php echo $key; ?>]" value="<?php echo htmlspecialchars(__($key, [], $languageCode)); ?>">
                                                    </td>
                                                </tr>
                                                <?php endforeach; ?>
                                            </tbody>
                                        </table>
                                    </div>
                                    
                                    <div class="mt-3">
                                        <button type="submit" class="btn btn-primary">
                                            <i class="fas fa-save"></i> <?php echo __('admin.save_translations', [], $adminLanguage); ?>
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    
    <!-- Ana JS -->
    <script src="../assets/js/script.js"></script>
</body>
</html>
