<?php
/**
 * Dijital Menü - Çeviriler Ana Sayfası
 */

// İstanbul saatini ayarla
date_default_timezone_set('Europe/Istanbul');

// Gerekli dosyaları dahil et
require_once '../includes/auth.php';
require_once '../includes/language.php';

// Admin paneli dilini al
$adminLanguage = getAdminLanguage();

// Giriş yapılmamışsa yönlendir
redirectIfNotLoggedIn('login.php');

// Admin yetkisi kontrolü
requirePermission('admin', 'login.php');

// Sayfa başlığı
$pageTitle = __('admin.translations', [], $adminLanguage);

// Ayarları al
$settings = getSetting();

// Dil ve çeviri türü işlemleri
$languageCode = isset($_GET['language']) ? clean($_GET['language']) : '';
$error = '';
$success = '';

// Dilleri al
$languages = getLanguages(false);

// Seçili dil yoksa varsayılan dili seç
if (empty($languageCode) && !empty($languages)) {
    $languageCode = getDefaultLanguage();
}

// Seçili dil bilgilerini al
$selectedLanguage = [];
if (!empty($languageCode)) {
    foreach ($languages as $language) {
        if ($language['code'] === $languageCode) {
            $selectedLanguage = $language;
            break;
        }
    }
}

// Aktif kullanıcı bilgilerini al
$user = getUser($_SESSION['user_id']);
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $pageTitle; ?> | <?php echo $settings['site_title'] ?? 'Dijital Menü'; ?></title>
    
    <!-- Favicon -->
    <?php if (!empty($settings['favicon'])): ?>
    <link rel="shortcut icon" href="../assets/img/<?php echo $settings['favicon']; ?>" type="image/x-icon">
    <?php endif; ?>
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    
    <!-- Ana CSS -->
    <link href="../assets/css/style.css" rel="stylesheet">
    
    <!-- Özel Renkler -->
    <style>
        :root {
            --primary-color: <?php echo $settings['primary_color'] ?? '#3490dc'; ?>;
            --secondary-color: <?php echo $settings['secondary_color'] ?? '#38c172'; ?>;
            --text-color: <?php echo $settings['text_color'] ?? '#333333'; ?>;
            --background-color: <?php echo $settings['background_color'] ?? '#ffffff'; ?>;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <?php include 'includes/sidebar.php'; ?>
            
            <!-- Ana İçerik -->
            <div class="col-md-9 col-lg-10 admin-content">
                <!-- Üst Başlık -->
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h1 class="h3"><?php echo $pageTitle; ?></h1>
                    <div>
                        <a href="../index.php" target="_blank" class="btn btn-outline-primary">
                            <i class="fas fa-external-link-alt"></i> <?php echo __('admin.view_menu', [], $adminLanguage); ?>
                        </a>
                    </div>
                </div>
                
                <!-- Oturum Mesajı -->
                <?php if (isset($_SESSION['error_message'])): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <?php echo $_SESSION['error_message']; ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
                <?php unset($_SESSION['error_message']); ?>
                <?php endif; ?>
                
                <?php if (isset($_SESSION['success_message'])): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <?php echo $_SESSION['success_message']; ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
                <?php unset($_SESSION['success_message']); ?>
                <?php endif; ?>
                
                <?php if (!empty($error)): ?>
                <div class="alert alert-danger"><?php echo $error; ?></div>
                <?php endif; ?>
                
                <?php if (!empty($success)): ?>
                <div class="alert alert-success"><?php echo $success; ?></div>
                <?php endif; ?>
                
                <!-- İçerik -->
                <div class="admin-card">
                    <?php if (empty($languages)): ?>
                    <div class="alert alert-warning">
                        <i class="fas fa-exclamation-triangle"></i> <?php echo __('admin.add_language_first', [], $adminLanguage); ?> <a href="languages.php"><?php echo __('admin.add_language', [], $adminLanguage); ?></a>.
                    </div>
                    <?php else: ?>
                    <div class="mb-4">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="card mb-3">
                                    <div class="card-header">
                                        <h5 class="mb-0"><?php echo __('admin.select_language', [], $adminLanguage); ?></h5>
                                    </div>
                                    <div class="card-body">
                                        <div class="d-flex flex-wrap gap-2">
                                            <?php foreach ($languages as $language): ?>
                                            <a href="translations.php?language=<?php echo $language['code']; ?>" 
                                               class="btn <?php echo ($languageCode === $language['code']) ? 'btn-primary' : 'btn-outline-primary'; ?>">
                                                <?php echo $language['name']; ?> (<?php echo $language['code']; ?>)
                                                <?php if ($language['is_default'] == 1): ?> - <?php echo __('admin.is_default', [], $adminLanguage); ?><?php endif; ?>
                                            </a>
                                            <?php endforeach; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <?php if (!empty($selectedLanguage)): ?>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="card">
                                    <div class="card-header">
                                        <h5 class="mb-0"><?php echo $selectedLanguage['name']; ?> <?php echo __('admin.translations', [], $adminLanguage); ?></h5>
                                    </div>
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-md-6 mb-3">
                                                <div class="card h-100">
                                                    <div class="card-body text-center">
                                                        <i class="fas fa-cog fa-3x mb-3 text-primary"></i>
                                                        <h5 class="card-title"><?php echo __('translations.site', [], $adminLanguage); ?></h5>
                                                        <p class="card-text"><?php echo __('admin.site_texts', [], $adminLanguage); ?></p>
                                                        <a href="translations-site.php?language=<?php echo $selectedLanguage['code']; ?>" class="btn btn-primary">
                                                            <i class="fas fa-edit"></i> <?php echo __('admin.edit', [], $adminLanguage); ?>
                                                        </a>
                                                    </div>
                                                </div>
                                            </div>
                                            
                                            <div class="col-md-6 mb-3">
                                                <div class="card h-100">
                                                    <div class="card-body text-center">
                                                        <i class="fas fa-user-cog fa-3x mb-3 text-primary"></i>
                                                        <h5 class="card-title"><?php echo __('translations.admin', [], $adminLanguage); ?></h5>
                                                        <p class="card-text"><?php echo __('admin.admin_texts', [], $adminLanguage); ?></p>
                                                        <a href="translations-admin.php?language=<?php echo $selectedLanguage['code']; ?>" class="btn btn-primary">
                                                            <i class="fas fa-edit"></i> <?php echo __('admin.edit', [], $adminLanguage); ?>
                                                        </a>
                                                    </div>
                                                </div>
                                            </div>
                                            
                                            <div class="col-md-4 mb-3">
                                                <div class="card h-100">
                                                    <div class="card-body text-center">
                                                        <i class="fas fa-list fa-3x mb-3 text-primary"></i>
                                                        <h5 class="card-title"><?php echo __('translations.categories', [], $adminLanguage); ?></h5>
                                                        <p class="card-text"><?php echo __('admin.category_translations', [], $adminLanguage); ?></p>
                                                        <a href="translations-categories.php?language=<?php echo $selectedLanguage['code']; ?>" class="btn btn-primary">
                                                            <i class="fas fa-edit"></i> <?php echo __('admin.edit', [], $adminLanguage); ?>
                                                        </a>
                                                    </div>
                                                </div>
                                            </div>
                                            
                                            <div class="col-md-4 mb-3">
                                                <div class="card h-100">
                                                    <div class="card-body text-center">
                                                        <i class="fas fa-utensils fa-3x mb-3 text-primary"></i>
                                                        <h5 class="card-title"><?php echo __('translations.items', [], $adminLanguage); ?></h5>
                                                        <p class="card-text"><?php echo __('admin.item_translations', [], $adminLanguage); ?></p>
                                                        <a href="translations-items.php?language=<?php echo $selectedLanguage['code']; ?>" class="btn btn-primary">
                                                            <i class="fas fa-edit"></i> <?php echo __('admin.edit', [], $adminLanguage); ?>
                                                        </a>
                                                    </div>
                                                </div>
                                            </div>
                                            
                                            <div class="col-md-4 mb-3">
                                                <div class="card h-100">
                                                    <div class="card-body text-center">
                                                        <i class="fas fa-exclamation-circle fa-3x mb-3 text-primary"></i>
                                                        <h5 class="card-title"><?php echo __('translations.allergens', [], $adminLanguage); ?></h5>
                                                        <p class="card-text"><?php echo __('admin.allergen_translations', [], $adminLanguage); ?></p>
                                                        <a href="translations-allergens.php?language=<?php echo $selectedLanguage['code']; ?>" class="btn btn-primary">
                                                            <i class="fas fa-edit"></i> <?php echo __('admin.edit', [], $adminLanguage); ?>
                                                        </a>
                                                    </div>
                                                </div>
                                            </div>
                                            
                                            <div class="col-md-4 mb-3">
                                                <div class="card h-100">
                                                    <div class="card-body text-center">
                                                        <i class="fas fa-chair fa-3x mb-3 text-primary"></i>
                                                        <h5 class="card-title"><?php echo __('translations.tables_translations', [], $adminLanguage); ?></h5>
                                                        <p class="card-text"><?php echo __('admin.table_translations', [], $adminLanguage); ?></p>
                                                        <a href="translations-tables.php?language=<?php echo $selectedLanguage['code']; ?>" class="btn btn-primary">
                                                            <i class="fas fa-edit"></i> <?php echo __('admin.edit', [], $adminLanguage); ?>
                                                        </a>
                                                    </div>
                                                </div>
                                            </div>
                                            
                                            <div class="col-md-4 mb-3">
                                                <div class="card h-100">
                                                    <div class="card-body text-center">
                                                        <i class="fas fa-bars fa-3x mb-3 text-primary"></i>
                                                        <h5 class="card-title"><?php echo __('translations.sidebar', [], $adminLanguage); ?></h5>
                                                        <p class="card-text"><?php echo __('admin.sidebar_translations', [], $adminLanguage); ?></p>
                                                        <a href="translations-sidebar.php?language=<?php echo $selectedLanguage['code']; ?>" class="btn btn-primary">
                                                            <i class="fas fa-edit"></i> <?php echo __('admin.edit', [], $adminLanguage); ?>
                                                        </a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php endif; ?>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    
    <!-- Ana JS -->
    <script src="../assets/js/script.js"></script>
</body>
</html>
