/**
 * Dijital Menü - Ana JavaScript Dosyası
 */

document.addEventListener('DOMContentLoaded', function() {
    // Bootstrap Tooltip'leri etkinleştir
    var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
    var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
        return new bootstrap.Tooltip(tooltipTriggerEl);
    });
    
    // Menü öğelerini filtrele
    initializeMenuFilter();
    
    // Admin panel fonksiyonları
    if (document.querySelector('.admin-content')) {
        initializeAdminFunctions();
    }
});

/**
 * Garson çağırma butonu başlatma
 */
function initializeWaiterCall() {
    // Bu fonksiyon garson çağırma butonunu başlatır
    console.log('Garson çağırma butonu başlatıldı');
}

/**
 * Menü filtreleme fonksiyonları
 */
function initializeMenuFilter() {
    // Kategori filtreleme
    const categoryButtons = document.querySelectorAll('.category-filter');
    if (categoryButtons.length > 0) {
        categoryButtons.forEach(button => {
            button.addEventListener('click', function(e) {
                e.preventDefault();
                
                // Aktif sınıfı kaldır
                categoryButtons.forEach(btn => btn.classList.remove('active'));
                
                // Tıklanan butona aktif sınıfı ekle
                this.classList.add('active');
                
                // Kategori ID'sini al
                const categoryId = this.dataset.categoryId;
                
                // Menü öğelerini filtrele
                const menuItems = document.querySelectorAll('.menu-item-container');
                menuItems.forEach(item => {
                    if (categoryId === 'all' || item.dataset.categoryId === categoryId) {
                        item.style.display = 'block';
                    } else {
                        item.style.display = 'none';
                    }
                });
            });
        });
    }
    
    // Arama fonksiyonu
    const searchInput = document.getElementById('menu-search');
    if (searchInput) {
        searchInput.addEventListener('input', function() {
            const searchTerm = this.value.toLowerCase();
            
            // Menü öğelerini filtrele
            const menuItems = document.querySelectorAll('.menu-item-container');
            menuItems.forEach(item => {
                const itemName = item.dataset.itemName.toLowerCase();
                const itemDescription = item.dataset.itemDescription.toLowerCase();
                
                if (itemName.includes(searchTerm) || itemDescription.includes(searchTerm)) {
                    item.style.display = 'block';
                } else {
                    item.style.display = 'none';
                }
            });
        });
    }
}

/**
 * Overlay Sidebar ve Bottom Menu Fonksiyonları
 */
function toggleSidebar() {
    const sidebar = document.getElementById('overlaySidebar');
    const body = document.body;
    
    // Aktif buton değiştir
    setActiveButton('menu');
    
    if (sidebar.classList.contains('active')) {
        sidebar.classList.remove('active');
        // Overlay arka planını kaldır
        const overlay = document.querySelector('.overlay-background');
        if (overlay) {
            overlay.classList.remove('active');
            setTimeout(() => {
                overlay.remove();
            }, 300);
        }
        body.style.overflow = '';
    } else {
        sidebar.classList.add('active');
        // Overlay arka planı ekle
        const overlay = document.createElement('div');
        overlay.className = 'overlay-background';
        document.body.appendChild(overlay);
        
        // Animasyon için timeout
        setTimeout(() => {
            overlay.classList.add('active');
        }, 10);
        
        // Overlay'a tıklandığında sidebar'ı kapat
        overlay.addEventListener('click', toggleSidebar);
        
        // Sayfanın kaydırılmasını engelle
        body.style.overflow = 'hidden';
    }
}

/**
 * Info Overlay Fonksiyonları
 */
function toggleInfo() {
    const infoOverlay = document.getElementById('infoOverlay');
    const body = document.body;
    const overlayBackground = document.getElementById('overlayBackground');
    
    // Aktif buton değiştir
    setActiveButton('info');
    
    if (infoOverlay.classList.contains('active')) {
        infoOverlay.classList.remove('active');
        if (overlayBackground) {
            overlayBackground.classList.remove('active');
        }
        body.style.overflow = '';
    } else {
        infoOverlay.classList.add('active');
        
        // Overlay arka planını ekle
        if (overlayBackground) {
            overlayBackground.classList.add('active');
            
            // Overlay'a tıklandığında info overlay'i kapat
            overlayBackground.addEventListener('click', function(e) {
                e.preventDefault();
                console.log('Overlay background clicked');
                toggleInfo();
            });
        }
        
        body.style.overflow = 'hidden';
    }
    
    console.log('Info overlay toggled:', infoOverlay.classList.contains('active'));
}

/**
 * Arama Overlay Fonksiyonları
 */
function toggleSearch() {
    const searchOverlay = document.getElementById('searchOverlay');
    const body = document.body;
    const overlayBackground = document.getElementById('overlayBackground');
    
    // Aktif buton değiştir
    setActiveButton('search');
    
    if (searchOverlay.classList.contains('active')) {
        searchOverlay.classList.remove('active');
        if (overlayBackground) {
            overlayBackground.classList.remove('active');
        }
        body.style.overflow = '';
    } else {
        searchOverlay.classList.add('active');
        
        // Overlay arka planını ekle
        if (overlayBackground) {
            overlayBackground.classList.add('active');
            
            // Overlay'a tıklandığında search overlay'i kapat
            overlayBackground.addEventListener('click', function(e) {
                e.preventDefault();
                console.log('Overlay background clicked');
                toggleSearch();
            });
        }
        
        body.style.overflow = 'hidden';
        
        // Arama kutusuna odaklan
        setTimeout(() => {
            const searchInput = searchOverlay.querySelector('input[type="text"]');
            if (searchInput) {
                searchInput.focus();
            }
        }, 300);
    }
    
    console.log('Search overlay toggled:', searchOverlay.classList.contains('active'));
}

/**
 * WiFi Şifresi Gösterme Fonksiyonu
 */
function showWifiPassword() {
    const wifiContainer = document.getElementById('wifiPasswordContainer');
    
    if (wifiContainer.style.display === 'none') {
        wifiContainer.style.display = 'block';
    } else {
        wifiContainer.style.display = 'none';
    }
}

/**
 * Info Overlay WiFi Şifresi Gösterme Fonksiyonu
 */
function showInfoWifiPassword() {
    const wifiContainer = document.getElementById('infoWifiPasswordContainer');
    
    if (!wifiContainer) {
        console.error('WiFi password container not found');
        return;
    }
    
    // getComputedStyle kullanarak gerçek display değerini al
    const computedStyle = window.getComputedStyle(wifiContainer);
    
    if (computedStyle.display === 'none') {
        wifiContainer.style.display = 'block';
    } else {
        wifiContainer.style.display = 'none';
    }
}

/**
 * Garson Çağırma Fonksiyonu
 */
function callWaiter() {
    const tableId = document.querySelector('.bottom-menu-item[onclick="callWaiter()"]')?.dataset?.tableId;
    const language = document.documentElement.lang || 'tr';
    
    // Aktif buton değiştir
    setActiveButton('waiter');
    
    // QR parametresini kontrol et
    const urlParams = new URLSearchParams(window.location.search);
    const qrParam = urlParams.get('qr');
    
    if (tableId) {
        if (qrParam) {
            // QR parametresi varsa, onu kullan
            window.location.href = `modules/waiter/call.php?qr=${qrParam}&lang=${language}`;
        } else {
            // QR parametresi yoksa, table_id parametresini kullan
            window.location.href = `modules/waiter/call.php?table_id=${tableId}&lang=${language}`;
        }
    } else {
        alert('Lütfen önce bir masa seçin.');
    }
}

/**
 * Aktif Buton Değiştirme Fonksiyonu
 */
function setActiveButton(buttonType) {
    // Tüm butonlardan active sınıfını kaldır
    document.querySelectorAll('.bottom-menu-item').forEach(item => {
        item.classList.remove('active');
    });
    
    // İlgili butona active sınıfını ekle
    let selector;
    switch (buttonType) {
        case 'menu':
            selector = '.bottom-menu-item:first-child';
            break;
        case 'waiter':
            selector = '.bottom-menu-item:nth-child(2)';
            break;
        case 'info':
            selector = '.bottom-menu-item:nth-child(3)';
            break;
        case 'search':
            selector = '.bottom-menu-item:last-child';
            break;
        default:
            selector = '.bottom-menu-item:first-child';
    }
    
    const activeButton = document.querySelector(selector);
    if (activeButton) {
        activeButton.classList.add('active');
    }
    
    // URL'ye active parametresini ekle
    const url = new URL(window.location.href);
    url.searchParams.set('active', buttonType);
    history.replaceState(null, '', url);
}

// Sayfa yüklendiğinde URL'deki active parametresine göre aktif butonu ayarla
document.addEventListener('DOMContentLoaded', function() {
    const urlParams = new URLSearchParams(window.location.search);
    const activeParam = urlParams.get('active');
    
    if (activeParam) {
        setActiveButton(activeParam);
    }
});

/**
 * Admin panel fonksiyonları
 */
function initializeAdminFunctions() {
    // Mobil menü butonu
    const mobileMenuToggle = document.querySelector('.mobile-menu-toggle');
    const adminSidebar = document.getElementById('adminSidebar');
    
    // Debug için konsola yazdır
    console.log('Mobile Menu Toggle:', mobileMenuToggle);
    console.log('Admin Sidebar:', adminSidebar);
    
    if (mobileMenuToggle && adminSidebar) {
        // Tıklama olayını touchstart ve click olaylarına bağla (mobil cihazlar için daha iyi)
        ['touchstart', 'click'].forEach(function(evt) {
            mobileMenuToggle.addEventListener(evt, function(e) {
                e.preventDefault(); // Varsayılan davranışı engelle
                console.log('Mobile menu button clicked/touched');
                
                // Sidebar'ı göster/gizle
                adminSidebar.classList.toggle('show');
                console.log('Sidebar show class toggled:', adminSidebar.classList.contains('show'));
                
                // Overlay arka planı ekle/kaldır
                if (adminSidebar.classList.contains('show')) {
                    // Önce eski overlay'i temizle
                    let oldOverlay = document.querySelector('.overlay-background');
                    if (oldOverlay) {
                        oldOverlay.remove();
                    }
                    
                    // Yeni overlay oluştur
                    let overlay = document.createElement('div');
                    overlay.className = 'overlay-background';
                    document.body.appendChild(overlay);
                    console.log('Overlay created');
                    
                    // Overlay'a tıklama olaylarını ekle
                    overlay.addEventListener('touchstart', function(e) {
                        e.preventDefault();
                        console.log('Overlay touched');
                        closeAdminSidebar();
                    });
                    
                    overlay.addEventListener('click', function(e) {
                        e.preventDefault();
                        console.log('Overlay clicked');
                        closeAdminSidebar();
                    });
                    
                    // Animasyon için timeout
                    setTimeout(() => {
                        overlay.classList.add('active');
                        console.log('Overlay activated');
                    }, 10);
                } else {
                    closeAdminSidebar();
                }
            }, { passive: false });
        });
    }
    
    // Sidebar'ı kapatma fonksiyonu
    function closeAdminSidebar(e) {
        console.log('closeAdminSidebar called', e ? 'with event' : 'without event');
        
        // Olay kontrolünü kaldır - her durumda sidebar'ı kapat
        console.log('Closing admin sidebar');
        const adminSidebar = document.getElementById('adminSidebar');
        if (adminSidebar) {
            adminSidebar.classList.remove('show');
        }
        
        // Overlay arka planını kaldır
        const overlay = document.querySelector('.overlay-background');
        if (overlay) {
            overlay.classList.remove('active');
            setTimeout(() => {
                overlay.remove();
                console.log('Overlay removed');
            }, 300);
        }
    }
    
    // Silme işlemi onayı
    const deleteButtons = document.querySelectorAll('[data-confirm]');
    if (deleteButtons.length > 0) {
        deleteButtons.forEach(button => {
            button.addEventListener('click', function(e) {
                if (!confirm(this.dataset.confirm)) {
                    e.preventDefault();
                }
            });
        });
    }
    
    // Dosya yükleme önizleme
    const fileInputs = document.querySelectorAll('input[type="file"]');
    if (fileInputs.length > 0) {
        fileInputs.forEach(input => {
            input.addEventListener('change', function() {
                const preview = document.getElementById(this.dataset.preview);
                if (preview && this.files && this.files[0]) {
                    const reader = new FileReader();
                    
                    reader.onload = function(e) {
                        preview.src = e.target.result;
                        preview.style.display = 'block';
                    };
                    
                    reader.readAsDataURL(this.files[0]);
                }
            });
        });
    }
    
    // Sıralama fonksiyonu
    initializeSorting();
    
    // Garson çağrıları için otomatik yenileme
    initializeWaiterCallsRefresh();
}

/**
 * Sıralama fonksiyonu
 */
function initializeSorting() {
    const sortableList = document.querySelector('.sortable-list');
    if (sortableList) {
        // Sortable.js veya benzer bir kütüphane kullanılabilir
        // Bu örnek için basit bir sürükle-bırak işlevi eklenmemiştir
    }
}

/**
 * Garson çağrıları için otomatik yenileme
 */
function initializeWaiterCallsRefresh() {
    const waiterCallsTable = document.getElementById('waiter-calls-table');
    if (waiterCallsTable) {
        // Her 30 saniyede bir yenile
        setInterval(function() {
            // AJAX isteği ile yeni çağrıları kontrol et
            fetch('waiter-calls.php?ajax=1')
                .then(response => response.json())
                .then(data => {
                    if (data.newCalls) {
                        // Yeni çağrı varsa sayfayı yenile
                        location.reload();
                    }
                })
                .catch(error => console.error('Error:', error));
        }, 30000);
    }
}

/**
 * Bildirim sesi çal
 */
function playNotificationSound() {
    const audio = new Audio('../assets/sounds/notification.mp3');
    audio.play();
}

/**
 * QR kod indirme
 */
function downloadQRCode(element, filename) {
    const canvas = document.createElement('canvas');
    const context = canvas.getContext('2d');
    const image = new Image();
    
    image.onload = function() {
        canvas.width = image.width;
        canvas.height = image.height;
        context.drawImage(image, 0, 0);
        
        const link = document.createElement('a');
        link.download = filename;
        link.href = canvas.toDataURL('image/png');
        link.click();
    };
    
    image.src = element.src;
}

/**
 * Dil değiştirme
 */
function changeLanguage(code) {
    const currentUrl = new URL(window.location.href);
    currentUrl.searchParams.set('lang', code);
    window.location.href = currentUrl.toString();
}
