<?php
/**
 * Happy Hour Kontrolü ve Görüntüleme
 */

// Happy Hour kontrolü
$showHappyHour = false;
if (isset($settings['happy_hour_enabled']) && $settings['happy_hour_enabled'] == 1) {
    $currentTime = date('H:i');
    $currentDay = date('w'); // 0 (Pazar) - 6 (Cumartesi)
    
    $startTime = $settings['happy_hour_start_time'] ?? '17:00';
    $endTime = $settings['happy_hour_end_time'] ?? '19:00';
    $activeDays = isset($settings['happy_hour_days']) ? json_decode($settings['happy_hour_days'], true) : [1, 2, 3, 4, 5];
    
    // Gün ve saat kontrolü
    if (in_array($currentDay, $activeDays) && $currentTime >= $startTime && $currentTime <= $endTime) {
        $showHappyHour = true;
    }
}

if ($showHappyHour && $categoryId == 0 && empty($searchQuery)):
?>
<div class="happy-hour-container">
    <div class="happy-hour-banner">
        <h3><?php echo __('site.happy_hour_title', [], $languageCode) ?: ($settings['happy_hour_title'] ?? 'Happy Hour!'); ?></h3>
        <p><?php echo __('site.happy_hour_message', [], $languageCode) ?: ($settings['happy_hour_message'] ?? 'Tüm içeceklerde %20 indirim!'); ?></p>
    </div>
</div>
<?php endif; ?>
