<?php
// LISANS_KODU_BURADA
/**
 * Dijital Menü - Ana Sayfa
 */

// İstanbul saatini ayarla
date_default_timezone_set('Europe/Istanbul');

// Gerekli dosyaları dahil et
require_once 'includes/functions.php';
require_once 'includes/language.php';
require_once 'includes/slider_functions.php';

// Ayarları al
$settings = getSetting();

// Masa ID'sini al (eski yöntem)
$tableId = isset($_GET['table_id']) ? intval($_GET['table_id']) : 0;

// QR kod parametresini kontrol et (yeni yöntem)
$qrParam = isset($_GET['qr']) ? clean($_GET['qr']) : '';
$accessedViaQr = !empty($qrParam);

if (!empty($qrParam)) {
    // Base64 kodunu çöz
    $decodedQr = base64_decode($qrParam);
    
    // "Table:ID" formatını kontrol et
    if (preg_match('/^Table:(\d+)$/', $decodedQr, $matches)) {
        $tableId = intval($matches[1]);
    }
}

// Masa bilgilerini al
$table = [];
if ($tableId > 0) {
    $stmt = $conn->prepare("SELECT * FROM tables WHERE id = ?");
    $stmt->bind_param("i", $tableId);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows === 1) {
        $table = $result->fetch_assoc();
    }
}

// Kategori filtresi
$categoryId = isset($_GET['category_id']) ? intval($_GET['category_id']) : 0;

// Dil ayarı
$languageCode = isset($_GET['lang']) ? clean($_GET['lang']) : ($settings['default_language'] ?? 'tr');

// Dil çevirileri
$translations = [
    'menu' => __('site.menu', [], $languageCode),
    'categories' => __('site.categories', [], $languageCode),
    'all_categories' => __('site.all_categories', [], $languageCode),
    'special_items' => __('site.special_items', [], $languageCode),
    'popular_items' => __('site.popular_items', [], $languageCode),
    'vegetarian' => __('site.vegetarian', [], $languageCode),
    'vegan' => __('site.vegan', [], $languageCode),
    'gluten_free' => __('site.gluten_free', [], $languageCode),
    'allergens' => __('site.allergens', [], $languageCode),
    'call_waiter' => __('site.call_waiter', [], $languageCode),
    'table' => __('site.table', [], $languageCode),
    'search' => __('site.search', [], $languageCode),
    'search_placeholder' => __('site.search_placeholder', [], $languageCode),
    'no_items_found' => __('site.no_items_found', [], $languageCode),
    'footer_text' => __('site.footer_text', [], $languageCode) ?: ($settings['footer_text'] ?? '© 2025 Dijital Menü. Tüm hakları saklıdır.'),
    'home' => __('site.home', [], $languageCode) ?: 'Ana Sayfa',
    'info' => __('site.info', [], $languageCode) ?: 'Bilgi',
    'contact' => __('site.contact', [], $languageCode) ?: 'İletişim',
    'social_media' => __('site.social_media', [], $languageCode) ?: 'Sosyal Medya',
    'wifi_name' => __('site.wifi_name', [], $languageCode) ?: 'WiFi Adı',
    'wifi_password' => __('site.wifi_password', [], $languageCode) ?: 'WiFi Şifresi',
    'happy_hour_title' => __('site.happy_hour_title', [], $languageCode) ?: 'Happy Hour!',
    'happy_hour_message' => __('site.happy_hour_message', [], $languageCode) ?: 'Tüm içeceklerde %20 indirim!'
];

// Tüm kategorileri al (sadece aktif olanlar)
$categories = getCategories(true);

// Menü öğelerini al (sadece aktif olanlar)
$items = [];
if ($categoryId > 0) {
    // Belirli bir kategorideki öğeleri al
    $items = getItems($categoryId, true);
} else {
    // Tüm öğeleri al
    $items = getItems(null, true);
}

// Arama işlemi
$searchQuery = isset($_GET['search']) ? clean($_GET['search']) : '';
if (!empty($searchQuery)) {
    $filteredItems = [];
    $searchQueryLower = mb_strtolower($searchQuery, 'UTF-8');
    foreach ($items as $item) {
        $itemNameLower = mb_strtolower($item['name'], 'UTF-8');
        $itemDescLower = mb_strtolower($item['description'], 'UTF-8');
        
        if (mb_strpos($itemNameLower, $searchQueryLower) !== false || 
            mb_strpos($itemDescLower, $searchQueryLower) !== false) {
            $filteredItems[] = $item;
        }
        
        // Çevirilerde de ara
        if (isset($itemTranslations[$item['id']]['name'])) {
            $translatedNameLower = mb_strtolower($itemTranslations[$item['id']]['name'], 'UTF-8');
            if (mb_strpos($translatedNameLower, $searchQueryLower) !== false) {
                if (!in_array($item, $filteredItems)) {
                    $filteredItems[] = $item;
                }
            }
        }
        
        if (isset($itemTranslations[$item['id']]['description'])) {
            $translatedDescLower = mb_strtolower($itemTranslations[$item['id']]['description'], 'UTF-8');
            if (mb_strpos($translatedDescLower, $searchQueryLower) !== false) {
                if (!in_array($item, $filteredItems)) {
                    $filteredItems[] = $item;
                }
            }
        }
    }
    $items = $filteredItems;
}

// Tüm alerjenleri al
$allergens = getAllergens();

// Kategori ve ürün çevirilerini al
$categoryTranslations = [];
$itemTranslations = [];
$allergenTranslations = [];

// Dil verilerini yükle
$langData = loadLanguage($languageCode);

// Kategori çevirileri
if (isset($langData['categories'])) {
    $categoryTranslations = $langData['categories'];
}

// Ürün çevirileri
if (isset($langData['items'])) {
    $itemTranslations = $langData['items'];
}

// Alerjen çevirileri
if (isset($langData['allergens'])) {
    $allergenTranslations = $langData['allergens'];
}

// Dilleri al
$languages = getAvailableLanguages();
?>
<!DOCTYPE html>
<?php
// Dil yönünü kontrol et
$langDirection = 'ltr';
if ($languageCode === 'ar') {
    $langDirection = 'rtl';
} elseif (isset($langData['meta']['direction']) && $langData['meta']['direction'] === 'rtl') {
    $langDirection = 'rtl';
}
?>
<html lang="<?php echo $languageCode; ?>" dir="<?php echo $langDirection; ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $settings['site_title'] ?? 'Dijital Menü'; ?></title>
    
    <!-- Favicon -->
    <?php if (!empty($settings['favicon'])): ?>
    <link rel="shortcut icon" href="assets/img/<?php echo $settings['favicon']; ?>" type="image/x-icon">
    <?php endif; ?>
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    
    <!-- Özel CSS Değişkenleri -->
    <style>
        :root {
            /* Ana Renkler */
            --primary-color: <?php echo $settings['primary_color'] ?? '#3490dc'; ?>;
            --secondary-color: <?php echo $settings['secondary_color'] ?? '#38c172'; ?>;
            --text-color: <?php echo $settings['text_color'] ?? '#333333'; ?>;
            --background-color: <?php echo $settings['background_color'] ?? '#ffffff'; ?>;
            
            /* Menü Başlık */
            --header-bg-color: <?php echo $settings['header_bg_color'] ?? '#333333'; ?>;
            --header-text-color: <?php echo $settings['header_text_color'] ?? '#ffffff'; ?>;
            
            /* Kategori Kartları */
            --category-card-bg: <?php echo $settings['category_card_bg'] ?? '#f8f8f8'; ?>;
            --category-card-text: <?php echo $settings['category_card_text'] ?? '#ffffff'; ?>;
            --category-card-gradient-start: <?php echo $settings['category_card_gradient_start'] ?? 'rgba(0, 0, 0, 0.7)'; ?>;
            --category-card-gradient-end: rgba(0, 0, 0, 0);
            
            /* Kategori Renkleri */
            --category-color-1: <?php echo $settings['category_color_1'] ?? '#F8D7A8'; ?>;
            --category-color-2: <?php echo $settings['category_color_2'] ?? '#F8C8A8'; ?>;
            --category-color-3: <?php echo $settings['category_color_3'] ?? '#A8F8D7'; ?>;
            --category-color-4: <?php echo $settings['category_color_4'] ?? '#A8C8F8'; ?>;
            --category-color-5: <?php echo $settings['category_color_5'] ?? '#D7A8F8'; ?>;
            
            /* Menü Öğeleri */
            --menu-item-bg-color: <?php echo $settings['menu_item_bg_color'] ?? '#ffffff'; ?>;
            --menu-item-title-color: <?php echo $settings['menu_item_title_color'] ?? '#333333'; ?>;
            --menu-item-desc-color: <?php echo $settings['menu_item_desc_color'] ?? '#666666'; ?>;
            --menu-item-border-color: <?php echo $settings['menu_item_border_color'] ?? '#f0f0f0'; ?>;
            --menu-item-price-color: <?php echo $settings['menu_item_price_color'] ?? '#3490dc'; ?>;
            --menu-item-price-bg: <?php echo $settings['menu_item_price_bg'] ?? 'rgba(52, 144, 220, 0.1)'; ?>;
            
            /* Alt Menü */
            --bottom-menu-color: <?php echo $settings['bottom_menu_color'] ?? '#ffffff'; ?>;
            --bottom-menu-item-color: <?php echo $settings['bottom_menu_item_color'] ?? '#777777'; ?>;
            
            /* İletişim Bilgileri */
            --contact-header-bg-color: <?php echo $settings['contact_header_bg_color'] ?? '#3490dc'; ?>;
            --contact-header-text-color: <?php echo $settings['contact_header_text_color'] ?? '#ffffff'; ?>;
            --contact-bg-color: <?php echo $settings['contact_bg_color'] ?? '#ffffff'; ?>;
            --contact-text-color: <?php echo $settings['contact_text_color'] ?? '#333333'; ?>;
            
            /* Buton Renkleri */
            --button-primary-hover-bg: <?php echo $settings['button_primary_hover_bg'] ?? '#2779bd'; ?>;
            --button-primary-hover-border: <?php echo $settings['button_primary_hover_border'] ?? '#2779bd'; ?>;
            --button-success-hover-bg: <?php echo $settings['button_success_hover_bg'] ?? '#2d995b'; ?>;
            --button-success-hover-border: <?php echo $settings['button_success_hover_border'] ?? '#2d995b'; ?>;
            
            /* Overlay Renkleri */
            --overlay-bg-color: <?php echo $settings['overlay_bg_color'] ?? 'rgba(0, 0, 0, 0.7)'; ?>;
            --overlay-content-bg: <?php echo $settings['overlay_content_bg'] ?? 'white'; ?>;
            --overlay-content-shadow: <?php echo $settings['overlay_content_shadow'] ?? 'rgba(0, 0, 0, 0.2)'; ?>;
            
            /* Sosyal Medya Bağlantıları */
            --social-link-bg: <?php echo $settings['social_link_bg'] ?? '#f5f5f5'; ?>;
            --social-link-hover-bg: <?php echo $settings['social_link_hover_bg'] ?? 'var(--primary-color)'; ?>;
            --social-link-hover-text: <?php echo $settings['social_link_hover_text'] ?? 'white'; ?>;
            
            /* Happy Hour Renkleri */
            --happy-hour-bg-color: <?php echo $settings['happy_hour_bg_color'] ?? '#FF9800'; ?>;
            --happy-hour-text-color: <?php echo $settings['happy_hour_text_color'] ?? '#FFFFFF'; ?>;
        }
    </style>
    
    <!-- Ana CSS -->
    <link href="assets/css/style.css" rel="stylesheet">
    <link href="assets/css/ratings.css" rel="stylesheet">
    <link href="assets/css/features.css" rel="stylesheet">
    <link href="assets/css/happy_hour.css" rel="stylesheet">
    <link href="assets/css/inline-styles.css" rel="stylesheet">
</head>
<body>
    <!-- Üst Menü -->
    <header class="menu-header">
        <div class="container">
            <div class="d-flex justify-content-between align-items-center">
                <div class="header-left">
                    <?php if (!empty($settings['logo'])): ?>
                    <img src="assets/img/<?php echo $settings['logo']; ?>" alt="<?php echo $settings['site_title'] ?? 'Dijital Menü'; ?>" class="site-logo">
                    <?php else: ?>
                    <h1 class="menu-title"><?php echo $settings['site_title'] ?? 'Dijital Menü'; ?></h1>
                    <?php endif; ?>
                    
                    <?php if (!empty($table)): ?>
                    <span class="table-info d-none d-sm-inline-block ms-2"><?php echo $translations['table']; ?>: <?php echo $table['name']; ?></span>
                    <?php endif; ?>
                </div>
                
                <div class="header-right">
                    <!-- Dil Seçici -->
                    <?php if (isset($settings['enable_multilingual']) && $settings['enable_multilingual'] == 1): ?>
                    <div class="dropdown language-selector">
                        <button class="btn btn-light dropdown-toggle" type="button" id="languageDropdown" data-bs-toggle="dropdown" aria-expanded="false">
                            <?php
                            $currentLanguage = '';
                            foreach ($languages as $code => $lang) {
                                if ($code === $languageCode) {
                                    $currentLanguage = $lang['name'];
                                    echo $lang['name'];
                                    break;
                                }
                            }
                            ?>
                        </button>
                        <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="languageDropdown">
                            <?php foreach ($languages as $code => $lang): ?>
                            <li>
                                <a class="dropdown-item <?php echo ($code === $languageCode) ? 'active' : ''; ?>" href="?lang=<?php echo $code; ?><?php echo (!empty($qrParam)) ? '&qr=' . $qrParam : (($tableId > 0) ? '&table_id=' . $tableId : ''); ?><?php echo ($categoryId > 0) ? '&category_id=' . $categoryId : ''; ?>" data-lang="<?php echo $code; ?>">
                                    <?php echo $lang['name']; ?>
                                </a>
                            </li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </header>
    
    <!-- Ana İçerik -->
    <main class="container-fluid p-0">
        <?php if (isset($settings['enable_slider']) && $settings['enable_slider'] == 1 && $categoryId == 0 && empty($searchQuery)): ?>
        <!-- Slider - Sadece ana sayfada göster -->
            <div class="slider-container" style="margin-top: 65px;">
            <div id="mainSlider" class="carousel slide" data-bs-ride="carousel" data-bs-interval="5000" data-bs-pause="hover">
                <div class="carousel-indicators">
                    <?php 
                    $sliders = getSliders(true);
                    $sliderCount = count($sliders);
                    for ($i = 0; $i < $sliderCount; $i++): 
                    ?>
                    <button type="button" data-bs-target="#mainSlider" data-bs-slide-to="<?php echo $i; ?>" <?php echo ($i === 0) ? 'class="active"' : ''; ?> aria-current="<?php echo ($i === 0) ? 'true' : 'false'; ?>" aria-label="Slide <?php echo $i + 1; ?>"></button>
                    <?php endfor; ?>
                </div>
                <div class="carousel-inner">
                    <?php 
                    foreach ($sliders as $index => $slider): 
                        $active = ($index === 0) ? 'active' : '';
                    ?>
                    <div class="carousel-item <?php echo $active; ?>">
                        <img src="assets/uploads/<?php echo $slider['image']; ?>" class="d-block w-100" alt="<?php echo htmlspecialchars($slider['title']); ?>">
                        <div class="carousel-caption d-none d-md-block">
                            <h5><?php echo htmlspecialchars($slider['title']); ?></h5>
                            <p><?php echo htmlspecialchars($slider['description']); ?></p>
                            <?php if (!empty($slider['link'])): ?>
                            <a href="<?php echo $slider['link']; ?>" class="btn btn-primary">Detaylar</a>
                            <?php endif; ?>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
                <?php if ($sliderCount > 1): ?>
                <button class="carousel-control-prev" type="button" data-bs-target="#mainSlider" data-bs-slide="prev">
                    <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                    <span class="visually-hidden">Önceki</span>
                </button>
                <button class="carousel-control-next" type="button" data-bs-target="#mainSlider" data-bs-slide="next">
                    <span class="carousel-control-next-icon" aria-hidden="true"></span>
                    <span class="visually-hidden">Sonraki</span>
                </button>
                <?php endif; ?>
            </div>
        </div>
        <?php endif; ?>
        
        <?php 
        // Happy Hour bileşenini dahil et
        include 'includes/happy_hour.php';
        ?>
        
        <?php if (!empty($searchQuery)): ?>
            <!-- Arama Sonuçları Sayfası -->
            <div class="container mt-2">
                <div class="d-flex align-items-center mb-3">
                    <a href="index.php?<?php echo (!empty($qrParam)) ? 'qr=' . $qrParam . '&' : (($tableId > 0) ? 'table_id=' . $tableId . '&' : ''); ?>lang=<?php echo $languageCode; ?>" class="btn btn-sm btn-light me-2">
                        <i class="fas fa-arrow-left"></i>
                    </a>
                    <h5 class="mb-0"><?php echo $translations['search']; ?>: "<?php echo htmlspecialchars($searchQuery); ?>"</h5>
                </div>
            </div>
            
            <!-- Arama Sonuçları -->
            <div class="container mt-4 menu-items-container">
                <div class="row">
                    <?php if (empty($items)): ?>
                    <div class="col-12">
                        <div class="alert alert-info">
                            <?php echo $translations['no_items_found']; ?>
                        </div>
                    </div>
                    <?php else: ?>
                    <?php foreach ($items as $item): ?>
                    <div class="col-md-6 col-lg-4 col-xl-3 mb-3 fade-in">
                        <div class="menu-item-horizontal">
                            <div class="menu-item-image-container">
                                <?php if (!empty($item['image'])): ?>
                                <img src="assets/uploads/<?php echo $item['image']; ?>" alt="<?php echo $item['name']; ?>" class="menu-item-image-horizontal">
                                <?php else: ?>
                                <img src="assets/img/no-image.jpg" alt="No Image" class="menu-item-image-horizontal">
                                <?php endif; ?>
                            </div>
                            
                            <div class="menu-item-content">
                                <div class="menu-item-header">
                                    <h3 class="menu-item-title">
                                        <?php 
                                        // Ürün adını çeviri varsa çeviriden, yoksa orijinalinden al
                                        $itemName = isset($itemTranslations[$item['id']]['name']) ? $itemTranslations[$item['id']]['name'] : $item['name'];
                                        echo $itemName;
                                        ?>
                                    </h3>
                                    
                                    <?php if (!empty($item['description'])): ?>
                                    <p class="menu-item-description">
                                        <?php 
                                        // Ürün açıklamasını çeviri varsa çeviriden, yoksa orijinalinden al
                                        $itemDescription = isset($itemTranslations[$item['id']]['description']) ? $itemTranslations[$item['id']]['description'] : $item['description'];
                                        echo $itemDescription;
                                        ?>
                                    </p>
                                    <?php endif; ?>
                                </div>
                                
                                <div class="menu-item-footer">
                                    <div class="menu-item-price-container">
                                        <div class="menu-item-price"><?php echo formatMoney($item['price']); ?></div>
                                    </div>
                                    
                                    <div class="menu-item-badges-container">
                                        <div class="menu-item-badges">
                                            <?php if (isset($settings['enable_ratings']) && $settings['enable_ratings'] == 1): ?>
                                            <?php 
                                                // Ürünün ortalama puanını ve puanlama sayısını al
                                                $averageRating = getItemAverageRating($item['id']);
                                                $ratingCount = getItemRatingCount($item['id']);
                                                
                                                if ($averageRating !== null):
                                            ?>
                                            <div class="menu-item-rating" data-item-id="<?php echo $item['id']; ?>">
                                                <div class="rating-summary">
                                                    <span class="rating-average"><?php echo $averageRating; ?></span>
                                                    <?php echo generateStarRating($averageRating); ?>
                                                    <span class="rating-count">(<?php echo $ratingCount; ?>)</span>
                                                </div>
                                                <button type="button" class="btn-show-ratings" data-item-id="<?php echo $item['id']; ?>">
                                                    Yorumları Gör / Puan Ver
                                                </button>
                                            </div>
                                            <?php endif; ?>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="features-allergens-container">
                                    <?php
                                    // Özellikler etkinse göster
                                    if (isset($settings['enable_item_features']) && $settings['enable_item_features'] == 1):
                                        // Menü öğesinin özelliklerini al
                                        $resultFeatures = $conn->query("SELECT f.* FROM features f JOIN item_features itf ON f.id = itf.feature_id WHERE itf.item_id = " . $item['id'] . " AND f.status = 1");
                                        if ($resultFeatures->num_rows > 0):
                                    ?>
                                    <div class="menu-item-features">
                                        <div class="features-container">
                                            <?php while ($featureRow = $resultFeatures->fetch_assoc()): ?>
                                            <span class="badge menu-item-badge" style="background-color: <?php echo $featureRow['color']; ?>;" data-bs-toggle="tooltip" title="<?php echo $featureRow['name']; ?>">
                                                <?php if (!empty($featureRow['icon'])): ?>
                                                <?php 
                                                // Eğer ikon zaten fa- ile başlıyorsa, tekrar ekleme
                                                $iconClass = strpos($featureRow['icon'], 'fa-') === 0 ? $featureRow['icon'] : 'fa-' . $featureRow['icon'];
                                                ?>
                                                <i class="fas <?php echo $iconClass; ?>"></i>
                                                <?php endif; ?>
                                            </span>
                                            <?php endwhile; ?>
                                        </div>
                                    </div>
                                    <?php 
                                        endif;
                                    endif; 
                                    ?>
                                    
                                    <?php
                                    // Alerjenler etkinse göster
                                    if (isset($settings['enable_allergens']) && $settings['enable_allergens'] == 1):
                                        // Menü öğesinin alerjenlerini al
                                        $itemAllergens = getItemAllergens($item['id']);
                                        if (!empty($itemAllergens)):
                                    ?>
                                    <div class="menu-item-allergens">
                                        <small class="allergens-title"><?php echo strtoupper($translations['allergens']); ?>:</small>
                                        <div class="allergens-container">
                                            <?php foreach ($itemAllergens as $allergen): ?>
                                            <div class="allergen-badge">
                                                <?php if (!empty($allergen['icon'])): ?>
                                                <img src="assets/img/<?php echo $allergen['icon']; ?>" alt="<?php echo $allergen['name']; ?>">
                                                <?php endif; ?>
                                                <?php 
                                                // Alerjen adını çeviri varsa çeviriden, yoksa orijinalinden al
                                                $allergenName = isset($allergenTranslations[$allergen['id']]['name']) ? $allergenTranslations[$allergen['id']]['name'] : $allergen['name'];
                                                echo $allergenName;
                                                ?>
                                            </div>
                                            <?php endforeach; ?>
                                        </div>
                                    </div>
                                    <?php 
                                        endif;
                                    endif; 
                                    ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                    <?php endif; ?>
                </div>
            </div>
        <?php elseif ($categoryId > 0): ?>
            <!-- Kategori Detay Sayfası -->
            <div class="container mt-2">
                <div class="d-flex align-items-center mb-3">
                    <a href="index.php?<?php echo (!empty($qrParam)) ? 'qr=' . $qrParam . '&' : (($tableId > 0) ? 'table_id=' . $tableId . '&' : ''); ?>lang=<?php echo $languageCode; ?>" class="btn btn-sm btn-light me-2">
                        <i class="fas fa-arrow-left"></i>
                    </a>
                    <?php 
                    // Kategori adını çeviri varsa çeviriden, yoksa orijinalinden al
                    $currentCategory = null;
                    foreach ($categories as $cat) {
                        if ($cat['id'] === $categoryId) {
                            $currentCategory = $cat;
                            break;
                        }
                    }
                    
                    if ($currentCategory) {
                        $categoryName = isset($categoryTranslations[$currentCategory['id']]['name']) ? $categoryTranslations[$currentCategory['id']]['name'] : $currentCategory['name'];
                        echo '<h5 class="mb-0">' . $categoryName . '</h5>';
                    }
                    ?>
                </div>
            </div>
            
            <!-- Menü Öğeleri -->
            <div class="container mt-4 menu-items-container">
                <div class="row">
                    <?php if (empty($items)): ?>
                    <div class="col-12">
                        <div class="alert alert-info">
                            <?php echo $translations['no_items_found']; ?>
                        </div>
                    </div>
                    <?php else: ?>
                    <?php foreach ($items as $item): ?>
                    <div class="col-12 mb-3 fade-in">
                        <div class="menu-item-horizontal">
                            <div class="menu-item-image-container">
                                <?php if (!empty($item['image'])): ?>
                                <img src="assets/uploads/<?php echo $item['image']; ?>" alt="<?php echo $item['name']; ?>" class="menu-item-image-horizontal">
                                <?php else: ?>
                                <img src="assets/img/no-image.jpg" alt="No Image" class="menu-item-image-horizontal">
                                <?php endif; ?>
                            </div>
                            
                            <div class="menu-item-content">
                                <div class="menu-item-header">
                                    <h3 class="menu-item-title">
                                        <?php 
                                        // Ürün adını çeviri varsa çeviriden, yoksa orijinalinden al
                                        $itemName = isset($itemTranslations[$item['id']]['name']) ? $itemTranslations[$item['id']]['name'] : $item['name'];
                                        echo $itemName;
                                        ?>
                                    </h3>
                                    
                                    <?php if (!empty($item['description'])): ?>
                                    <p class="menu-item-description">
                                        <?php 
                                        // Ürün açıklamasını çeviri varsa çeviriden, yoksa orijinalinden al
                                        $itemDescription = isset($itemTranslations[$item['id']]['description']) ? $itemTranslations[$item['id']]['description'] : $item['description'];
                                        echo $itemDescription;
                                        ?>
                                    </p>
                                    <?php endif; ?>
                                </div>
                                
                                <div class="menu-item-footer">
                                    <div class="menu-item-price-container">
                                        <div class="menu-item-price"><?php echo formatMoney($item['price']); ?></div>
                                    </div>
                                    
                                    <div class="menu-item-badges-container">
                                        <div class="menu-item-badges">
                                            <?php if (isset($settings['enable_ratings']) && $settings['enable_ratings'] == 1): ?>
                                            <?php 
                                                // Ürünün ortalama puanını ve puanlama sayısını al
                                                $averageRating = getItemAverageRating($item['id']);
                                                $ratingCount = getItemRatingCount($item['id']);
                                                
                                                if ($averageRating !== null):
                                            ?>
                                            <div class="menu-item-rating" data-item-id="<?php echo $item['id']; ?>">
                                                <div class="rating-summary">
                                                    <span class="rating-average"><?php echo $averageRating; ?></span>
                                                    <?php echo generateStarRating($averageRating); ?>
                                                    <span class="rating-count">(<?php echo $ratingCount; ?>)</span>
                                                </div>
                                                <button type="button" class="btn-show-ratings" data-item-id="<?php echo $item['id']; ?>">
                                                    Yorumları Gör / Puan Ver
                                                </button>
                                            </div>
                                            <?php endif; ?>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="features-allergens-container">
                                    <?php
                                    // Özellikler etkinse göster
                                    if (isset($settings['enable_item_features']) && $settings['enable_item_features'] == 1):
                                        // Menü öğesinin özelliklerini al
                                        $resultFeatures = $conn->query("SELECT f.* FROM features f JOIN item_features itf ON f.id = itf.feature_id WHERE itf.item_id = " . $item['id'] . " AND f.status = 1");
                                        if ($resultFeatures->num_rows > 0):
                                    ?>
                                    <div class="menu-item-features">
                                        <div class="features-container">
                                            <?php while ($featureRow = $resultFeatures->fetch_assoc()): ?>
                                            <span class="badge menu-item-badge" style="background-color: <?php echo $featureRow['color']; ?>;" data-bs-toggle="tooltip" title="<?php echo $featureRow['name']; ?>">
                                                <?php if (!empty($featureRow['icon'])): ?>
                                                <?php 
                                                // Eğer ikon zaten fa- ile başlıyorsa, tekrar ekleme
                                                $iconClass = strpos($featureRow['icon'], 'fa-') === 0 ? $featureRow['icon'] : 'fa-' . $featureRow['icon'];
                                                ?>
                                                <i class="fas <?php echo $iconClass; ?>"></i>
                                                <?php endif; ?>
                                            </span>
                                            <?php endwhile; ?>
                                        </div>
                                    </div>
                                    <?php 
                                        endif;
                                    endif; 
                                    ?>
                                    
                                    <?php
                                    // Alerjenler etkinse göster
                                    if (isset($settings['enable_allergens']) && $settings['enable_allergens'] == 1):
                                        // Menü öğesinin alerjenlerini al
                                        $itemAllergens = getItemAllergens($item['id']);
                                        if (!empty($itemAllergens)):
                                    ?>
                                    <div class="menu-item-allergens">
                                        <small class="allergens-title"><?php echo $translations['allergens']; ?>:</small>
                                        <div class="allergens-container">
                                            <?php foreach ($itemAllergens as $allergen): ?>
                                            <div class="allergen-badge">
                                                <?php if (!empty($allergen['icon'])): ?>
                                                <img src="assets/img/<?php echo $allergen['icon']; ?>" alt="<?php echo $allergen['name']; ?>">
                                                <?php endif; ?>
                                                <?php 
                                                // Alerjen adını çeviri varsa çeviriden, yoksa orijinalinden al
                                                $allergenName = isset($allergenTranslations[$allergen['id']]['name']) ? $allergenTranslations[$allergen['id']]['name'] : $allergen['name'];
                                                echo $allergenName;
                                                ?>
                                            </div>
                                            <?php endforeach; ?>
                                        </div>
                                    </div>
                                    <?php 
                                        endif;
                                    endif; 
                                    ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                    <?php endif; ?>
                </div>
            </div>
        <?php else: ?>
            <!-- Ana Sayfa - Kategoriler Grid -->
            <div class="category-grid-container" style="margin-top: 0; padding-top: 0;">
                <?php if (empty($categories)): ?>
                    <div class="alert alert-info">Henüz kategori bulunmamaktadır.</div>
                <?php else: ?>
                    <div class="category-grid">
                        <?php 
                        // Tüm kategorileri göster
                        foreach ($categories as $category): 
                            // Kategori adını çeviri varsa çeviriden, yoksa orijinalinden al
                            $categoryName = isset($categoryTranslations[$category['id']]['name']) ? $categoryTranslations[$category['id']]['name'] : $category['name'];
                            
                            // Kategori görseli - kategorinin kendi resmi veya varsayılan
                            $categoryImage = !empty($category['image']) ? $category['image'] : '67f0268f4c06f.jpg';
                        ?>
                        <a href="index.php?category_id=<?php echo $category['id']; ?><?php echo (!empty($qrParam)) ? '&qr=' . $qrParam : (($tableId > 0) ? '&table_id=' . $tableId : ''); ?>&lang=<?php echo $languageCode; ?>" 
                           class="category-card">
                            <div class="category-card-image">
                                <img src="assets/img/<?php echo $categoryImage; ?>" alt="<?php echo $categoryName; ?>">
                            </div>
                            <div class="category-card-content">
                                <div class="category-card-name"><?php echo $categoryName; ?></div>
                            </div>
                        </a>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
            </div>
        <?php endif; ?>
    </main>
    
    <!-- Footer kaldırıldı -->
    
    <!-- Overlay Sidebar -->
    <div class="overlay-sidebar" id="overlaySidebar">
        <div class="overlay-sidebar-header">
            <h3><?php echo $translations['contact']; ?></h3>
            <button type="button" class="btn-close" onclick="toggleSidebar()"></button>
        </div>
        <div class="overlay-sidebar-content">
            <?php if (!empty($settings['contact_info'])): ?>
            <div class="sidebar-section">
                <h4><i class="fas fa-address-book"></i> <?php echo __('site.contact', [], $languageCode); ?></h4>
                <div class="contact-info">
                    <?php echo nl2br($settings['contact_info']); ?>
                </div>
            </div>
            <?php endif; ?>
            
            <?php if (!empty($settings['wifi_password'])): ?>
            <div class="sidebar-section">
                <h4><i class="fas fa-wifi"></i> WiFi</h4>
                <button class="btn btn-outline-primary wifi-button" onclick="showWifiPassword()">
                    <i class="fas fa-key"></i> <?php echo __('site.show_wifi_password', [], $languageCode); ?>
                </button>
                <div id="wifiPasswordContainer" class="wifi-password-container" style="display: none;">
                    <div class="wifi-info">
                        <p><strong><?php echo __('site.wifi_name', [], $languageCode); ?>:</strong> <?php echo $settings['wifi_name'] ?? 'Restaurant WiFi'; ?></p>
                        <p><strong><?php echo __('site.wifi_password', [], $languageCode); ?>:</strong> <?php echo $settings['wifi_password']; ?></p>
                    </div>
                </div>
            </div>
            <?php endif; ?>
            
            <?php if (!empty($settings['social_media'])): ?>
            <div class="sidebar-section">
                <h4><i class="fas fa-share-alt"></i> <?php echo __('site.social_media', [], $languageCode); ?></h4>
                <div class="social-media-links">
                    <?php 
                    $socialMedia = json_decode($settings['social_media'], true);
                    if (is_array($socialMedia)):
                        foreach ($socialMedia as $platform => $url):
                            if (empty($url)) continue;
                            
                            $icon = '';
                            switch ($platform) {
                                case 'facebook': $icon = 'fab fa-facebook'; break;
                                case 'instagram': $icon = 'fab fa-instagram'; break;
                                case 'twitter': $icon = 'fab fa-twitter'; break;
                                case 'youtube': $icon = 'fab fa-youtube'; break;
                                default: $icon = 'fas fa-link'; break;
                            }
                    ?>
                    <a href="<?php echo $url; ?>" target="_blank" class="social-link">
                        <i class="<?php echo $icon; ?>"></i> <?php echo ucfirst($platform); ?>
                    </a>
                    <?php 
                        endforeach;
                    endif;
                    ?>
                </div>
            </div>
            <?php endif; ?>
        </div>
    </div>
    
    <!-- Bottom Menu -->
    <div class="bottom-menu">
        <div class="bottom-menu-item <?php echo (empty($_GET['active']) || $_GET['active'] === 'menu') ? 'active' : ''; ?>" onclick="window.location.href='index.php?<?php echo (!empty($qrParam)) ? 'qr=' . $qrParam : (($tableId > 0) ? 'table_id=' . $tableId : ''); ?>&lang=<?php echo $languageCode; ?>'">
            <i class="fas fa-home"></i>
            <span><?php echo $translations['home']; ?></span>
        </div>
        
        <?php if ($accessedViaQr && isset($settings['enable_waiter_call']) && $settings['enable_waiter_call'] == 1): ?>
        <div class="bottom-menu-item <?php echo (!empty($_GET['active']) && $_GET['active'] === 'waiter') ? 'active' : ''; ?>" onclick="callWaiter()" data-table-id="<?php echo $tableId; ?>" data-language="<?php echo $languageCode; ?>">
            <i class="fas fa-bell"></i>
            <span><?php echo $translations['call_waiter']; ?></span>
        </div>
        <?php endif; ?>
        
        <div class="bottom-menu-item <?php echo (!empty($_GET['active']) && $_GET['active'] === 'info') ? 'active' : ''; ?>" onclick="toggleInfo()">
            <i class="fas fa-info-circle"></i>
            <span><?php echo $translations['info']; ?></span>
        </div>
        
        <div class="bottom-menu-item <?php echo (!empty($_GET['active']) && $_GET['active'] === 'search') ? 'active' : ''; ?>" onclick="toggleSearch()">
            <i class="fas fa-search"></i>
            <span><?php echo $translations['search']; ?></span>
        </div>
    </div>
    
    <!-- Overlay Arka Planı -->
    <div class="overlay-background" id="overlayBackground"></div>
    
    <!-- Info Sidebar Overlay -->
    <div class="info-sidebar-overlay" id="infoOverlay">
        <div class="info-sidebar-content">
            <div class="info-sidebar-header">
                <h3><?php echo $translations['info']; ?></h3>
                <button type="button" class="btn-close" onclick="toggleInfo()">×</button>
            </div>
            <div class="info-sidebar-body" style="background-color: var(--contact-bg-color); color: var(--contact-text-color);">
                <!-- İletişim Bilgileri -->
                <?php if (!empty($settings['contact_info'])): ?>
                <div class="info-section">
                    <h4 style="color: var(--contact-text-color);"><i class="fas fa-address-book" style="color: var(--primary-color);"></i> <?php echo $translations['contact']; ?></h4>
                    <div class="contact-info" style="color: var(--contact-text-color);">
                        <?php echo nl2br($settings['contact_info']); ?>
                    </div>
                </div>
                <?php endif; ?>
                
                <!-- WiFi Bilgileri -->
                <?php if (!empty($settings['wifi_name']) || !empty($settings['wifi_password'])): ?>
                <div class="info-section">
                    <h4 style="color: var(--contact-text-color);"><i class="fas fa-wifi" style="color: var(--primary-color);"></i> WiFi</h4>
                    <div class="wifi-info mt-2">
                        <?php if (!empty($settings['wifi_name'])): ?>
                        <div class="wifi-detail">
                            <i class="fas fa-network-wired"></i>
                            <span><strong><?php echo $translations['wifi_name']; ?>:</strong> <?php echo $settings['wifi_name']; ?></span>
                        </div>
                        <?php endif; ?>
                        
                        <?php if (!empty($settings['wifi_password'])): ?>
                        <div class="wifi-detail">
                            <i class="fas fa-key"></i>
                            <span><strong><?php echo $translations['wifi_password']; ?>:</strong> <?php echo $settings['wifi_password']; ?></span>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
                <?php endif; ?>
                
                <?php if (!empty($settings['google_maps_review_link'])): ?>
                <div class="info-section">
                    <h4 style="color: var(--contact-text-color);"><i class="fas fa-star" style="color: var(--primary-color);"></i> <?php echo __('admin.google_maps_review', [], $languageCode); ?></h4>
                    <div class="mt-2">
                        <a href="<?php echo $settings['google_maps_review_link']; ?>" target="_blank" class="google-review-link">
                            <div class="google-review-card">
                                <div class="google-logo">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                                        <path fill="#4285F4" d="M22.56 12.25c0-.78-.07-1.53-.2-2.25H12v4.26h5.92c-.26 1.37-1.04 2.53-2.21 3.31v2.77h3.57c2.08-1.92 3.28-4.74 3.28-8.09z"/>
                                        <path fill="#34A853" d="M12 23c2.97 0 5.46-.98 7.28-2.66l-3.57-2.77c-.98.66-2.23 1.06-3.71 1.06-2.86 0-5.29-1.93-6.16-4.53H2.18v2.84C3.99 20.53 7.7 23 12 23z"/>
                                        <path fill="#FBBC05" d="M5.84 14.09c-.22-.66-.35-1.36-.35-2.09s.13-1.43.35-2.09V7.07H2.18C1.43 8.55 1 10.22 1 12s.43 3.45 1.18 4.93l2.85-2.22.81-.62z"/>
                                        <path fill="#EA4335" d="M12 5.38c1.62 0 3.06.56 4.21 1.64l3.15-3.15C17.45 2.09 14.97 1 12 1 7.7 1 3.99 3.47 2.18 7.07l3.66 2.84c.87-2.6 3.3-4.53 6.16-4.53z"/>
                                    </svg>
                                    <span class="rating-text">5.0</span>
                                </div>
                                <div class="stars">
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                </div>
                            </div>
                        </a>
                    </div>
                </div>
                <?php endif; ?>
                
                <!-- Sosyal Medya Linkleri -->
                <?php 
                $socialMedia = !empty($settings['social_media']) ? json_decode($settings['social_media'], true) : [];
                $hasSocialMedia = false;
                
                foreach ($socialMedia as $url) {
                    if (!empty($url)) {
                        $hasSocialMedia = true;
                        break;
                    }
                }
                
                if ($hasSocialMedia):
                ?>
                <div class="info-section">
                    <h4 style="color: var(--contact-text-color);"><i class="fas fa-share-alt" style="color: var(--primary-color);"></i> <?php echo $translations['social_media']; ?></h4>
                    <div class="social-media-links">
                        <?php 
                        foreach ($socialMedia as $platform => $url):
                            if (empty($url)) continue;
                            
                            $icon = '';
                            $label = '';
                            switch ($platform) {
                                case 'facebook': 
                                    $icon = 'fab fa-facebook'; 
                                    $label = 'Facebook';
                                    break;
                                case 'instagram': 
                                    $icon = 'fab fa-instagram'; 
                                    $label = 'Instagram';
                                    break;
                                case 'twitter': 
                                    $icon = 'fab fa-twitter'; 
                                    $label = 'Twitter';
                                    break;
                                case 'youtube': 
                                    $icon = 'fab fa-youtube'; 
                                    $label = 'Youtube';
                                    break;
                                default: 
                                    $icon = 'fas fa-link'; 
                                    $label = ucfirst($platform);
                                    break;
                            }
                        ?>
                        <a href="<?php echo $url; ?>" target="_blank" class="social-link">
                            <i class="<?php echo $icon; ?>"></i>
                        </a>
                        <?php endforeach; ?>
                    </div>
                </div>
                <?php endif; ?>
                
                <?php if (isset($settings['enable_feedback']) && $settings['enable_feedback'] == 1): ?>
                <!-- Geri Bildirim Accordion -->
                <div class="info-section">
                    <div class="accordion-header" id="feedbackAccordionHeader">
                        <h4 style="color: var(--contact-text-color); display: flex; align-items: center; justify-content: space-between;">
                            <span>
                                <i class="fas fa-comment-alt" style="color: var(--primary-color);"></i> 
                                Geri Bildirim
                            </span>
                            <i class="fas fa-chevron-down accordion-icon"></i>
                        </h4>
                    </div>
                    <div class="accordion-content" id="feedbackAccordionContent">
                        <div class="feedback-form mt-3">
                            <form id="feedbackForm">
                                <input type="hidden" name="csrf_token" value="<?php echo $_SESSION['csrf_token'] ?? ''; ?>">
                                
                                <div class="mb-3">
                                    <label for="feedbackName" class="form-label">Adınız (İsteğe bağlı)</label>
                                    <input type="text" class="form-control" id="feedbackName" name="name" placeholder="Adınız">
                                </div>
                                
                                <div class="mb-3">
                                    <label for="feedbackMessage" class="form-label">Mesajınız</label>
                                    <textarea class="form-control" id="feedbackMessage" name="message" rows="4" placeholder="Mesajınızı buraya yazın" required></textarea>
                                </div>
                                
                                <div class="d-grid">
                                    <button type="submit" class="btn btn-primary">Gönder</button>
                                </div>
                                
                                <div id="feedbackResult" class="mt-3"></div>
                            </form>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
    
    
    <!-- Mobile Search Overlay -->
    <div class="search-overlay" id="searchOverlay">
        <div class="search-overlay-content">
            <form action="index.php" method="get" id="searchForm">
                <div class="input-group">
                    <input type="text" class="form-control" id="searchInput" placeholder="<?php echo $translations['search_placeholder']; ?>" name="search" value="<?php echo htmlspecialchars($searchQuery); ?>">
                    <button class="btn btn-primary" type="submit">
                        <i class="fas fa-search"></i>
                    </button>
                    <button class="btn btn-secondary" type="button" onclick="toggleSearch()">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
                <?php if (!empty($qrParam)): ?>
                <input type="hidden" name="qr" value="<?php echo $qrParam; ?>">
                <?php elseif ($tableId > 0): ?>
                <input type="hidden" name="table_id" value="<?php echo $tableId; ?>">
                <?php endif; ?>
                <input type="hidden" name="lang" value="<?php echo $languageCode; ?>">
            </form>
        </div>
    </div>
    
    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    
    <!-- Ana JS -->
    <script src="assets/js/script.js"></script>
    <script src="assets/js/ratings.js"></script>
    <script src="assets/js/feedback.js"></script>
    
    <!-- Info Sidebar JS -->
    <script>
        // Sayfa yüklendiğinde çalışacak fonksiyonlar
        document.addEventListener('DOMContentLoaded', function() {
            console.log('DOM yüklendi, sidebar fonksiyonları başlatılıyor...');
            
            // Overlay arka planı
            const overlayBackground = document.getElementById('overlayBackground');
            
            // Info Overlay
            const infoOverlay = document.getElementById('infoOverlay');
            
            // Kapatma butonu
            const closeButton = document.querySelector('.info-sidebar-header .btn-close');
            
            // Info butonuna tıklandığında sidebar'ı aç
            const infoButton = document.querySelector('.bottom-menu-item[onclick*="toggleInfo"]');
            if (infoButton) {
                infoButton.onclick = function(e) {
                    e.preventDefault();
                    openInfoOverlay();
                };
            }
            
            // Info Overlay'ı aç
            function openInfoOverlay() {
                if (infoOverlay) {
                    infoOverlay.classList.add('active');
                    overlayBackground.classList.add('active');
                    document.body.style.overflow = 'hidden';
                    
                    // Aktif buton değiştir
                    if (typeof setActiveButton === 'function') {
                        setActiveButton('info');
                    }
                }
            }
            
            // Info Overlay'ı kapat
            function closeInfoOverlay() {
                if (infoOverlay) {
                    infoOverlay.classList.remove('active');
                    overlayBackground.classList.remove('active');
                    document.body.style.overflow = '';
                }
            }
            
            // Arka plana tıklandığında overlay'ı kapat
            if (overlayBackground) {
                overlayBackground.addEventListener('click', closeInfoOverlay);
            }
            
            // Kapatma butonuna tıklandığında overlay'ı kapat
            if (closeButton) {
                closeButton.addEventListener('click', closeInfoOverlay);
            }
            
            // Swipe ile sidebar'ı kapatma (sağdan sola kaydırma)
            if (infoOverlay) {
                let startX, currentX;
                let isDragging = false;
                
                infoOverlay.addEventListener('touchstart', function(e) {
                    startX = e.touches[0].clientX;
                    isDragging = true;
                });
                
                document.addEventListener('touchmove', function(e) {
                    if (!isDragging || !infoOverlay.classList.contains('active')) return;
                    
                    currentX = e.touches[0].clientX;
                    const diff = startX - currentX;
                    
                    // Sağdan sola kaydırma - sidebar'ı kapat
                    if (diff > 50) {
                        closeInfoOverlay();
                        isDragging = false;
                    }
                });
                
                document.addEventListener('touchend', function() {
                    isDragging = false;
                });
            }
            
            // Accordion işlevselliği
            const accordionHeader = document.getElementById('feedbackAccordionHeader');
            const accordionContent = document.getElementById('feedbackAccordionContent');
            
            if (accordionHeader && accordionContent) {
                // Accordion içeriğini başlangıçta gizle
                accordionContent.style.display = 'none';
                
                // Accordion başlığına tıklandığında içeriği göster/gizle
                accordionHeader.addEventListener('click', function(e) {
                    e.preventDefault();
                    e.stopPropagation();
                    
                    this.classList.toggle('active');
                    
                    // jQuery slideToggle yerine manuel kontrol
                    if (this.classList.contains('active')) {
                        // Açılma animasyonu
                        setTimeout(function() {
                            accordionContent.style.display = 'block';
                        }, 50);
                    } else {
                        // Kapanma animasyonu
                        accordionContent.style.display = 'none';
                    }
                });
            }
            
            // URL'de active=info parametresi varsa info overlay'ı aç
            const urlParams = new URLSearchParams(window.location.search);
            if (urlParams.get('active') === 'info') {
                setTimeout(openInfoOverlay, 500);
            }
            
            // Global toggleInfo fonksiyonu
            window.toggleInfo = function() {
                if (infoOverlay.classList.contains('active')) {
                    closeInfoOverlay();
                } else {
                    openInfoOverlay();
                }
            };
        });
    </script>
    
    
    <!-- Puanlama Modalları -->
    <?php if (isset($settings['enable_ratings']) && $settings['enable_ratings'] == 1): ?>
    <?php foreach ($items as $item): ?>
    <div class="rating-modal" id="ratingModal-<?php echo $item['id']; ?>">
        <div class="rating-modal-content">
            <span class="rating-modal-close">&times;</span>
            <h3 class="rating-modal-title">
                <?php 
                // Ürün adını çeviri varsa çeviriden, yoksa orijinalinden al
                $itemName = isset($itemTranslations[$item['id']]['name']) ? $itemTranslations[$item['id']]['name'] : $item['name'];
                echo $itemName;
                ?>
            </h3>
            
            <?php 
            // Ürünün ortalama puanını ve puanlama sayısını al
            $averageRating = getItemAverageRating($item['id']);
            $ratingCount = getItemRatingCount($item['id']);
            ?>
            
            <div class="rating-summary mb-3">
                <?php if ($averageRating !== null): ?>
                <span class="rating-average"><?php echo $averageRating; ?></span>
                <div class="star-rating star-rating-lg">
                    <?php echo generateStarRating($averageRating); ?>
                </div>
                <span class="rating-count">(<?php echo $ratingCount; ?>)</span>
                <?php else: ?>
                <p>Bu ürün henüz puanlanmamış.</p>
                <?php endif; ?>
            </div>
            
            <!-- Puanlama Listesi -->
            <div class="ratings-list">
                <?php 
                // Ürünün puanlamalarını al
                $ratings = getItemRatings($item['id']);
                if (!empty($ratings)):
                    foreach ($ratings as $rating):
                ?>
                <div class="rating-item">
                    <div class="d-flex align-items-center">
                        <div class="user-name"><?php echo htmlspecialchars($rating['user_name']); ?></div>
                        <div class="rating-date"><?php echo formatDate($rating['created_at']); ?></div>
                    </div>
                    <div class="star-rating">
                        <?php echo generateStarRating($rating['rating']); ?>
                    </div>
                    <?php if (!empty($rating['comment'])): ?>
                    <div class="rating-comment">
                        <?php echo nl2br(htmlspecialchars($rating['comment'])); ?>
                    </div>
                    <?php endif; ?>
                </div>
                <?php 
                    endforeach;
                else:
                ?>
                <div class="alert alert-info">
                    Henüz yorum yapılmamış. İlk yorumu siz yapın!
                </div>
                <?php endif; ?>
            </div>
            
            <!-- Puanlama Formu -->
            <div class="rating-form mt-4">
                <h5>Puanınızı ve Yorumunuzu Ekleyin</h5>
                <form action="javascript:void(0);" method="post">
                    <input type="hidden" name="item_id" value="<?php echo $item['id']; ?>">
                    
                    <div class="mb-3">
                        <label class="form-label">Puanınız</label>
                        <div class="rating-selector">
                            <?php for ($i = 5; $i >= 1; $i--): ?>
                            <input type="radio" id="star<?php echo $i; ?>-<?php echo $item['id']; ?>" name="rating" value="<?php echo $i; ?>">
                            <label for="star<?php echo $i; ?>-<?php echo $item['id']; ?>"><i class="fas fa-star"></i></label>
                            <?php endfor; ?>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label for="comment-<?php echo $item['id']; ?>" class="form-label">Yorumunuz (İsteğe bağlı)</label>
                        <textarea class="form-control" id="comment-<?php echo $item['id']; ?>" name="comment" rows="3"></textarea>
                    </div>
                    
                    <button type="submit" class="btn btn-rating">Gönder</button>
                </form>
            </div>
        </div>
    </div>
    <?php endforeach; ?>
    <?php endif; ?>
</body>
</html>
