<?php
/**
 * Dijital Menü - Garson Çağırma Modülü
 */

// İstanbul saatini ayarla
date_default_timezone_set('Europe/Istanbul');

// Gerekli dosyaları dahil et
require_once '../../includes/functions.php';
require_once '../../includes/language.php';

// Ayarları al
$settings = getSetting();

// Garson çağırma özelliği aktif mi kontrol et
if (!isset($settings['enable_waiter_call']) || $settings['enable_waiter_call'] != 1) {
    die('Bu özellik devre dışı bırakılmıştır.');
}

// QR kod parametresini kontrol et (yeni yöntem)
$qrParam = isset($_GET['qr']) ? clean($_GET['qr']) : (isset($_POST['qr']) ? clean($_POST['qr']) : '');
$accessedViaQr = !empty($qrParam);

// Masa ID'sini al
$tableId = 0;

if (!empty($qrParam)) {
    // Base64 kodunu çöz
    $decodedQr = base64_decode($qrParam);
    
    // "Table:ID" formatını kontrol et
    if (preg_match('/^Table:(\d+)$/', $decodedQr, $matches)) {
        $tableId = intval($matches[1]);
    }
} else {
    // Eski yöntem: table_id parametresini kontrol et
    $tableId = isset($_GET['table_id']) ? intval($_GET['table_id']) : (isset($_POST['table_id']) ? intval($_POST['table_id']) : 0);
}

// Dil ayarı
$languageCode = isset($_GET['lang']) ? clean($_GET['lang']) : (isset($_POST['lang']) ? clean($_POST['lang']) : ($settings['default_language'] ?? 'tr'));

// Masa bilgilerini al
$table = [];
$validTable = false;
$showQrMessage = false;

if ($tableId > 0) {
    $stmt = $conn->prepare("SELECT * FROM tables WHERE id = ?");
    $stmt->bind_param("i", $tableId);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows === 1) {
        $table = $result->fetch_assoc();
        $validTable = true;
        
        // Masa aktif değilse uyarı göster ama işleme devam et
        if ($table['status'] !== 'active') {
            if ($table['status'] === 'inactive') {
                $error = __('site.table_inactive', [], $languageCode);
            } elseif ($table['status'] === 'reserved') {
                $error = __('site.table_reserved', [], $languageCode);
            } else {
                $error = __('site.table_occupied', [], $languageCode);
            }
        }
    } else {
        $showQrMessage = true;
    }
} else {
    $showQrMessage = true;
}

// Çeviri metinleri
$translations = [
    'call_waiter' => __('site.call_waiter', [], $languageCode),
    'table' => __('site.table', [], $languageCode),
    'call_sent' => __('site.call_sent', [], $languageCode),
    'call_error' => __('site.call_error', [], $languageCode),
    'call_spam' => __('site.call_spam', [], $languageCode),
    'table_inactive' => __('site.table_inactive', [], $languageCode),
    'table_reserved' => __('site.table_reserved', [], $languageCode),
    'table_occupied' => __('site.table_occupied', [], $languageCode),
    'back_to_menu' => __('site.back_to_menu', [], $languageCode),
];

// Çağrı gönderme işlemi
$success = false;
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Son çağrıyı kontrol et (spam önleme)
    $stmt = $conn->prepare("SELECT COUNT(*) as count FROM waiter_calls WHERE table_id = ? AND status = 'pending' AND created_at > DATE_SUB(NOW(), INTERVAL 2 MINUTE)");
    $stmt->bind_param("i", $tableId);
    $stmt->execute();
    $result = $stmt->get_result();
    $row = $result->fetch_assoc();
    
    if ($row['count'] > 0) {
        $error = $translations['call_spam'];
    } else {
        // Çağrı türünü al
        $callType = isset($_POST['call_type']) ? clean($_POST['call_type']) : 'waiter';
        
        // Çağrı oluştur
        if (callWaiter($tableId, $callType)) {
            $success = true;
        } else {
            $error = $translations['call_error'];
        }
    }
}
?>
<!DOCTYPE html>
<?php
// Dil yönünü kontrol et
$langDirection = 'ltr';
if ($languageCode === 'ar') {
    $langDirection = 'rtl';
} elseif (isset($langData['meta']['direction']) && $langData['meta']['direction'] === 'rtl') {
    $langDirection = 'rtl';
}
?>
<html lang="<?php echo $languageCode; ?>" dir="<?php echo $langDirection; ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $translations['call_waiter']; ?> | <?php echo $settings['site_title'] ?? 'Dijital Menü'; ?></title>
    
    <!-- Favicon -->
    <?php if (!empty($settings['favicon'])): ?>
    <link rel="shortcut icon" href="../../assets/img/<?php echo $settings['favicon']; ?>" type="image/x-icon">
    <?php endif; ?>
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    
    <!-- Ana CSS -->
    <link href="../../assets/css/style.css" rel="stylesheet">
    
    <!-- Özel Renkler -->
    <style>
        :root {
            --primary-color: <?php echo $settings['primary_color'] ?? '#3490dc'; ?>;
            --secondary-color: <?php echo $settings['secondary_color'] ?? '#38c172'; ?>;
            --text-color: <?php echo $settings['text_color'] ?? '#333333'; ?>;
            --background-color: <?php echo $settings['background_color'] ?? '#ffffff'; ?>;
            --header-color: <?php echo $settings['header_color'] ?? '#333333'; ?>;
            --category-color-1: <?php echo $settings['category_color_1'] ?? '#F8D7A8'; ?>;
            --category-color-2: <?php echo $settings['category_color_2'] ?? '#F8C8A8'; ?>;
            --category-color-3: <?php echo $settings['category_color_3'] ?? '#A8F8D7'; ?>;
            --category-color-4: <?php echo $settings['category_color_4'] ?? '#A8C8F8'; ?>;
            --category-color-5: <?php echo $settings['category_color_5'] ?? '#D7A8F8'; ?>;
            --bottom-menu-color: <?php echo $settings['bottom_menu_color'] ?? '#ffffff'; ?>;
            --menu-item-bg-color: <?php echo $settings['menu_item_bg_color'] ?? '#ffffff'; ?>;
        }
        
        body {
            display: flex;
            flex-direction: column;
            min-height: 100vh;
            background-color: var(--background-color);
            color: var(--text-color);
        }
        
        main {
            flex: 1;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        
        .call-waiter-card {
            max-width: 500px;
            width: 100%;
            text-align: center;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
            background-color: var(--menu-item-bg-color);
        }
        
        .call-waiter-icon {
            font-size: 5rem;
            color: var(--primary-color);
            margin-bottom: 20px;
        }
        
        .success-icon {
            font-size: 5rem;
            color: var(--secondary-color);
            margin-bottom: 20px;
        }
        
        .qr-message-icon {
            font-size: 6rem;
            color: var(--primary-color);
            margin-bottom: 20px;
            animation: pulse 2s infinite;
        }
        
        @keyframes pulse {
            0% {
                transform: scale(1);
                opacity: 1;
            }
            50% {
                transform: scale(1.1);
                opacity: 0.8;
            }
            100% {
                transform: scale(1);
                opacity: 1;
            }
        }
        
        .menu-header {
            background-color: var(--header-color);
        }
    </style>
</head>
<body>
    <?php if (!$showQrMessage): ?>
    <!-- Üst Menü -->
    
    <?php endif; ?>
    
    <!-- Ana İçerik -->
    <main>
        <div class="call-waiter-card">
            <?php if ($showQrMessage): ?>
            <!-- QR Kod Tarayıcı -->
            <div class="qr-scanner-container">
                <div class="qr-message-icon mb-3">
                    <i class="fas fa-qrcode"></i>
                </div>
                <h2 class="mb-3">QR Kodu Okutunuz</h2>
                <p class="lead mb-3">Garson çağırmak için lütfen masanızdaki QR kodu okutunuz.</p>
                
                <!-- Kamera izni isteme butonu -->
                <button id="startButton" class="btn btn-primary mb-3">
                    <i class="fas fa-camera"></i> Kamerayı Aç
                </button>
                
                <!-- Video elementi (başlangıçta gizli) -->
                <div id="videoContainer" style="display: none; max-width: 100%; margin: 0 auto;">
                    <video id="qrVideo" style="width: 100%; max-width: 500px; border-radius: 10px;"></video>
                    <div class="mt-2 text-muted small">QR kodu kameraya gösterin</div>
                </div>
                
                <!-- Hata mesajı -->
                <div id="errorMessage" class="alert alert-danger mt-3" style="display: none;"></div>
                
                <div class="mt-4">
                    <a href="../../index.php?<?php echo !empty($qrParam) ? 'qr=' . $qrParam : ''; ?>" class="btn btn-outline-secondary">
                        <i class="fas fa-arrow-left"></i> Ana Menüye Dön
                    </a>
                    <p class="mt-3 text-muted small">Not: Garson çağırmak için masanızdaki QR kodu taramanız gerekiyor.</p>
                </div>
            </div>
            
            <!-- QR Kod Tarama Kütüphaneleri -->
            <script src="https://cdn.jsdelivr.net/npm/jsqr@1.4.0/dist/jsQR.min.js"></script>
            <script src="https://unpkg.com/@zxing/library@0.19.1"></script>
            
            <!-- QR Kod Tarama Script -->
            <script>
                document.addEventListener('DOMContentLoaded', function() {
                    const startButton = document.getElementById('startButton');
                    const videoContainer = document.getElementById('videoContainer');
                    const video = document.getElementById('qrVideo');
                    const errorMessage = document.getElementById('errorMessage');
                    
                    let stream = null;
                    let scanning = false;
                    let canvasElement = document.createElement('canvas');
                    let canvas = canvasElement.getContext('2d');
                    
                    // Tarayıcı uyumluluğunu kontrol et
                    const isBrowserCompatible = () => {
                        return !!(navigator.mediaDevices && navigator.mediaDevices.getUserMedia);
                    };
                    
                    // Dosya yükleme alanı ekle (kamera erişimi olmayan tarayıcılar için)
                    const addFileUploadOption = () => {
                        const fileUploadContainer = document.createElement('div');
                        fileUploadContainer.className = 'mt-3';
                        fileUploadContainer.innerHTML = `
                            <p class="text-muted">veya</p>
                            <label for="qrFileInput" class="btn btn-outline-secondary">
                                <i class="fas fa-upload"></i> QR Kod Resmi Yükle
                            </label>
                            <input type="file" id="qrFileInput" accept="image/*" style="display: none;">
                        `;
                        
                        startButton.parentNode.insertBefore(fileUploadContainer, startButton.nextSibling);
                        
                        // Dosya yükleme olayını dinle
                        const fileInput = document.getElementById('qrFileInput');
                        fileInput.addEventListener('change', handleFileUpload);
                    };
                    
                    // Yüklenen dosyadan QR kod okuma
                    const handleFileUpload = (event) => {
                        const file = event.target.files[0];
                        if (!file) return;
                        
                        const reader = new FileReader();
                        reader.onload = function(e) {
                            const img = new Image();
                            img.onload = function() {
                                // Canvas'a resmi çiz
                                canvasElement.width = img.width;
                                canvasElement.height = img.height;
                                canvas.drawImage(img, 0, 0, img.width, img.height);
                                
                                // QR kodu tara
                                const imageData = canvas.getImageData(0, 0, canvasElement.width, canvasElement.height);
                                
                                try {
                                    // jsQR ile dene
                                    const code = jsQR(imageData.data, imageData.width, imageData.height, {
                                        inversionAttempts: "dontInvert",
                                    });
                                    
                                    if (code && code.data) {
                                        handleQRCode(code.data);
                                        return;
                                    }
                                } catch (err) {
                                    console.error('jsQR hatası:', err);
                                }
                                
                                try {
                                    // ZXing ile dene
                                    if (window.ZXing) {
                                        const hints = new Map();
                                        hints.set(ZXing.DecodeHintType.POSSIBLE_FORMATS, [ZXing.BarcodeFormat.QR_CODE]);
                                        
                                        const reader = new ZXing.MultiFormatReader();
                                        reader.setHints(hints);
                                        
                                        const luminanceSource = new ZXing.HTMLCanvasElementLuminanceSource(canvasElement);
                                        const binaryBitmap = new ZXing.BinaryBitmap(new ZXing.HybridBinarizer(luminanceSource));
                                        
                                        try {
                                            const result = reader.decode(binaryBitmap);
                                            if (result && result.text) {
                                                handleQRCode(result.text);
                                                return;
                                            }
                                        } catch (e) {
                                            console.error('ZXing decode hatası:', e);
                                        }
                                    }
                                } catch (err) {
                                    console.error('ZXing hatası:', err);
                                }
                                
                                // QR kod bulunamadı
                                errorMessage.textContent = 'QR kod bulunamadı. Lütfen başka bir resim deneyin.';
                                errorMessage.style.display = 'block';
                            };
                            img.src = e.target.result;
                        };
                        reader.readAsDataURL(file);
                    };
                    
                    // QR kod içeriğini işle
                    const handleQRCode = (data) => {
                        console.log('QR kod bulundu:', data);
                        
                        // QR kod içeriğini kontrol et
                        if (data.includes('table_id=') || data.includes('qr=')) {
                            // Kamerayı kapat
                            stopCamera();
                            
                            // QR kod URL'sine yönlendir
                            window.location.href = data;
                        } else {
                            errorMessage.textContent = 'Geçersiz QR kod. Lütfen masa QR kodunu okutun.';
                            errorMessage.style.display = 'block';
                        }
                    };
                    
                    // Kamera başlatma fonksiyonu
                    const startCamera = () => {
                        // Kamera erişimi iste
                        const constraints = { 
                            video: { 
                                facingMode: 'environment', // Arka kamerayı tercih et
                                width: { ideal: 1280 },
                                height: { ideal: 720 }
                            } 
                        };
                        
                        // Eski tarayıcılar için getUserMedia
                        const getUserMedia = navigator.mediaDevices.getUserMedia || 
                                            navigator.webkitGetUserMedia || 
                                            navigator.mozGetUserMedia || 
                                            navigator.msGetUserMedia;
                        
                        if (getUserMedia) {
                            navigator.mediaDevices.getUserMedia(constraints)
                                .then(function(mediaStream) {
                                    stream = mediaStream;
                                    
                                    // Eski tarayıcılar için video kaynağı ayarla
                                    if ('srcObject' in video) {
                                        video.srcObject = mediaStream;
                                    } else {
                                        // Eski tarayıcılar için
                                        video.src = window.URL.createObjectURL(mediaStream);
                                    }
                                    
                                    video.setAttribute('playsinline', true); // iOS için gerekli
                                    video.play();
                                    
                                    // Video elementini göster, butonu gizle
                                    videoContainer.style.display = 'block';
                                    startButton.style.display = 'none';
                                    
                                    // QR kod taramayı başlat
                                    scanning = true;
                                    requestAnimationFrame(tick);
                                })
                                .catch(function(error) {
                                    console.error('Kamera erişim hatası:', error);
                                    errorMessage.textContent = 'Kamera erişimi sağlanamadı: ' + error.message;
                                    errorMessage.style.display = 'block';
                                    
                                    // Kamera erişimi olmadığında dosya yükleme seçeneğini göster
                                    addFileUploadOption();
                                });
                        } else {
                            errorMessage.textContent = 'Tarayıcınız kamera erişimini desteklemiyor.';
                            errorMessage.style.display = 'block';
                            
                            // Kamera erişimi olmadığında dosya yükleme seçeneğini göster
                            addFileUploadOption();
                        }
                    };
                    
                    // QR kod tarama fonksiyonu
                    function tick() {
                        if (!scanning) return;
                        
                        if (video.readyState === video.HAVE_ENOUGH_DATA) {
                            canvasElement.height = video.videoHeight;
                            canvasElement.width = video.videoWidth;
                            canvas.drawImage(video, 0, 0, canvasElement.width, canvasElement.height);
                            
                            const imageData = canvas.getImageData(0, 0, canvasElement.width, canvasElement.height);
                            
                            try {
                                // jsQR ile dene
                                const code = jsQR(imageData.data, imageData.width, imageData.height, {
                                    inversionAttempts: "dontInvert",
                                });
                                
                                if (code && code.data) {
                                    handleQRCode(code.data);
                                    return;
                                }
                            } catch (err) {
                                console.error('jsQR hatası:', err);
                                
                                // ZXing ile dene
                                try {
                                    if (window.ZXing) {
                                        const hints = new Map();
                                        hints.set(ZXing.DecodeHintType.POSSIBLE_FORMATS, [ZXing.BarcodeFormat.QR_CODE]);
                                        
                                        const reader = new ZXing.MultiFormatReader();
                                        reader.setHints(hints);
                                        
                                        const luminanceSource = new ZXing.HTMLCanvasElementLuminanceSource(canvasElement);
                                        const binaryBitmap = new ZXing.BinaryBitmap(new ZXing.HybridBinarizer(luminanceSource));
                                        
                                        try {
                                            const result = reader.decode(binaryBitmap);
                                            if (result && result.text) {
                                                handleQRCode(result.text);
                                                return;
                                            }
                                        } catch (e) {
                                            // QR kod bulunamadı, devam et
                                        }
                                    }
                                } catch (zxingErr) {
                                    console.error('ZXing hatası:', zxingErr);
                                }
                            }
                        }
                        
                        requestAnimationFrame(tick);
                    }
                    
                    // Kamerayı kapatma fonksiyonu
                    function stopCamera() {
                        scanning = false;
                        if (stream) {
                            stream.getTracks().forEach(track => track.stop());
                            stream = null;
                        }
                    }
                    
                    // Sayfa kapatıldığında kamerayı kapat
                    window.addEventListener('beforeunload', stopCamera);
                    
                    // Kamera başlatma butonuna tıklama olayı
                    startButton.addEventListener('click', startCamera);
                    
                    // Tarayıcı uyumluluğunu kontrol et
                    if (!isBrowserCompatible()) {
                        startButton.disabled = true;
                        errorMessage.textContent = 'Tarayıcınız kamera erişimini desteklemiyor.';
                        errorMessage.style.display = 'block';
                        
                        // Kamera erişimi olmadığında dosya yükleme seçeneğini göster
                        addFileUploadOption();
                    } else {
                        // Dosya yükleme seçeneğini her durumda ekle (alternatif olarak)
                        addFileUploadOption();
                    }
                });
            </script>
            <?php elseif ($success): ?>
            <!-- Başarılı Çağrı -->
            <div class="success-icon">
                <i class="fas fa-check-circle"></i>
            </div>
            <h2 class="mb-4"><?php echo $translations['call_sent']; ?></h2>
            <div class="mt-4">
                <a href="../../index.php?<?php echo !empty($qrParam) ? 'qr=' . $qrParam : 'table_id=' . $tableId; ?>&lang=<?php echo $languageCode; ?>" class="btn btn-outline-secondary">
                    <i class="fas fa-arrow-left"></i> <?php echo $translations['back_to_menu']; ?>
                </a>
            </div>
            <?php else: ?>
            <!-- Çağrı Formu -->
            <div class="call-waiter-icon">
                <i class="fas fa-bell"></i>
            </div>
            <h2 class="mb-4"><?php echo $translations['call_waiter']; ?></h2>
            
            <?php if (!empty($error)): ?>
            <div class="alert alert-danger"><?php echo $error; ?></div>
            <?php endif; ?>
            
            <form method="post" action="<?php echo htmlspecialchars($_SERVER['PHP_SELF']); ?>">
    <input type="hidden" name="qr" value="<?php echo $qrParam; ?>">
    <input type="hidden" name="table_id" value="<?php echo $tableId; ?>">
    <input type="hidden" name="lang" value="<?php echo $languageCode; ?>">
                <input type="hidden" name="call_type" value="waiter">
                <button type="submit" class="btn btn-primary btn-lg mb-3">
                    <i class="fas fa-bell"></i> <?php echo $translations['call_waiter']; ?>
                </button>
            </form>
            
            <form method="post" action="<?php echo htmlspecialchars($_SERVER['PHP_SELF']); ?>">
    <input type="hidden" name="qr" value="<?php echo $qrParam; ?>">
    <input type="hidden" name="table_id" value="<?php echo $tableId; ?>">
    <input type="hidden" name="lang" value="<?php echo $languageCode; ?>">
                <input type="hidden" name="call_type" value="bill">
                <button type="submit" class="btn btn-success btn-lg">
                    <i class="fas fa-file-invoice"></i> Hesap İste
                </button>
            </form>
            
            <div class="mt-4">
                <a href="../../index.php?<?php echo !empty($qrParam) ? 'qr=' . $qrParam : 'table_id=' . $tableId; ?>&lang=<?php echo $languageCode; ?>" class="btn btn-outline-secondary">
                    <i class="fas fa-arrow-left"></i> <?php echo $translations['back_to_menu']; ?>
                </a>
            </div>
            <?php endif; ?>
        </div>
    </main>
    
    <?php if (!$showQrMessage): ?>
    
    <?php endif; ?>
    
    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    
    <!-- Ana JS -->
    <script src="../../assets/js/script.js"></script>
</body>
</html>
