# PHP Restoran Menü Sistemi

Bu proje, PHP ve MySQL kullanarak geliştirilmiş basit ama modern görünümlü, mobil uyumlu bir restoran menü sistemidir.

## Özellikler

- **Kategori Yönetimi**: Kategori ekleme, güncelleme, silme ve sıralama
- **Ürün Yönetimi**: Ürün ekleme, güncelleme, silme ve sıralama
- **Resim Yükleme**: Ürünlerin ve kategorilerin resimlerini yönetici panelinden yükleme
- **Slider Yönetimi**: Ana sayfada gösterilecek slider'ları yönetme
- **Veritabanı**: MySQL ile kategoriler ve ürünler arasında ilişkilendirilmiş yapı
- **Arayüz**: Bootstrap ile mobil uyumlu, modern ve kullanıcı dostu tasarım
- **Güvenlik**: SQL Injection koruması, form doğrulama
- **Admin Paneli**: Basit bir yönetici paneli ile kategori ve ürünleri yönetme
- **SEO Dostu Linkler**: Ürün ve kategori sayfalarının SEO uyumlu URL yapısı
- **Özelleştirilebilir Görünüm**: Header, footer ve diğer bileşenlerin görünürlüğünü ayarlama

## Kurulum

1. Dosyaları web sunucunuza yükleyin
2. `restaurant_menu.sql` dosyasını MySQL veritabanınıza import edin
3. `config/db.php` dosyasındaki veritabanı bağlantı bilgilerini düzenleyin
4. Tarayıcınızdan projeyi açın

## Admin Paneli

- URL: `http://siteniz.com/admin/`
- Kullanıcı adı: `admin`
- Şifre: `admin123`

## Klasör Yapısı

```
/
├── admin/                  # Yönetim paneli dosyaları
│   ├── includes/           # Admin panel için include dosyaları
│   ├── add_category.php    # Kategori ekleme sayfası
│   ├── edit_category.php   # Kategori düzenleme sayfası
│   ├── categories.php      # Kategori listesi
│   ├── add_product.php     # Ürün ekleme sayfası
│   ├── edit_product.php    # Ürün düzenleme sayfası
│   ├── products.php        # Ürün listesi
│   ├── settings.php        # Site ayarları
│   ├── index.php           # Admin panel ana sayfa
│   ├── login.php           # Giriş sayfası
│   └── logout.php          # Çıkış işlemi
├── assets/                 # Statik dosyalar
│   ├── css/                # CSS dosyaları
│   ├── js/                 # JavaScript dosyaları
│   └── img/                # Resimler
├── config/                 # Yapılandırma dosyaları
│   └── db.php              # Veritabanı bağlantısı
├── includes/               # Include dosyaları
│   ├── functions.php       # Yardımcı fonksiyonlar
│   ├── header.php          # Sayfa başlığı
│   └── footer.php          # Sayfa altlığı
├── uploads/                # Yüklenen resimler
├── category.php            # Kategori sayfası
├── index.php               # Ana sayfa
├── restaurant_menu.sql     # Veritabanı şeması
└── README.md               # Proje açıklaması
```

## Teknolojiler

- PHP (PDO ile MySQL bağlantısı)
- MySQL
- HTML, CSS (Bootstrap)
- JavaScript (jQuery)

## Güvenlik

- PDO ile SQL Injection koruması
- Şifrelerin güvenli bir şekilde hashlenmesi
- Form doğrulama
- Giriş kontrolü

## Özelleştirme

Site ayarları bölümünden aşağıdaki özellikleri özelleştirebilirsiniz:

- Site başlığı ve açıklaması
- Header ve footer renkleri
- Slider içeriği ve görünürlüğü
- İletişim bilgileri
- Sosyal medya bağlantıları
- Bileşenlerin görünürlüğü (header, footer, öne çıkan ürünler, vb.)

## Lisans

Bu proje MIT lisansı altında lisanslanmıştır.