<?php
session_start();
require_once '../config/db.php';
require_once '../includes/functions.php';

// Admin giriş kontrolü
if (!isLoggedIn()) {
    redirectToLogin();
}

// Site ayarlarını getir
$settings = getSiteSettings($conn);
$faviconImage = $settings['favicon_image'] ?? '';

// Slider sayısını belirle (varsayılan olarak 1)
$slider_count = isset($_POST['update_slider_count']) ? intval($_POST['slider_count']) : (isset($settings['slider_count']) ? intval($settings['slider_count']) : 1);

// Form gönderildiğinde
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Form verilerini al
    $site_title = isset($_POST['site_title']) ? sanitize($_POST['site_title']) : '';
    $site_description = isset($_POST['site_description']) ? sanitize($_POST['site_description']) : '';
    $contact_address = isset($_POST['contact_address']) ? sanitize($_POST['contact_address']) : '';
    $contact_phone = isset($_POST['contact_phone']) ? sanitize($_POST['contact_phone']) : '';
    $contact_email = isset($_POST['contact_email']) ? sanitize($_POST['contact_email']) : '';
    $social_facebook = isset($_POST['social_facebook']) ? sanitize($_POST['social_facebook']) : '';
    $social_instagram = isset($_POST['social_instagram']) ? sanitize($_POST['social_instagram']) : '';
    $social_twitter = isset($_POST['social_twitter']) ? sanitize($_POST['social_twitter']) : '';
    $header_color = isset($_POST['header_color']) ? sanitize($_POST['header_color']) : '#212529';
    $footer_color = isset($_POST['footer_color']) ? sanitize($_POST['footer_color']) : '#212529';
    $footer_text_color = isset($_POST['footer_text_color']) ? sanitize($_POST['footer_text_color']) : '#ffffff';
    $show_footer_contact = isset($_POST['show_footer_contact']) ? '1' : '0';
    $show_footer_social = isset($_POST['show_footer_social']) ? '1' : '0';
    $show_footer_links = isset($_POST['show_footer_links']) ? '1' : '0';
    $show_header = isset($_POST['show_header']) ? '1' : '0';
    $show_footer = isset($_POST['show_footer']) ? '1' : '0';
    $show_featured = isset($_POST['show_featured']) ? '1' : '0';
    $show_slider = isset($_POST['show_slider']) ? '1' : '0';
    $slider_autoplay = isset($_POST['slider_autoplay']) ? '1' : '0';
    $slider_interval = isset($_POST['slider_interval']) ? intval($_POST['slider_interval']) : 5000;
    
    // Sadece sayfa yenileme için slider sayısını güncelliyorsak
    if (isset($_POST['update_slider_count'])) {
        updateSetting($conn, 'slider_count', $slider_count);
        header("Location: settings.php");
        exit;
    }
    
    $errors = [];
    
    // Logo resmi yükleme
    $logo_image = $settings['logo_image'] ?? '';
    
    if (isset($_FILES['logo_image']) && $_FILES['logo_image']['error'] == 0) {
        // Eski resmi sil
        if (!empty($logo_image) && !filter_var($logo_image, FILTER_VALIDATE_URL)) {
            $old_image_path = "../uploads/" . $logo_image;
            if (file_exists($old_image_path)) {
                unlink($old_image_path);
            }
        }
        
        $upload_result = uploadImage($_FILES['logo_image']);
        
        if ($upload_result['success']) {
            $logo_image = $upload_result['file_name'];
        } else {
            $errors[] = $upload_result['message'];
        }
    }
    
    // Favicon yükleme
    $favicon_image = $settings['favicon_image'] ?? '';
    
    if (isset($_FILES['favicon_image']) && $_FILES['favicon_image']['error'] == 0) {
        // Eski favicon'ı sil
        if (!empty($favicon_image) && !filter_var($favicon_image, FILTER_VALIDATE_URL)) {
            $old_favicon_path = "../uploads/" . $favicon_image;
            if (file_exists($old_favicon_path)) {
                unlink($old_favicon_path);
            }
        }
        
        $upload_result = uploadImage($_FILES['favicon_image']);
        
        if ($upload_result['success']) {
            $favicon_image = $upload_result['file_name'];
        } else {
            $errors[] = $upload_result['message'];
        }
    }
    
    // Slider ayarlarını güncelle
    $slider_settings = [];
    
    for ($i = 1; $i <= $slider_count; $i++) {
        $slider_title = isset($_POST["slider{$i}_title"]) ? sanitize($_POST["slider{$i}_title"]) : '';
        $slider_description = isset($_POST["slider{$i}_description"]) ? sanitize($_POST["slider{$i}_description"]) : '';
        $slider_button_text = isset($_POST["slider{$i}_button_text"]) ? sanitize($_POST["slider{$i}_button_text"]) : '';
        $slider_url = isset($_POST["slider{$i}_url"]) ? sanitize($_POST["slider{$i}_url"]) : '';
        
        // Mevcut slider resim değerlerini al
        $slider_image = $settings["slider{$i}_image"] ?? '';
        
        // Slider resim yükleme
        if (isset($_FILES["slider{$i}_image"]) && $_FILES["slider{$i}_image"]['error'] == 0) {
            // Eski resmi sil
            if (!empty($slider_image) && !filter_var($slider_image, FILTER_VALIDATE_URL)) {
                $old_image_path = "../uploads/" . $slider_image;
                if (file_exists($old_image_path)) {
                    unlink($old_image_path);
                }
            }
            
            $upload_result = uploadImage($_FILES["slider{$i}_image"]);
            
            if ($upload_result['success']) {
                $slider_image = $upload_result['file_name'];
            } else {
                $errors[] = "Slider {$i}: " . $upload_result['message'];
            }
        }
        
        // Slider URL
        $slider_settings["slider{$i}_title"] = $slider_title;
        $slider_settings["slider{$i}_description"] = $slider_description;
        $slider_settings["slider{$i}_button_text"] = $slider_button_text;
        $slider_settings["slider{$i}_url"] = $slider_url;
        $slider_settings["slider{$i}_image"] = $slider_image;
    }
    
    // Hata yoksa veritabanını güncelle
    if (empty($errors)) {
        // Ayarları güncelle veya ekle
        foreach ([
            'site_title' => $site_title,
            'site_description' => $site_description,
            'contact_address' => $contact_address,
            'contact_phone' => $contact_phone,
            'contact_email' => $contact_email,
            'social_facebook' => $social_facebook,
            'social_instagram' => $social_instagram,
            'social_twitter' => $social_twitter,
            'logo_image' => $logo_image,
            'favicon_image' => $favicon_image,
            'header_color' => $header_color,
            'footer_color' => $footer_color,
            'footer_text_color' => $footer_text_color,
            'show_footer_contact' => $show_footer_contact,
            'show_footer_social' => $show_footer_social,
            'show_footer_links' => $show_footer_links,
            'show_header' => $show_header,
            'show_footer' => $show_footer,
            'show_featured' => $show_featured,
            'show_slider' => $show_slider,
            'slider_autoplay' => $slider_autoplay,
            'slider_interval' => $slider_interval,
            'slider_count' => $slider_count
        ] as $key => $value) {
            updateSetting($conn, $key, $value);
        }
        
        // Slider ayarlarını güncelle
        foreach ($slider_settings as $key => $value) {
            updateSetting($conn, $key, $value);
        }
        
        $success = true;
        
        // Güncel ayarları getir
        $settings = getSiteSettings($conn);
    }
}

// Slider sayısını belirle
$slider_count = isset($settings['slider_count']) ? intval($settings['slider_count']) : 1;
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Site Ayarları - <?= $settings['site_title'] ?? 'Restoran Menü'; ?></title>
    <meta name="description" content="Site ayarlarını düzenle - <?= $settings['site_title'] ?? 'Restoran Menü'; ?> yönetim paneli">
    <?php if (!empty($faviconImage)): ?>
        <?php if (filter_var($faviconImage, FILTER_VALIDATE_URL)): ?>
            <link rel="icon" href="<?= $faviconImage; ?>" type="image/x-icon">
            <link rel="shortcut icon" href="<?= $faviconImage; ?>" type="image/x-icon">
        <?php else: ?>
            <link rel="icon" href="../uploads/<?= $faviconImage; ?>?v=<?= time(); ?>" type="image/x-icon">
            <link rel="shortcut icon" href="../uploads/<?= $faviconImage; ?>?v=<?= time(); ?>" type="image/x-icon">
        <?php endif; ?>
    <?php else: ?>
        <link rel="icon" href="../assets/img/favicon.ico" type="image/x-icon">
        <link rel="shortcut icon" href="../assets/img/favicon.ico" type="image/x-icon">
    <?php endif; ?>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link rel="stylesheet" href="../assets/css/admin.css">
</head>
<body>
    <?php include 'includes/header.php'; ?>

    <div class="container-fluid">
        <div class="row">
            <?php include 'includes/sidebar.php'; ?>
            
            <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4 py-4">
                <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                    <h1 class="h2">Site Ayarları</h1>
                </div>
                
                <?php if (isset($success) && $success): ?>
                    <div class="alert alert-success">
                        Site ayarları başarıyla güncellendi.
                    </div>
                <?php endif; ?>
                
                <?php if (!empty($errors)): ?>
                    <div class="alert alert-danger">
                        <ul class="mb-0">
                            <?php foreach ($errors as $error): ?>
                                <li><?= $error; ?></li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                <?php endif; ?>
                
                <div class="card">
                    <div class="card-body">
                        <form method="post" action="settings.php" enctype="multipart/form-data">
                            <ul class="nav nav-tabs mb-4" id="settingsTabs" role="tablist">
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link active" id="general-tab" data-bs-toggle="tab" data-bs-target="#general" type="button" role="tab" aria-controls="general" aria-selected="true">
                                        <i class="fas fa-cog me-1"></i> Genel
                                    </button>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link" id="header-tab" data-bs-toggle="tab" data-bs-target="#header" type="button" role="tab" aria-controls="header" aria-selected="false">
                                        <i class="fas fa-heading me-1"></i> Üst Bilgi
                                    </button>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link" id="slider-tab" data-bs-toggle="tab" data-bs-target="#slider" type="button" role="tab" aria-controls="slider" aria-selected="false">
                                        <i class="fas fa-images me-1"></i> Slider
                                    </button>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link" id="footer-tab" data-bs-toggle="tab" data-bs-target="#footer" type="button" role="tab" aria-controls="footer" aria-selected="false">
                                        <i class="fas fa-shoe-prints me-1"></i> Alt Bilgi
                                    </button>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link" id="contact-tab" data-bs-toggle="tab" data-bs-target="#contact" type="button" role="tab" aria-controls="contact" aria-selected="false">
                                        <i class="fas fa-address-book me-1"></i> İletişim
                                    </button>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link" id="social-tab" data-bs-toggle="tab" data-bs-target="#social" type="button" role="tab" aria-controls="social" aria-selected="false">
                                        <i class="fas fa-share-alt me-1"></i> Sosyal Medya
                                    </button>
                                </li>
                            </ul>
                            
                            <div class="tab-content" id="settingsTabsContent">
                                <!-- Genel Ayarlar -->
                                <div class="tab-pane fade show active" id="general" role="tabpanel" aria-labelledby="general-tab">
                                    <div class="mb-3">
                                        <label for="site_title" class="form-label">Site Başlığı</label>
                                        <input type="text" class="form-control" id="site_title" name="site_title" value="<?= $settings['site_title'] ?? 'Restoran Menü'; ?>">
                                        <div class="form-text">Tarayıcı sekmesinde ve site başlığında görünecek isim.</div>
                                    </div>
                                    
                                    <div class="mb-3">
                                        <label for="site_description" class="form-label">Site Açıklaması</label>
                                        <textarea class="form-control" id="site_description" name="site_description" rows="2"><?= $settings['site_description'] ?? 'Lezzetli yemeklerimizi keşfedin'; ?></textarea>
                                        <div class="form-text">Ana sayfada görünecek kısa açıklama.</div>
                                    </div>
                                    
                                    <div class="mb-3">
                                        <label class="form-label">Görünüm Ayarları</label>
                                        <div class="form-check mb-2">
                                            <input class="form-check-input" type="checkbox" id="show_header" name="show_header" <?= ($settings['show_header'] ?? '1') == '1' ? 'checked' : ''; ?>>
                                            <label class="form-check-label" for="show_header">
                                                Header (Üst Bilgi) Göster
                                            </label>
                                        </div>
                                        <div class="form-check mb-2">
                                            <input class="form-check-input" type="checkbox" id="show_footer" name="show_footer" <?= ($settings['show_footer'] ?? '1') == '1' ? 'checked' : ''; ?>>
                                            <label class="form-check-label" for="show_footer">
                                                Footer (Alt Bilgi) Göster
                                            </label>
                                        </div>
                                        <div class="form-check mb-2">
                                            <input class="form-check-input" type="checkbox" id="show_featured" name="show_featured" <?= ($settings['show_featured'] ?? '1') == '1' ? 'checked' : ''; ?>>
                                            <label class="form-check-label" for="show_featured">
                                                Öne Çıkan Ürünleri Göster
                                            </label>
                                        </div>
                                        <div class="form-check mb-2">
                                            <input class="form-check-input" type="checkbox" id="show_slider" name="show_slider" <?= ($settings['show_slider'] ?? '1') == '1' ? 'checked' : ''; ?>>
                                            <label class="form-check-label" for="show_slider">
                                                Ana Sayfa Slider Göster
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Üst Bilgi Ayarları -->
                                <div class="tab-pane fade" id="header" role="tabpanel" aria-labelledby="header-tab">
                                    <div class="mb-3">
                                        <label for="logo_image" class="form-label">Logo</label>
                                        <?php if (!empty($settings['logo_image'])): ?>
                                            <div class="mb-2">
                                                <?php if (filter_var($settings['logo_image'], FILTER_VALIDATE_URL)): ?>
                                                    <img src="<?= $settings['logo_image']; ?>" alt="Logo" class="img-thumbnail" style="max-width: 200px;">
                                                <?php else: ?>
                                                    <img src="../uploads/<?= $settings['logo_image']; ?>?v=<?= time(); ?>" alt="Logo" class="img-thumbnail" style="max-width: 200px;">
                                                <?php endif; ?>
                                            </div>
                                        <?php endif; ?>
                                        <input type="file" class="form-control" id="logo_image" name="logo_image" accept="image/*">
                                        <div class="form-text">Önerilen boyut: 200x50 piksel. Logo yüklemezseniz site adı gösterilecektir.</div>
                                    </div>
                                    
                                    <div class="mb-3">
                                        <label for="favicon_image" class="form-label">Favicon</label>
                                        <?php if (!empty($settings['favicon_image'])): ?>
                                            <div class="mb-2">
                                                <?php if (filter_var($settings['favicon_image'], FILTER_VALIDATE_URL)): ?>
                                                    <img src="<?= $settings['favicon_image']; ?>" alt="Favicon" class="img-thumbnail" style="max-width: 64px;">
                                                <?php else: ?>
                                                    <img src="../uploads/<?= $settings['favicon_image']; ?>?v=<?= time(); ?>" alt="Favicon" class="img-thumbnail" style="max-width: 64px;">
                                                <?php endif; ?>
                                            </div>
                                        <?php endif; ?>
                                        <input type="file" class="form-control" id="favicon_image" name="favicon_image" accept="image/x-icon,image/png,image/jpeg,image/gif,image/svg+xml">
                                        <div class="form-text">Önerilen boyut: 32x32 veya 16x16 piksel. Favicon yüklemezseniz varsayılan favicon gösterilecektir. ICO, PNG, JPG, GIF veya SVG formatında olabilir.</div>
                                    </div>
                                    
                                    <div class="mb-3">
                                        <label for="header_color" class="form-label">Header Rengi</label>
                                        <input type="color" class="form-control form-control-color" id="header_color" name="header_color" value="<?= $settings['header_color'] ?? '#212529'; ?>">
                                        <div class="form-text">Header arka plan rengi.</div>
                                    </div>
                                </div>
                                
                                <!-- Slider Ayarları -->
                                <div class="tab-pane fade" id="slider" role="tabpanel" aria-labelledby="slider-tab">
                                    <div class="alert alert-info">
                                        <i class="fas fa-info-circle me-2"></i> Ana sayfada gösterilecek slider ayarlarını buradan yapabilirsiniz.
                                    </div>
                                    
                                    <div class="mb-3">
                                        <label class="form-label">Slider Görünüm Ayarları</label>
                                        <div class="form-check mb-2">
                                            <input class="form-check-input" type="checkbox" id="slider_autoplay" name="slider_autoplay" <?= ($settings['slider_autoplay'] ?? '1') == '1' ? 'checked' : ''; ?>>
                                            <label class="form-check-label" for="slider_autoplay">
                                                Otomatik Oynat
                                            </label>
                                        </div>
                                    </div>
                                    
                                    <div class="mb-3">
                                        <label for="slider_interval" class="form-label">Slider Geçiş Süresi (ms)</label>
                                        <input type="number" class="form-control" id="slider_interval" name="slider_interval" value="<?= $settings['slider_interval'] ?? '5000'; ?>" min="1000" step="500">
                                        <div class="form-text">Slider geçiş süresi (milisaniye cinsinden). Önerilen: 5000 (5 saniye)</div>
                                    </div>
                                    
                                    <div class="mb-3">
                                        <label for="slider_count" class="form-label">Slider Sayısı</label>
                                        <select class="form-select" id="slider_count" name="slider_count">
                                            <?php for ($i = 1; $i <= 5; $i++): ?>
                                                <option value="<?= $i; ?>" <?= $slider_count == $i ? 'selected' : ''; ?>><?= $i; ?></option>
                                            <?php endfor; ?>
                                        </select>
                                        <div class="form-text">Kaç adet slider gösterilecek? (Maksimum 5)</div>
                                    </div>
                                    
                                    <hr>
                                    
                                    <!-- Slider Ayarları Tabları -->
                                    <ul class="nav nav-pills mb-3" id="sliderTabs" role="tablist">
                                        <?php for ($i = 1; $i <= $slider_count; $i++): ?>
                                            <li class="nav-item" role="presentation">
                                                <button class="nav-link <?= $i == 1 ? 'active' : ''; ?>" id="slider<?= $i; ?>-tab" data-bs-toggle="pill" data-bs-target="#slider<?= $i; ?>-content" type="button" role="tab" aria-controls="slider<?= $i; ?>-content" aria-selected="<?= $i == 1 ? 'true' : 'false'; ?>">
                                                    Slider <?= $i; ?>
                                                </button>
                                            </li>
                                        <?php endfor; ?>
                                    </ul>
                                    
                                    <div class="tab-content" id="sliderTabsContent">
                                        <?php for ($i = 1; $i <= $slider_count; $i++): ?>
                                            <div class="tab-pane fade <?= $i == 1 ? 'show active' : ''; ?>" id="slider<?= $i; ?>-content" role="tabpanel" aria-labelledby="slider<?= $i; ?>-tab">
                                                <div class="card">
                                                    <div class="card-header">
                                                        <h5 class="mb-0">Slider <?= $i; ?> Ayarları</h5>
                                                    </div>
                                                    <div class="card-body">
                                                        <div class="mb-3">
                                                            <label for="slider<?= $i; ?>_title" class="form-label">Slider Başlığı</label>
                                                            <input type="text" class="form-control" id="slider<?= $i; ?>_title" name="slider<?= $i; ?>_title" value="<?= $settings["slider{$i}_title"] ?? ($i == 1 ? 'Hoş Geldiniz' : ''); ?>">
                                                        </div>
                                                        
                                                        <div class="mb-3">
                                                            <label for="slider<?= $i; ?>_description" class="form-label">Slider Açıklaması</label>
                                                            <textarea class="form-control" id="slider<?= $i; ?>_description" name="slider<?= $i; ?>_description" rows="2"><?= $settings["slider{$i}_description"] ?? ($i == 1 ? 'Lezzetli yemeklerimizi keşfedin' : ''); ?></textarea>
                                                        </div>
                                                        
                                                        <div class="mb-3">
                                                            <label for="slider<?= $i; ?>_button_text" class="form-label">Buton Metni</label>
                                                            <input type="text" class="form-control" id="slider<?= $i; ?>_button_text" name="slider<?= $i; ?>_button_text" value="<?= $settings["slider{$i}_button_text"] ?? ($i == 1 ? 'Menüyü Görüntüle' : ''); ?>">
                                                            <div class="form-text">Slider üzerindeki buton metni. Boş bırakırsanız buton gösterilmez.</div>
                                                        </div>
                                                        
                                                        <div class="mb-3">
                                                            <label for="slider<?= $i; ?>_url" class="form-label">Buton URL</label>
                                                            <input type="text" class="form-control" id="slider<?= $i; ?>_url" name="slider<?= $i; ?>_url" value="<?= $settings["slider{$i}_url"] ?? '#'; ?>">
                                                            <div class="form-text">Slider butonuna tıklandığında gidilecek URL. # kullanırsanız sayfada kalır.</div>
                                                        </div>
                                                        
                                                        <div class="mb-3">
                                                            <label for="slider<?= $i; ?>_image" class="form-label">Slider Resmi</label>
                                                            <?php if (!empty($settings["slider{$i}_image"])): ?>
                                                                <div class="mb-2">
                                                                    <?php if (filter_var($settings["slider{$i}_image"], FILTER_VALIDATE_URL)): ?>
                                                                        <img src="<?= $settings["slider{$i}_image"]; ?>" alt="Slider <?= $i; ?>" class="img-thumbnail" style="max-width: 300px;">
                                                                    <?php else: ?>
                                                                        <img src="../uploads/<?= $settings["slider{$i}_image"]; ?>?v=<?= time(); ?>" alt="Slider <?= $i; ?>" class="img-thumbnail" style="max-width: 300px;">
                                                                    <?php endif; ?>
                                                                </div>
                                                            <?php endif; ?>
                                                            <input type="file" class="form-control" id="slider<?= $i; ?>_image" name="slider<?= $i; ?>_image" accept="image/*">
                                                            <div class="form-text">Önerilen boyut: 1920x450 piksel. Maksimum dosya boyutu: 2MB.</div>
                                                            <div id="slider<?= $i; ?>_image-preview" class="mt-2"></div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endfor; ?>
                                    </div>
                                </div>
                                
                                <!-- Alt Bilgi Ayarları -->
                                <div class="tab-pane fade" id="footer" role="tabpanel" aria-labelledby="footer-tab">
                                    <div class="mb-3">
                                        <label for="footer_color" class="form-label">Footer Rengi</label>
                                        <input type="color" class="form-control form-control-color" id="footer_color" name="footer_color" value="<?= $settings['footer_color'] ?? '#212529'; ?>">
                                        <div class="form-text">Footer arka plan rengi.</div>
                                    </div>
                                    
                                    <div class="mb-3">
                                        <label for="footer_text_color" class="form-label">Footer Yazı Rengi</label>
                                        <input type="color" class="form-control form-control-color" id="footer_text_color" name="footer_text_color" value="<?= $settings['footer_text_color'] ?? '#ffffff'; ?>">
                                        <div class="form-text">Footer yazı rengi.</div>
                                    </div>
                                    
                                    <div class="mb-3">
                                        <label class="form-label">Footer Görünüm Ayarları</label>
                                        <div class="form-check mb-2">
                                            <input class="form-check-input" type="checkbox" id="show_footer_contact" name="show_footer_contact" <?= ($settings['show_footer_contact'] ?? '1') == '1' ? 'checked' : ''; ?>>
                                            <label class="form-check-label" for="show_footer_contact">
                                                İletişim Bilgilerini Göster
                                            </label>
                                        </div>
                                        <div class="form-check mb-2">
                                            <input class="form-check-input" type="checkbox" id="show_footer_social" name="show_footer_social" <?= ($settings['show_footer_social'] ?? '1') == '1' ? 'checked' : ''; ?>>
                                            <label class="form-check-label" for="show_footer_social">
                                                Sosyal Medya Bağlantılarını Göster
                                            </label>
                                        </div>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="show_footer_links" name="show_footer_links" <?= ($settings['show_footer_links'] ?? '1') == '1' ? 'checked' : ''; ?>>
                                            <label class="form-check-label" for="show_footer_links">
                                                Hızlı Erişim Bağlantılarını Göster
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- İletişim Ayarları -->
                                <div class="tab-pane fade" id="contact" role="tabpanel" aria-labelledby="contact-tab">
                                    <div class="mb-3">
                                        <label for="contact_address" class="form-label">Adres</label>
                                        <textarea class="form-control" id="contact_address" name="contact_address" rows="2"><?= $settings['contact_address'] ?? 'Örnek Mahallesi, Örnek Sokak No:123'; ?></textarea>
                                    </div>
                                    
                                    <div class="mb-3">
                                        <label for="contact_phone" class="form-label">Telefon</label>
                                        <input type="text" class="form-control" id="contact_phone" name="contact_phone" value="<?= $settings['contact_phone'] ?? '(555) 123-4567'; ?>">
                                    </div>
                                    
                                    <div class="mb-3">
                                        <label for="contact_email" class="form-label">E-posta</label>
                                        <input type="email" class="form-control" id="contact_email" name="contact_email" value="<?= $settings['contact_email'] ?? 'info@restoranmenu.com'; ?>">
                                    </div>
                                </div>
                                
                                <!-- Sosyal Medya Ayarları -->
                                <div class="tab-pane fade" id="social" role="tabpanel" aria-labelledby="social-tab">
                                    <div class="mb-3">
                                        <label for="social_facebook" class="form-label">Facebook</label>
                                        <div class="input-group">
                                            <span class="input-group-text"><i class="fab fa-facebook"></i></span>
                                            <input type="text" class="form-control" id="social_facebook" name="social_facebook" value="<?= $settings['social_facebook'] ?? ''; ?>" placeholder="https://facebook.com/restoranmenu">
                                        </div>
                                    </div>
                                    
                                    <div class="mb-3">
                                        <label for="social_instagram" class="form-label">Instagram</label>
                                        <div class="input-group">
                                            <span class="input-group-text"><i class="fab fa-instagram"></i></span>
                                            <input type="text" class="form-control" id="social_instagram" name="social_instagram" value="<?= $settings['social_instagram'] ?? ''; ?>" placeholder="https://instagram.com/restoranmenu">
                                        </div>
                                    </div>
                                    
                                    <div class="mb-3">
                                        <label for="social_twitter" class="form-label">Twitter</label>
                                        <div class="input-group">
                                            <span class="input-group-text"><i class="fab fa-twitter"></i></span>
                                            <input type="text" class="form-control" id="social_twitter" name="social_twitter" value="<?= $settings['social_twitter'] ?? ''; ?>" placeholder="https://twitter.com/restoranmenu">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="mt-4">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-save me-1"></i> Ayarları Kaydet
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </main>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="../assets/js/admin.js"></script>
    <script>
        // Slider sayısı değiştiğinde sayfayı yenile
        document.getElementById('slider_count').addEventListener('change', function() {
            const form = this.closest('form');
            const sliderCountInput = document.createElement('input');
            sliderCountInput.type = 'hidden';
            sliderCountInput.name = 'update_slider_count';
            sliderCountInput.value = '1';
            form.appendChild(sliderCountInput);
            form.submit();
        });
        
        // Resim önizleme
        document.addEventListener('DOMContentLoaded', function() {
            // Logo önizleme
            const logoInput = document.getElementById('logo_image');
            if (logoInput) {
                logoInput.addEventListener('change', function(e) {
                    previewImage(this, 'logo_image-preview');
                });
            }
            
            // Favicon önizleme
            const faviconInput = document.getElementById('favicon_image');
            if (faviconInput) {
                faviconInput.addEventListener('change', function(e) {
                    previewImage(this, 'favicon_image-preview');
                });
            }
            
            // Slider resimleri önizleme
            for (let i = 1; i <= <?= $slider_count; ?>; i++) {
                const sliderInput = document.getElementById(`slider${i}_image`);
                if (sliderInput) {
                    sliderInput.addEventListener('change', function(e) {
                        previewImage(this, `slider${i}_image-preview`);
                    });
                }
            }
            
            // Resim önizleme fonksiyonu
            function previewImage(input, previewId) {
                const file = input.files[0];
                if (file) {
                    const reader = new FileReader();
                    reader.onload = function(e) {
                        let previewContainer = document.getElementById(previewId);
                        if (!previewContainer) {
                            previewContainer = document.createElement('div');
                            previewContainer.id = previewId;
                            previewContainer.className = 'mt-2';
                            input.parentNode.appendChild(previewContainer);
                        }
                        previewContainer.innerHTML = `<img src="${e.target.result}" class="img-thumbnail" style="max-width: 200px;">`;
                    }
                    reader.readAsDataURL(file);
                }
            }
        });
    </script>
</body>
</html>