<?php
session_start();
require_once '../config/db.php';
require_once '../includes/functions.php';

// Admin giriş kontrolü
if (!isLoggedIn()) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit;
}

// JSON verilerini al
$json = file_get_contents('php://input');
$data = json_decode($json, true);

if (!$data || !isset($data['ids']) || !is_array($data['ids']) || !isset($data['category_id'])) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'Invalid data']);
    exit;
}

// Ürün sıralamasını güncelle
$success = true;

try {
    $conn->beginTransaction();
    
    foreach ($data['ids'] as $index => $id) {
        $stmt = $conn->prepare("UPDATE products SET sort_order = :sort_order WHERE id = :id AND category_id = :category_id");
        $stmt->bindParam(':sort_order', $index, PDO::PARAM_INT);
        $stmt->bindParam(':id', $id, PDO::PARAM_INT);
        $stmt->bindParam(':category_id', $data['category_id'], PDO::PARAM_INT);
        $stmt->execute();
    }
    
    $conn->commit();
} catch (Exception $e) {
    if ($conn->inTransaction()) {
        $conn->rollBack();
    }
    $success = false;
    error_log("Ürün sıralama hatası: " . $e->getMessage());
}

// Sonucu döndür
header('Content-Type: application/json');
echo json_encode(['success' => $success]);