<?php
// Site ayarlarını getir
$siteSettings = getSiteSettings($conn);
$siteTitle = $siteSettings['site_title'] ?? 'Restoran Menü';
$logoImage = $siteSettings['logo_image'] ?? '';
$faviconImage = $siteSettings['favicon_image'] ?? '';

// Tüm kategorileri getir
$headerCategories = getCategories($conn);
?>
<!-- Navbar -->
<nav class="navbar navbar-expand-lg navbar-dark bg-dark">
    <div class="container">
        <a class="navbar-brand" href="index.php">
            <?php if (!empty($logoImage)): ?>
                <?php if (filter_var($logoImage, FILTER_VALIDATE_URL)): ?>
                    <img src="<?= $logoImage; ?>" alt="<?= $siteTitle; ?>" height="30">
                <?php else: ?>
                    <img src="uploads/<?= $logoImage; ?>?v=<?= time(); ?>" alt="<?= $siteTitle; ?>" height="30">
                <?php endif; ?>
            <?php else: ?>
                <i class="fas fa-utensils me-2"></i><?= $siteTitle; ?>
            <?php endif; ?>
        </a>
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navbarNav">
            <ul class="navbar-nav">
                <li class="nav-item">
                    <a class="nav-link <?= basename($_SERVER['PHP_SELF']) == 'index.php' ? 'active' : ''; ?>" href="index.php">
                        <i class="fas fa-home me-1"></i> Ana Sayfa
                    </a>
                </li>
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                        <i class="fas fa-list me-1"></i> Kategoriler
                    </a>
                    <ul class="dropdown-menu" aria-labelledby="navbarDropdown">
                        <?php foreach($headerCategories as $cat): ?>
                        <li>
                            <a class="dropdown-item" href="kategori/<?= $cat['id']; ?>-<?= $cat['slug']; ?>.html">
                                <?= $cat['name']; ?>
                            </a>
                        </li>
                        <?php endforeach; ?>
                    </ul>
                </li>
            </ul>
            <ul class="navbar-nav ms-auto">
                <li class="nav-item">
                    <a class="nav-link" href="admin/index.php">
                        <i class="fas fa-user-cog me-1"></i> Yönetim
                    </a>
                </li>
            </ul>
        </div>
    </div>
</nav>