<?php
// LISANS_KODU_BURADA
session_start();
require_once 'config/db.php';
require_once 'includes/functions.php';

// Güvenlik için HTTP başlıkları
header("X-XSS-Protection: 1; mode=block");
header("X-Content-Type-Options: nosniff");
header("X-Frame-Options: SAMEORIGIN");
header("Referrer-Policy: strict-origin-when-cross-origin");

// Cache control headers to prevent browser caching
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache");

// Ana sayfa için kategorileri ve ürünleri getir
$categories = getCategories($conn);

// Site ayarlarını getir
$siteSettings = getSiteSettings($conn);
$siteTitle = $siteSettings['site_title'] ?? 'Restoran Menü';
$siteDescription = $siteSettings['site_description'] ?? 'Lezzetli yemeklerimizi keşfedin';
$logoImage = $siteSettings['logo_image'] ?? '';
$faviconImage = $siteSettings['favicon_image'] ?? '';
$headerColor = $siteSettings['header_color'] ?? '#212529';
$footerColor = $siteSettings['footer_color'] ?? '#212529';
$showHeader = $siteSettings['show_header'] ?? '1';
$showFooter = $siteSettings['show_footer'] ?? '1';
$showFeatured = $siteSettings['show_featured'] ?? '1';
$showSlider = $siteSettings['show_slider'] ?? '1';
$sliderAutoplay = $siteSettings['slider_autoplay'] ?? '1';
$sliderInterval = $siteSettings['slider_interval'] ?? '5000';
$sliderCount = isset($siteSettings['slider_count']) ? intval($siteSettings['slider_count']) : 1;

// Öne çıkan ürünleri getir
$featuredProducts = getFeaturedProducts($conn);
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= safeOutput($siteTitle); ?></title>
    <meta name="description" content="<?= safeOutput($siteDescription); ?>">
    <?php if (!empty($faviconImage)): ?>
        <?php if (filter_var($faviconImage, FILTER_VALIDATE_URL)): ?>
            <link rel="icon" href="<?= safeOutput($faviconImage); ?>" type="image/x-icon">
            <link rel="shortcut icon" href="<?= safeOutput($faviconImage); ?>" type="image/x-icon">
        <?php else: ?>
            <link rel="icon" href="uploads/<?= safeOutput($faviconImage); ?>?v=<?= time(); ?>" type="image/x-icon">
            <link rel="shortcut icon" href="uploads/<?= safeOutput($faviconImage); ?>?v=<?= time(); ?>" type="image/x-icon">
        <?php endif; ?>
    <?php else: ?>
        <link rel="icon" href="assets/img/favicon.ico" type="image/x-icon">
        <link rel="shortcut icon" href="assets/img/favicon.ico" type="image/x-icon">
    <?php endif; ?>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link rel="stylesheet" href="assets/css/style.css">
    <style>
        .header-custom {
            background-color: <?= $headerColor; ?>;
        }
        .footer-custom {
            background-color: <?= $footerColor; ?>;
        }
    </style>
</head>
<body>
    <?php if ($showHeader == '1'): ?>
    <!-- Basit Logo Header -->
    <div class="text-center py-3 header-custom">
        <div class="container">
            <?php if (!empty($logoImage)): ?>
                <?php if (filter_var($logoImage, FILTER_VALIDATE_URL)): ?>
                    <img src="<?= safeOutput($logoImage); ?>" alt="<?= safeOutput($siteTitle); ?>" class="logo-img">
                <?php else: ?>
                    <img src="uploads/<?= safeOutput($logoImage); ?>?v=<?= time(); ?>" alt="<?= safeOutput($siteTitle); ?>" class="logo-img">
                <?php endif; ?>
            <?php else: ?>
                <h1 class="text-white fs-3"><i class="fas fa-utensils me-2"></i><?= safeOutput($siteTitle); ?></h1>
            <?php endif; ?>
        </div>
    </div>
    <?php endif; ?>

    <?php if ($showSlider == '1' && $sliderCount > 0): ?>
    <!-- Ana Slider -->
    <div class="main-slider">
        <div class="slider-wrapper">
            <!-- Slider ayarlarını gizli input olarak ekle -->
            <input type="hidden" class="slider-autoplay" value="<?= $sliderAutoplay; ?>">
            <input type="hidden" class="slider-interval" value="<?= $sliderInterval; ?>">
            
            <?php for ($i = 1; $i <= $sliderCount; $i++): ?>
                <?php
                $sliderTitle = $siteSettings["slider{$i}_title"] ?? '';
                $sliderDescription = $siteSettings["slider{$i}_description"] ?? '';
                $sliderButtonText = $siteSettings["slider{$i}_button_text"] ?? '';
                $sliderUrl = $siteSettings["slider{$i}_url"] ?? '#';
                $sliderImage = $siteSettings["slider{$i}_image"] ?? '';
                ?>
                <div class="slider-item <?= $i == 1 ? 'active' : ''; ?>" data-index="<?= $i-1; ?>">
                    <div class="slider-container">
                        <?php if (!empty($sliderImage)): ?>
                            <?php if (filter_var($sliderImage, FILTER_VALIDATE_URL)): ?>
                                <img src="<?= safeOutput($sliderImage); ?>" alt="<?= safeOutput($sliderTitle); ?>" class="slider-image">
                            <?php else: ?>
                                <img src="uploads/<?= safeOutput($sliderImage); ?>?v=<?= time(); ?>" alt="<?= safeOutput($sliderTitle); ?>" class="slider-image">
                            <?php endif; ?>
                        <?php else: ?>
                            <img src="https://images.unsplash.com/photo-1517248135467-4c7edcad34c4?q=80&w=1200" alt="Default Slider" class="slider-image">
                        <?php endif; ?>
                        <div class="slider-overlay"></div>
                        <div class="slider-content">
                            <h2 class="slider-title"><?= safeOutput($sliderTitle); ?></h2>
                            <p class="slider-description"><?= safeOutput($sliderDescription); ?></p>
                            <?php if (!empty($sliderButtonText)): ?>
                                <a href="<?= safeOutput($sliderUrl); ?>" class="btn btn-primary slider-button"><?= safeOutput($sliderButtonText); ?></a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            <?php endfor; ?>
            
            <?php if ($sliderCount > 1): ?>
            <div class="slider-controls">
                <div class="slider-dots">
                    <?php for ($i = 1; $i <= $sliderCount; $i++): ?>
                        <div class="slider-dot <?= $i == 1 ? 'active' : ''; ?>" data-index="<?= $i-1; ?>"></div>
                    <?php endfor; ?>
                </div>
            </div>
            
            <div class="slider-arrows">
                <button class="slider-arrow prev" id="sliderPrev">
                    <i class="fas fa-chevron-left"></i>
                </button>
                <button class="slider-arrow next" id="sliderNext">
                    <i class="fas fa-chevron-right"></i>
                </button>
            </div>
            <?php endif; ?>
        </div>
    </div>
    <?php endif; ?>

    <div class="container mt-4">
        <div class="row justify-content-center">
            <div class="col-12 col-md-10 col-lg-8 text-center mb-4">
                <p class="lead"><?= safeOutput($siteDescription); ?></p>
            </div>
        </div>

        <!-- Öne Çıkan Ürünler - Kaydırılabilir -->
        <?php if($showFeatured == '1' && count($featuredProducts) > 0): ?>
        <div class="featured-section mb-5">
            <h2 class="text-center featured-title">Öne Çıkan Ürünlerimiz</h2>
            <div class="featured-products-container">
                <div class="featured-controls prev" id="prevBtn">
                    <i class="fas fa-chevron-left"></i>
                </div>
                <div class="featured-controls next" id="nextBtn">
                    <i class="fas fa-chevron-right"></i>
                </div>
                <div class="row flex-nowrap overflow-auto pb-3" id="featuredSlider">
                    <?php foreach($featuredProducts as $product): ?>
                    <div class="col-6 col-md-3 mb-4">
                        <div class="card featured-card h-100 mx-2">
                            <span class="featured-badge">Öne Çıkan</span>
                            <?php if(!empty($product['image'])): ?>
                                <img src="uploads/<?= safeOutput($product['image']); ?>?v=<?= time(); ?>" class="card-img-top" alt="<?= safeOutput($product['name']); ?>">
                            <?php else: ?>
                                <img src="https://images.unsplash.com/photo-1546069901-ba9599a7e63c?q=80&w=500" class="card-img-top" alt="<?= safeOutput($product['name']); ?>">
                            <?php endif; ?>
                            <div class="card-body">
                                <span class="category-tag"><?= safeOutput($product['category_name']); ?></span>
                                <h5 class="card-title"><?= safeOutput($product['name']); ?></h5>
                                <p class="price"><?= number_format($product['price'], 2); ?> ₺</p>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
        <?php endif; ?>

        <!-- Kategori Navigasyonu -->
        <div class="category-section mb-5">
            <h2 class="text-center category-title-main">Menü Kategorileri</h2>
            <div class="row justify-content-center">
                <?php foreach($categories as $category): ?>
                <div class="col-6 col-md-3 mb-4">
                    <a href="kategori/<?= $category['id']; ?>-<?= $category['slug']; ?>.html" class="category-card">
                        <div class="card text-center h-100">
                            <div class="category-img-container">
                                <?php 
                                if (!empty($category['image'])) {
                                    if (filter_var($category['image'], FILTER_VALIDATE_URL)) {
                                        // Unsplash veya harici URL
                                        $imgUrl = $category['image'];
                                    } else {
                                        // Yüklenmiş resim
                                        $imgUrl = "uploads/" . $category['image'] . "?v=" . time();
                                    }
                                } else {
                                    // Varsayılan resim
                                    $imgUrl = getCategoryDefaultImage($category['name']);
                                }
                                ?>
                                <img src="<?= safeOutput($imgUrl); ?>" class="card-img-top" alt="<?= safeOutput($category['name']); ?>">
                                <div class="category-overlay">
                                    <h3 class="category-title"><?= safeOutput($category['name']); ?></h3>
                                </div>
                            </div>
                        </div>
                    </a>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>

    <?php if ($showFooter == '1'): ?>
    <?php include 'includes/footer.php'; ?>
    <?php endif; ?>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="assets/js/main.js"></script>
</body>
</html>